/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.internal.iiop;

import com.sun.corba.se.internal.corba.ClientDelegate;
import com.sun.corba.se.internal.corba.EncapsInputStream;
import com.sun.corba.se.internal.corba.EncapsOutputStream;
import com.sun.corba.se.internal.corba.ServerDelegate;
import com.sun.corba.se.internal.core.ClientGIOP;
import com.sun.corba.se.internal.core.ClientSubcontract;
import com.sun.corba.se.internal.core.CodeSetServiceContext;
import com.sun.corba.se.internal.core.DuplicateServiceContext;
import com.sun.corba.se.internal.core.EndPoint;
import com.sun.corba.se.internal.core.IOR;
import com.sun.corba.se.internal.core.InternalRuntimeForwardRequest;
import com.sun.corba.se.internal.core.MarshalInputStream;
import com.sun.corba.se.internal.core.MarshalOutputStream;
import com.sun.corba.se.internal.core.NoSuchServiceContext;
import com.sun.corba.se.internal.core.ORBVersionServiceContext;
import com.sun.corba.se.internal.core.RequestHandler;
import com.sun.corba.se.internal.core.SendingContextServiceContext;
import com.sun.corba.se.internal.core.ServerGIOP;
import com.sun.corba.se.internal.core.ServerRequest;
import com.sun.corba.se.internal.core.ServerResponse;
import com.sun.corba.se.internal.core.ServerSubcontract;
import com.sun.corba.se.internal.core.ServiceContextRegistry;
import com.sun.corba.se.internal.core.SubcontractRegistry;
import com.sun.corba.se.internal.core.UEInfoServiceContext;
import com.sun.corba.se.internal.iiop.Connection;
import com.sun.corba.se.internal.iiop.GIOPImpl;
import com.sun.corba.se.internal.iiop.IIOPOutputStream;
import com.sun.corba.se.internal.iiop.RequestCanceledException;
import com.sun.corba.se.internal.iiop.ShutdownUtilDelegate;
import com.sun.corba.se.internal.iiop.messages.ReplyMessage;
import com.sun.corba.se.internal.ior.ObjectKey;
import com.sun.corba.se.internal.ior.TaggedComponentFactories;
import java.net.InetAddress;
import java.util.Collection;
import java.util.Iterator;
import org.omg.CORBA.Any;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.NVList;
import org.omg.CORBA.OBJ_ADAPTER;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TRANSIENT;
import org.omg.CORBA.UNKNOWN;
import org.omg.CORBA.portable.ObjectImpl;

public class ORB
extends com.sun.corba.se.internal.corba.ORB
implements RequestHandler {
    protected SubcontractRegistry subcontractRegistry;
    protected GIOPImpl giopTransport;
    protected int transientServerId = 0;
    protected ThreadGroup threadGroup;
    protected ServiceContextRegistry scr;
    private static final int GENERIC = 2;
    private static String localHostString = null;

    public int getTransientServerId() {
        return this.transientServerId;
    }

    public ORB() {
        TaggedComponentFactories.registerFactories();
        this.threadGroup = Thread.currentThread().getThreadGroup();
        this.transientServerId = (int)System.currentTimeMillis();
        if (ORBInitDebug) {
            this.dprint("Creating service context registry");
        }
        this.scr = new ServiceContextRegistry(this);
        if (ORBInitDebug) {
            this.dprint("Registering service context classes");
        }
        try {
            this.scr.register(UEInfoServiceContext.class);
            this.scr.register(CodeSetServiceContext.class);
            this.scr.register(SendingContextServiceContext.class);
            this.scr.register(ORBVersionServiceContext.class);
        }
        catch (DuplicateServiceContext duplicateServiceContext) {
            if (ORBInitDebug) {
                this.dprint("Duplicate service context registration error");
            }
            throw new INTERNAL("Duplicate Service Context error");
        }
        catch (NoSuchServiceContext noSuchServiceContext) {
            if (ORBInitDebug) {
                this.dprint("No such service context registration error");
            }
            throw new INTERNAL("Error in service context class definition");
        }
        this.subcontractRegistry = new SubcontractRegistry(this, 2);
        ServerDelegate serverDelegate = new ServerDelegate(this);
        serverDelegate.setId(2);
        this.subcontractRegistry.registerServer(serverDelegate, 2);
        this.subcontractRegistry.registerBootstrapServer(serverDelegate);
        this.subcontractRegistry.registerClient(ClientDelegate.class, 2);
        this.giopTransport = new GIOPImpl(this, this);
    }

    protected void cleanupServerPIRequest() {
        super.cleanupServerPIRequest();
    }

    protected void destroyConnections() {
        this.giopTransport.destroyConnections();
    }

    protected void invokeServerPIIntermediatePoint() throws InternalRuntimeForwardRequest {
        super.invokeServerPIIntermediatePoint();
    }

    protected void invokeServerPIStartingPoint() throws InternalRuntimeForwardRequest {
        super.invokeServerPIStartingPoint();
    }

    protected void sendCancelRequestIfFinalFragmentNotSent() {
        super.sendCancelRequestIfFinalFragmentNotSent();
    }

    public boolean isLocalServerPort(int n2) {
        Collection collection = this.giopTransport.getServerEndpoints();
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                EndPoint endPoint = (EndPoint)iterator.next();
                if (endPoint.getPort() != n2) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isLocalServerId(int n2, int n3) {
        return n3 == this.transientServerId;
    }

    protected void shutdownServants(boolean bl2) {
        if (ShutdownUtilDelegate.instance != null) {
            ShutdownUtilDelegate.instance.unregisterTargetsForORB(this);
        }
    }

    public ClientGIOP getClientGIOP() {
        return this.giopTransport;
    }

    public MarshalInputStream newInputStream() {
        return new EncapsInputStream(this);
    }

    public MarshalInputStream newInputStream(byte[] byArray, int n2) {
        return new EncapsInputStream(this, byArray, n2);
    }

    public MarshalInputStream newInputStream(byte[] byArray, int n2, boolean bl2) {
        return new EncapsInputStream((org.omg.CORBA.ORB)this, byArray, n2, bl2);
    }

    public MarshalOutputStream newOutputStream() {
        return new EncapsOutputStream(this);
    }

    public ServerGIOP getServerGIOP() {
        return this.giopTransport;
    }

    public ServiceContextRegistry getServiceContextRegistry() {
        return this.scr;
    }

    public SubcontractRegistry getSubcontractRegistry() {
        return this.subcontractRegistry;
    }

    protected void invokeServerPIEndingPoint(ReplyMessage replyMessage) throws InternalRuntimeForwardRequest {
        super.invokeServerPIEndingPoint(replyMessage);
    }

    protected void setServerPIInfo(Exception exception) {
        super.setServerPIInfo(exception);
    }

    private synchronized String getLocalHostName() {
        if (localHostString == null) {
            try {
                localHostString = InetAddress.getLocalHost().getHostAddress();
            }
            catch (Exception exception) {
                throw new INTERNAL(1398079696, CompletionStatus.COMPLETED_NO);
            }
        }
        return localHostString;
    }

    public int getServerPort(String string) {
        return this.giopTransport.getServerPort(string);
    }

    public boolean isLocalHost(String string) {
        return string.equals(this.getORBServerHost()) || string.equals(this.getLocalHostName());
    }

    protected void setServerPIExceptionInfo(Any any) {
        super.setServerPIExceptionInfo(any);
    }

    protected void setServerPIInfo(Any any) {
        super.setServerPIInfo(any);
    }

    protected void setServerPIInfo(NVList nVList) {
        super.setServerPIInfo(nVList);
    }

    public IOR locate(ObjectKey objectKey) {
        ServerSubcontract serverSubcontract = this.subcontractRegistry.getServerSubcontract(objectKey);
        if (serverSubcontract == null) {
            return null;
        }
        return serverSubcontract.locate(objectKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerResponse process(ServerRequest serverRequest) {
        Object object;
        Object object2;
        this.checkShutdownState();
        if (this.subcontractDebugFlag) {
            object2 = serverRequest.getObjectKey();
            object = ((ObjectKey)object2).getTemplate();
            this.dprint("process: dispatching to scid " + object.getSubcontractId());
        }
        object2 = this.subcontractRegistry.getServerSubcontract(serverRequest.getObjectKey());
        if (this.subcontractDebugFlag) {
            this.dprint("dispatching to sc " + object2);
        }
        if (object2 == null) {
            object = new OBJ_ADAPTER(1398079689, CompletionStatus.COMPLETED_NO);
            return serverRequest.createSystemExceptionResponse((SystemException)object, null);
        }
        try {
            this.startingDispatch();
            try {
                object = object2.dispatch(serverRequest);
                return object;
            }
            catch (Throwable throwable) {
                ServerResponse serverResponse = this.handleThrowableDuringServerDispatch(serverRequest, throwable, CompletionStatus.COMPLETED_MAYBE);
                this.finishedDispatch();
                return serverResponse;
            }
        }
        finally {
            this.finishedDispatch();
        }
    }

    public IIOPOutputStream newOutputStream(Connection connection) {
        return new IIOPOutputStream(this.getGIOPVersion(), this, connection);
    }

    protected void initializeServerPIInfo(ServerRequest serverRequest, Object object, byte[] byArray, byte[] byArray2) {
        super.initializeServerPIInfo(serverRequest, object, byArray, byArray2);
    }

    protected void setServerPIInfo(Object object, String string) {
        super.setServerPIInfo(object, string);
    }

    public SystemException convertThrowableToSystemException(Throwable throwable, CompletionStatus completionStatus) {
        if (throwable instanceof SystemException) {
            return (SystemException)throwable;
        }
        if (throwable instanceof RequestCanceledException) {
            return new TRANSIENT("RequestCanceled", 1330446339, CompletionStatus.COMPLETED_NO);
        }
        String string = "Unknown Application exception on server: " + throwable.getClass().getName();
        return new UNKNOWN(string, 1398079690, completionStatus);
    }

    public ServerResponse handleThrowableDuringServerDispatch(ServerRequest serverRequest, Throwable throwable, CompletionStatus completionStatus) {
        return this.handleThrowableDuringServerDispatch(serverRequest, throwable, completionStatus, 1);
    }

    private ServerResponse handleThrowableDuringServerDispatch(ServerRequest serverRequest, Throwable throwable, CompletionStatus completionStatus, int n2) {
        if (n2 > 10) {
            throw new RuntimeException("handleThrowableDuringServerDispatch: cannot create response.");
        }
        try {
            if (throwable instanceof InternalRuntimeForwardRequest) {
                ObjectImpl objectImpl = (ObjectImpl)((InternalRuntimeForwardRequest)throwable).forward;
                ClientSubcontract clientSubcontract = (ClientSubcontract)((Object)objectImpl._get_delegate());
                return serverRequest.createLocationForward(clientSubcontract.marshal(), null);
            }
            SystemException systemException = this.convertThrowableToSystemException(throwable, completionStatus);
            return serverRequest.createSystemExceptionResponse(systemException, null);
        }
        catch (Throwable throwable2) {
            return this.handleThrowableDuringServerDispatch(serverRequest, throwable2, completionStatus, n2 + 1);
        }
    }
}

