/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 1999-2000 by Matthias Kiefer
                            <matthias.kiefer@gmx.de>
		2002	  by Stanislav Visnovsky <visnovsky@kde.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

**************************************************************************** */
#ifndef CATALOGITEMPRIVATE_H
#define CATALOGITEMPRIVATE_H

#include <qstringlist.h>

/**
* This class represents data for an entry in a catalog.
* It contains the comment, the Msgid and the Msgstr.
* It defines some functions to query the state of the entry
* (fuzzy, untranslated, cformat).
*
* @short Class, representing an entry in a catalog
* @author Matthias Kiefer <matthias.kiefer@gmx.de>
* @author Stanislav Visnovsky <visnovsky@kde.org>
*/
class CatalogItemPrivate
{

public:

   QString _comment;
   QStringList _msgid;
   QStringList _msgstr;

   QStringList _tagList;
   QStringList _argList;

   bool _valid;
   bool _haveTagList;
   bool _haveArgList;
   int _error;

   /** flag, if this entry is a plural forms entry */
   bool _gettextPluralForm;
   
   friend class CatalogItem;
   
   CatalogItemPrivate()
   {
	_comment = "";
	_msgid.clear();
	_msgstr.clear();
	_tagList.clear();
	_argList.clear();
	_valid=false;
	_haveTagList=false;
	_haveArgList=false;
	_error=false;
	_gettextPluralForm=false;
   }
};

#endif // CATALOGITEMPRIVATE_H
