/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2000-2001 by Andreas Zehender
    email                : zehender@kde.org
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/


#include "pmnamedobject.h"
#include "pmoutputdevice.h"
#include "pmxmlhelper.h"
#include "pmmemento.h"

#include <kdebug.h>
#include "pmglobals.h"

PMNamedObject::PMNamedObject( )
      : Base( )
{
}

PMNamedObject::~PMNamedObject( )
{
}

bool PMNamedObject::isA( PMObjectType t ) const
{
   if( t == PMTNamedObject )
      return true;
   return Base::isA( t );
}

void PMNamedObject::serialize( PMOutputDevice& dev ) const
{
   Base::serialize( dev );
}

void PMNamedObject::serializeName( PMOutputDevice& dev ) const
{
   if( !m_name.isEmpty( ) )
      dev.writeLine( QString( "//*PMName " ) + m_name );
}

void PMNamedObject::serialize( QDomElement& e, QDomDocument& doc ) const
{
   e.setAttribute( "name", m_name );
   Base::serialize( e, doc );
}

void PMNamedObject::readAttributes( const PMXMLHelper& h )
{
   m_name = h.stringAttribute( "name", "" );
   Base::readAttributes( h );
}

void PMNamedObject::setName( const QString& newName )
{
   if( newName != m_name )
   {
      if( m_pMemento )
      {
         m_pMemento->addData( PMTNamedObject, PMNameID, m_name );
         m_pMemento->setDescriptionChanged( );
      }
         
      m_name = newName;
   }
}

void PMNamedObject::restoreMemento( PMMemento* s )
{
   PMMementoDataIterator it( s );
   PMMementoData* data;

   for( ; it.current( ); ++it )
   {
      data = it.current( );
      if( data->objectType( ) == PMTNamedObject )
      {
         switch( data->valueID( ) )
         {
            case PMNameID:
               setName( data->stringData( ) );
               break;
            default:
               kdError( PMArea ) << "Wrong ID in PMNamedObject::restoreMemento\n";
               break;
         }
      }
   }
   Base::restoreMemento( s );
}
