/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2000-2002 by Andreas Zehender
    email                : zehender@kde.org
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/


#include "pmgraphicalobject.h"
#include "pmoutputdevice.h"
#include "pmxmlhelper.h"
#include "pmmemento.h"

#include <kdebug.h>
#include "pmglobals.h"

const bool c_defaultNoShadow = false;
const int c_defaultVisibilityLevel = 0;
const bool c_defaultRelativeVisibility = true;


PMGraphicalObject::PMGraphicalObject( )
      : Base( )
{
   m_noShadow = c_defaultNoShadow;
   m_visibilityLevel = c_defaultVisibilityLevel;
   m_relativeVisibility = c_defaultRelativeVisibility;
}

PMGraphicalObject::~PMGraphicalObject( )
{
}

bool PMGraphicalObject::isA( PMObjectType t ) const
{
   if( t == PMTGraphicalObject )
      return true;
   return Base::isA( t );
}

void PMGraphicalObject::serialize( PMOutputDevice& dev ) const
{
   Base::serialize( dev );
   if( m_noShadow )
      dev.writeLine( "no_shadow" );
}

void PMGraphicalObject::serialize( QDomElement& e, QDomDocument& doc ) const
{
   e.setAttribute( "no_shadow", m_noShadow );
   e.setAttribute( "visibility_level", m_visibilityLevel );
   e.setAttribute( "relative_visibility", m_relativeVisibility );
   Base::serialize( e, doc );
}

void PMGraphicalObject::readAttributes( const PMXMLHelper& h )
{
   m_noShadow = h.boolAttribute( "no_shadow", c_defaultNoShadow );
   m_visibilityLevel = h.intAttribute( "visibility_level",
                                       c_defaultVisibilityLevel );
   m_relativeVisibility = h.boolAttribute( "relative_visibility",
                                           c_defaultRelativeVisibility );
   Base::readAttributes( h );
}

bool PMGraphicalObject::canInsert( PMObjectType t, const PMObject*,
                                   const PMObjectList* ) const
{
   switch( t )
   {
      case PMTComment:
      case PMTRaw:
      case PMTTranslate:
      case PMTRotate:
      case PMTScale:
      case PMTMatrix:
      case PMTTexture:
      case PMTPigment:
      case PMTNormal:
      case PMTFinish:
      case PMTInterior:
      case PMTMaterial:
      case PMTBoundedBy:
      case PMTClippedBy:
         return true;
         break;
      default:
         break;
   }
   return false;
}

void PMGraphicalObject::setNoShadow( bool yes )
{
   if( m_noShadow != yes )
   {
      if( m_pMemento )
         m_pMemento->addData( PMTGraphicalObject, PMNoShadowID, m_noShadow );
      m_noShadow = yes;
   }
}   

void PMGraphicalObject::setVisibilityLevel( int level )
{
   if( m_visibilityLevel != level )
   {
      if( m_pMemento )
      {
         m_pMemento->addData( PMTGraphicalObject, PMVisibilityID,
                              m_visibilityLevel );
         // do not call PMCompositeObject::setViewStructureChanged because
         // the view structure has not really changed.
         // Only the scene has to be rendered.
         m_pMemento->setViewStructureChanged( );
      }
      m_visibilityLevel = level;
   }
}

void PMGraphicalObject::setVisibilityLevelRelative( bool relative )
{
   if( m_relativeVisibility != relative )
   {
      if( m_pMemento )
         m_pMemento->addData( PMTGraphicalObject, PMRelativeVisibilityID,
                              m_relativeVisibility );
      m_relativeVisibility = relative;
   }
}

void PMGraphicalObject::restoreMemento( PMMemento* s )
{
   PMMementoDataIterator it( s );
   PMMementoData* data;

   for( ; it.current( ); ++it )
   {
      data = it.current( );
      if( data->objectType( ) == PMTGraphicalObject )
      {
         switch( data->valueID( ) )
         {
            case PMNoShadowID:
               setNoShadow( data->boolData( ) );
               break;
            case PMVisibilityID:
               setVisibilityLevel( data->intData( ) );
               break;
            case PMRelativeVisibilityID:
               setVisibilityLevelRelative( data->boolData( ) );
               break;
            default:
               kdError( PMArea ) << "Wrong ID in PMGraphicalObject::restoreMemento\n";
               break;
         }
      }
   }
   Base::restoreMemento( s );
}
