// -*- c++ -*-

/*
 *  Copyright (C) 2001-2002, Richard J. Moore <rich@kde.org>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 *  Boston, MA 02111-1307, USA.
 */

#ifndef KJSEMBEDMESSAGELOG_H
#define KJSEMBEDMESSAGELOG_H

#include <qmultilineedit.h>

class KProcess;
class KShellProcess;

namespace KJSEmbed {

/**
 * A widget for displaying a message log.
 *
 * @author Richard Moore, rich@kde.org
 * @version $Id: messagelogwidget.h,v 1.3 2002/03/08 18:53:34 rich Exp $
 */
class MessageLogWidget : public QMultiLineEdit
{
    Q_OBJECT

public:
    MessageLogWidget( QWidget *parent, const char *name=0 );
    ~MessageLogWidget();

    QString lastMessage() const;

    bool run( const QString &cmd );

public slots:
    /**
     * Displays msg in the message window using the base style.
     */
    void message( const QString &msg );

    /**
     * Displays msg in the message window using the error style.
     */
    void error( const QString &msg );

    /** 
     * Displays msg in the message window without applying a style.
     */
    void raw( const QString &msg );

    void childExited();
    void receivedStdOutput(KProcess *, char *, int);
    void receivedStdError(KProcess *, char *, int);

private:
    QString msg;
    KShellProcess *proc;
    class Private *d;
};

}; // namespace KJSEmbed

#endif // KJSEMBEDMESSAGELOG_H

// Local Variables:
// c-basic-offset: 4
// End:

