/***************************************************************************
                            KFileFilterCombo.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KFILEFILTERCOMBO_H
#define KFILEFILTERCOMBO_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/KComboBox.h>

@interface KFileFilterCombo : KComboBox 
- initWithWidget: (QWidget *)parent name: (NSString *)name;
- init;
- (void) dealloc;
- setFilter: (NSString *)filter;

/** 

*/
- (NSString *) currentFilter;

/** 
 Sets a list of mimetypes.
 If @p defaultType is set, it will be set as the current item.
 Otherwise, a first item showing all the mimetypes will be created.
     
*/
- setMimeFilter: (NSArray *)types defaultType: (NSString *)defaultType;

/** 

*/
- (BOOL) showsAllTypes;

/** 
 This method allows you to set a default-filter, that is used when an
 empty filter is set. Make sure you call this before calling
 @ref -setFilter.

 By default, this is set to i18n("*|All Files")

*/
- setDefaultFilter: (NSString *)filter;

/** 

*/
- (NSString *) defaultFilter;
- (BOOL) eventFilter: (QObject *)o e: (QEvent *)e;
@end

/** Override these methods in subclasses of KFileFilterCombo to customise event handling behaviour */
@protocol KFileFilterComboEventHandling
- keyPressEvent:(QKeyEvent*) e;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- focusInEvent:(QFocusEvent*) e;
- imEndEvent:(QIMEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- moveEvent:(QMoveEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;
- hideEvent:(QHideEvent*) arg1;
- imStartEvent:(QIMEvent*) arg1;
- closeEvent:(QCloseEvent*) arg1;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
- resizeEvent:(QResizeEvent*) arg1;
@end


#endif
