/***************************************************************************
                            KURIFilter.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Manages the filtering of a URI.

 The intention of this plugin class is to allow people to extend
 the functionality of KURL without modifying it directly.  This
 way KURL will remain a generic parser capable of parsing any
 generic URL that adheres to specifications.

 The KURIFilter class applies a number of filters to a URI,
 and returns the filtered version whenever possible. The filters
 are implemented using plugins to provide easy extensibility
 of the filtering mechanism.  That is, new filters can be added in
 the future by simply inheriting from {@link KURIFilterPlugin} and
 implementing the {@link KURIFilterPlugin#filterURI} method.

 Use of this plugin-manager class is straight forward.  Since
 it is a singleton object, all you have to do is obtain an instance
 by doing <code>KURIFilter.self</code>() and use any of the public member
 functions to preform the filtering.

 To simply filter a given string:
 <pre>
 boolean filtered = KURIFilter.self().filterURI( "kde.org" );
 </pre>

 You can alternatively use a KURL:
 <pre>
 KURL url = "kde.org";
 boolean filtered = KURIFilter.self().filterURI( url );
 </pre>

 If you have a constant string or a constant URL,
 simply invoke the corresponding function to obtain
 the filtered string or URL instead of a boolean flag:
 <pre>
 String u = KURIFilter.self().filteredURI( "kde.org" );
 </pre>

 You can also specify only specific filter(s) to be applied
 by supplying the name(s) of the filter(s).  By defualt all
 filters that are found are loaded when the KURIFilter object
 is created will be used.  These names are taken from the
 enteries in the \".desktop\" files.  Here are a couple of
 examples:
 <pre>
 String text = "kde.org";
 boolean filtered = KURIFilter.self().filterURI( text, "KShortURIFilter" );

 StringList list;
 list << "KShortURIFilter" << "MyFilter";
 boolean filtered = KURIFilter.self().filterURI( text, list );
 </pre>

 KURIFilter also allows richer data exchange through a simple
 meta-object called <code>KURIFilterData.</code>  Using this meta-object
 you can find out more information about the URL you want to
 filter.  See {@link KURIFilterData} for examples and details.

 @short Filters a given URL into its proper format whenever possible.
 
*/
public class  KURIFilter implements QtSupport {
	private long _qt;
	private boolean _allocatedInJavaWorld = true;

	protected KURIFilter(Class dummy){}


/** 
  Destructor
     
*/
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Filters the URI given by the object URIFilterData.

 This filters the given data based on the specified
 filter list.  If the list is empty all avaliable
 filter plugins would be used.  If not, only those
 given in the list are used.

*/
	public native boolean filterURI( KURIFilterData data, String[] filters);
	public native boolean filterURI( KURIFilterData data);

/** 
 Filters the URI given by the URL.

 This filters the given URL based on the specified
 filter list.  If the list is empty all avaliable
 filter plugins would be used.  If not, only those
 given in the list are used.

*/
	public native boolean filterURI( KURL uri, String[] filters);
	public native boolean filterURI( KURL uri);

/** 
 Filters a string representing a URI.

 This filters the given string based on the specified
 filter list.  If the list is empty all avaliable
 filter plugins would be used.  If not, only those
 given in the list are used.

*/
	public native boolean filterURI( String uri, String[] filters);
	public native boolean filterURI( String uri);

/** 
 Returns the filtered URI.

 This filters the given URL based on the specified
 filter list.  If the list is empty all avaliable
 filter plugins would be used.  If not, only those
 given in the list are used.

*/
	public native KURL filteredURI( KURL uri, String[] filters);
	public native KURL filteredURI( KURL uri);

/** 
 Return a filtered string representation of a URI.

 This filters the given URL based on the specified
 filter list.  If the list is empty all avaliable
 filter plugins would be used.  If not, only those
 given in the list are used.

*/
	public native String filteredURI( String uri, String[] filters);
	public native String filteredURI( String uri);

/** 
 Return an iterator to iterate over all loaded
 plugins.

*/
//	public native QPtrListIterator<KURIFilterPlugin> pluginsIterator();

/** 
 Return a list of the names of all loaded plugins

*/
	public native ArrayList pluginNames();

/** 
 Return a static instance of KURIFilter.
     
*/
	public static native KURIFilter self();
	private native void newKURIFilter();

/** 
 A protected constructor.

 This constructor creates a KURIFilter and
 initializes all plugins it can find by invoking
 {@link loadPlugins}.
     
*/
	public KURIFilter() {
		newKURIFilter();
	}

/** 
 Loads all allowed plugins.

 This function loads all filters that have not
 been dis
     
*/
	protected native void loadPlugins();
}
