/***************************************************************************
                            Invocation.java -  description
                             -------------------
    begin                : Tue Oct 31 06:12:14 2000
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    written by           : Richard Dale.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

package org.kde.koala;

import java.util.*;
import java.lang.reflect.*;
import org.kde.qt.qtjava;

/** A utility class for creating a closure to invoke later - when a Java
	slot or event handler needs to be activated
*/
class Invocation{
public static ArrayList invokeInterfaces(long qtObject){
	   return invokeArrayOperation(qtObject, "interfaces");
	}
	public static ArrayList invokeFunctions(long qtObject){
	   return invokeArrayOperation(qtObject, "functions");
	}
  public static ArrayList invokeArrayOperation(long qtObject, String operationName){
	  try{
      Object onThis = qtjava.objectForQtKey(qtObject, "java.lang.object", true);
			if(onThis != null){
				Object[] arguments = new Object[0];
	      Class[] objectTypes = new Class[0];
	      Method method = onThis.getClass().getMethod(operationName, objectTypes);
	      return (ArrayList) method.invoke(onThis,arguments);
			}else {
			  System.out.println("Invocation.invokeArrayOperation() : object not found!");
			}
	  }catch(Exception e){
	    e.printStackTrace();
	  }
		return new ArrayList();
	}
  public static DCOPAnswer invokeProcess(long qtObject, String fun, byte[] data){
	  try{
      Object onThis = qtjava.objectForQtKey(qtObject, "java.lang.object", true);
			if(onThis != null){
				Object[] arguments = {fun, data};
	      Class[] objectTypes = { String.class,
				                        data.getClass()};

	      Method method = onThis.getClass().getMethod("javaProcess", objectTypes);
	      return  (DCOPAnswer) method.invoke(onThis,arguments);
			}else {
			  System.out.println("Invocation.invokeArrayOperation() : object not found!");
			}
	  }catch(Exception e){
	    e.printStackTrace();
	  }
		DCOPAnswer answer = new DCOPAnswer();
		answer.setSucces(false);
		return answer;
	}
}
