/***************************************************************************
                            HTMLTableRowElement.java -  description
                             -------------------
    begin                : Fri Nov 15 11:45:52 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Nov 15 11:45:52 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as published by*
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 A row in a table. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.html#edef-TR">
 TR element definition </a> in HTML 4.0.

 
 @short *
 A row in a table.
*/
public class HTMLTableRowElement extends HTMLElement  {
	protected HTMLTableRowElement(Class dummy){super((Class) null);}

	private native void newHTMLTableRowElement();
	public HTMLTableRowElement() {
		super((Class) null);
		newHTMLTableRowElement();
	}
	private native void newHTMLTableRowElement( HTMLTableRowElement other);
	public HTMLTableRowElement( HTMLTableRowElement other) {
		super((Class) null);
		newHTMLTableRowElement( other);
	}
	private native void newHTMLTableRowElement( DOMNode other);
	public HTMLTableRowElement( DOMNode other) {
		super((Class) null);
		newHTMLTableRowElement( other);
	}
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 The index of this row, relative to the entire table.
 This is in logical order and not in document order.
 The rowIndex does take into account sections
 (THEAD, TFOOT or TBODY) within the table,
 placing THEAD rows first in the index, followed by
 TBODY rows, followed by TFOOT rows.
     
*/
	public native long rowIndex();

/** 
 see {@link rowIndex}

 This function is obsolete - the rowIndex property is actually supposed to be read-only
 (http://www.w3.org/DOM/updates/REC-DOM-Level-1-19981001-errata.html)
     
*/
	public native void setRowIndex( long arg1);

/** 
 The index of this row, relative to the current section ( <code>
 THEAD </code> , <code> TFOOT </code> , or <code> TBODY </code>
 ).

     
*/
	public native long sectionRowIndex();

/** 
 see {@link sectionRowIndex}

 This function is obsolete - the sectionRowIndex property is actually supposed to be read-only
 (http://www.w3.org/DOM/updates/REC-DOM-Level-1-19981001-errata.html)
     
*/
	public native void setSectionRowIndex( long arg1);

/** 
 The collection of cells in this row.

     
*/
	public native HTMLCollection cells();

/** 
 see {@link cells}

 This function is obsolete - the cells property is actually supposed to be read-only
 (http://www.w3.org/DOM/updates/REC-DOM-Level-1-19981001-errata.html)
     
*/
	public native void setCells( HTMLCollection arg1);

/** 
 Horizontal alignment of data within cells of this row. See the
 <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.html#adef-align-TD">
 align attribute definition </a> in HTML 4.0.

     
*/
	public native String align();

/** 
 see {@link align}
     
*/
	public native void setAlign( String arg1);

/** 
 Background color for rows. See the <a
 href="http://www.w3.org/TR/REC-html40/present/graphics.html#adef-bgcolor">
 bgcolor attribute definition </a> in HTML 4.0. This attribute
 is deprecated in HTML 4.0.

     
*/
	public native String bgColor();

/** 
 see {@link bgColor}
     
*/
	public native void setBgColor( String arg1);

/** 
 Alignment character for cells in a column. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.html#adef-char">
 char attribute definition </a> in HTML 4.0.

     
*/
	public native String ch();

/** 
 see {@link ch}
     
*/
	public native void setCh( String arg1);

/** 
 Offset of alignment character. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.html#adef-charoff">
 charoff attribute definition </a> in HTML 4.0.

     
*/
	public native String chOff();

/** 
 see {@link chOff}
     
*/
	public native void setChOff( String arg1);

/** 
 Vertical alignment of data within cells of this row. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.html#adef-valign">
 valign attribute definition </a> in HTML 4.0.

     
*/
	public native String vAlign();

/** 
 see {@link vAlign}
     
*/
	public native void setVAlign( String arg1);

/** 
 Insert an empty <code> TD </code> cell into this row.
 If index is -1 or equal to the number of cells, the new
 cell is appended.

     
*/
	public native HTMLElement insertCell( long index);

/** 
 Delete a cell from the current row.

     
*/
	public native void deleteCell( long index);
}
