/***************************************************************************
                            kde_KFilterDev.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KFILTERDEV
#define KDE_KFILTERDEV

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 A class for reading and writing compressed data onto a device
 (e.g. file, but other usages are possible, like a buffer or a socket)

 To simply read/write compressed files, see @ref deviceForFile.

 @author David Faure <faure@kde.org>
 
 @short *
 A class for reading and writing compressed data onto a device
 (e.
*/

/** *
 Constructs a KFilterDev for a given filter (e.g. gzip, bzip2 etc.)

*/
kde_KFilterDev * kde_new_KFilterDev(kde_KFilterBase* filter, int autodeleteFilterBase);

/** *
 Destructs the KFilterDev.
     
*/
void kde_del_KFilterDev( kde_KFilterDev* p );
int kde_KFilterDev_open(kde_KFilterDev* instPointer,int mode);
void kde_KFilterDev_close(kde_KFilterDev* instPointer);
void kde_KFilterDev_flush(kde_KFilterDev* instPointer);

/** *
 For writing gzip compressed files only:
 set the name of the original file, to be used in the gzip header.
     
*/
void kde_KFilterDev_setOrigFileName(kde_KFilterDev* instPointer,qt_QCString* fileName);

/** *
 Call this let this device skip the gzip headers when reading/writing.
 This way KFilterDev (with gzip filter) can be used as a direct wrapper
 around zlib - this is used by KZip.

*/
void kde_KFilterDev_setSkipHeaders(kde_KFilterDev* instPointer);
int kde_KFilterDev_size(kde_KFilterDev* instPointer);
int kde_KFilterDev_at(kde_KFilterDev* instPointer);

/** *
 That one can be quite slow, when going back. Use with care.
     
*/
int kde_KFilterDev_at1(kde_KFilterDev* instPointer,int arg1);
int kde_KFilterDev_atEnd(kde_KFilterDev* instPointer);
long kde_KFilterDev_readBlock(kde_KFilterDev* instPointer,char* data, long maxlen);
long kde_KFilterDev_writeBlock(kde_KFilterDev* instPointer,char* data, long len);
int kde_KFilterDev_getch(kde_KFilterDev* instPointer);
int kde_KFilterDev_putch(kde_KFilterDev* instPointer,int arg1);
int kde_KFilterDev_ungetch(kde_KFilterDev* instPointer,int arg1);

/** *
 Call this to create the appropriate filter device for @p base
 working on @p file . The returned QIODevice has to be deleted
 after using.

 To be removed in KDE 3.0
     
*/
qt_QIODevice * kde_KFilterDev_createFilterDevice( kde_KFilterBase* base, qt_QFile* file);

/** *
 Creates an i/o device that is able to read from @p fileName,
 whether it's compressed or not. Available compression filters
 (gzip/bzip2 etc.) will automatically be used.

 The compression filter to be used is determined from the @p fileName
 if @p mimetype is empty. Pass "application/x-gzip" or "application/x-bzip2"
 to force the corresponding decompression filter, if available.

 Warning: application/x-bzip2 may not be available.
 In that case a QFile opened on the compressed data will be returned !
 Use KFilterBase::findFilterByMimeType and code similar to what
 deviceForFile is doing, to better control what's happening.

 The returned QIODevice has to be deleted after using.
     
*/
qt_QIODevice * kde_KFilterDev_deviceForFile( qt_QString * fileName, qt_QString * mimetype, int forceFilter);

/** *
 Creates an i/o device that is able to read from the QIODevice @p inDevice,
 whether the data is compressed or not. Available compression filters
 (gzip/bzip2 etc.) will automatically be used.

 The compression filter to be used is determined @p mimetype .
 Pass "application/x-gzip" or "application/x-bzip2"
 to use the corresponding decompression filter.

 Warning: application/x-bzip2 may not be available.
 In that case 0 will be returned !

 The returned QIODevice has to be deleted after using.

*/
qt_QIODevice * kde_KFilterDev_device( qt_QIODevice * inDevice, qt_QString * mimetype);

/** *
 Creates an i/o device that is able to read from the QIODevice @p inDevice,
 whether the data is compressed or not. Available compression filters
 (gzip/bzip2 etc.) will automatically be used.

 The compression filter to be used is determined @p mimetype .
 Pass "application/x-gzip" or "application/x-bzip2"
 to use the corresponding decompression filter.

 Warning: application/x-bzip2 may not be available.
 In that case 0 will be returned !

 The returned QIODevice has to be deleted after using.

*/
qt_QIODevice * kde_KFilterDev_device1( qt_QIODevice * inDevice, qt_QString * mimetype, int autoDeleteInDevice);

#endif
