/***************************************************************************
                            kde_KDirOperator.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KDIROPERATOR
#define KDE_KDIROPERATOR

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 This widget works as a network transparent filebrowser. You specify a URL
 to display and this url will be loaded via @ref KDirLister. The user can
 browse through directories, highlight and select files, delete or rename
 files.

 It supports different views, e.g. a detailed view (see @ref KFileDetailView),
 a simple icon view (see @ref KFileIconView), a combination of two views,
 separating directories and files (@ref KCombiView).

 Additionally, a preview view is available (see @ref KFilePreview), which can
 show either a simple or detailed view and additionally a preview widget
 (see @ref setPreviewWidget()). @ref KImageFilePreview is one implementation
 of a preview widget, that displays previews for all supported filetypes
 utilizing KIO::PreviewJob.

 Currently, those classes don't support Drag&Drop out of the box -- there
 you have to use your own view-classes. You can use some DnD-aware views
 from Bjrn Sahlstrm <bjorn@kbear.org> until they will be integrated
 into this library. See http://devel-home.kde.org/~pfeiffer/DnD-classes.tar.gz

 This widget is the one used in the KFileDialog.

 Basic usage is like this:
 <pre>
   KDirOperator *op = new KDirOperator( KURL( "file:/home/gis" ), this );
   // some signals you might be interested in
   connect(op, SIGNAL(urlEntered(const KURL&)),
           SLOT(urlEntered(const KURL&)));
   connect(op, SIGNAL(fileHighlighted(const KFileItem *)),
           SLOT(fileHighlighted(const KFileItem *)));
   connect(op, SIGNAL(fileSelected(const KFileItem *)),
           SLOT(fileSelected(const KFileItem *)));
   connect(op, SIGNAL(finishedLoading()),
           SLOT(slotLoadingFinished()));

   op->readConfig( KGlobal::config(), "Your KDiroperator ConfigGroup" );
   op->setView(KFile::Default);
 </pre>

 This will create a childwidget of 'this' showing the directory contents
 of /home/gis in the default-view. The view is determined by the readConfig()
 call, which will read the KDirOperator settings, the user left your program
 with (and which you saved with op->writeConfig()).

 @author Stephan Kulow <coolo@kde.org>, Carsten Pfeiffer <pfeiffer@kde.org>
 
 @short A widget for displaying files and browsing directories.

*/
#define KDIROPERATOR_SortActions	1
#define KDIROPERATOR_ViewActions	2
#define KDIROPERATOR_NavActions	4
#define KDIROPERATOR_FileActions	8
#define KDIROPERATOR_AllActions	15

/** *
 Constructs the KDirOperator with no initial view. As the views are
 configurable, call @ref readConfig() to load the user's configuration
 and then @ref setView to explicitly set a view.

 This constructor doesn't start loading the url, @ref setView will do it.
     
*/
kde_KDirOperator * kde_new_KDirOperator(kde_KURL* urlName, qt_QWidget * parent, char* name);

/** *
 Destroys the KDirOperator.
     
*/
void kde_del_KDirOperator( kde_KDirOperator* p );

/** *
 Enables/disables showing hidden files.
     
*/
void kde_KDirOperator_setShowHiddenFiles(kde_KDirOperator* instPointer,int s);

/** *

*/
int kde_KDirOperator_showHiddenFiles(kde_KDirOperator* instPointer);

/** *
 Stops loading immediately. You don't need to call this, usually.
     
*/
void kde_KDirOperator_close(kde_KDirOperator* instPointer);

/** *
 Sets a filter like "*.cpp *.h *.o". Only files matching that filter
 will be shown. Call @ref updateDir() to apply it.

*/
void kde_KDirOperator_setNameFilter(kde_KDirOperator* instPointer,qt_QString * filter);

/** *

*/
qt_QString * kde_KDirOperator_nameFilter(kde_KDirOperator* instPointer);

/** *
 Sets a list of mimetypes as filter. Only files of those mimetypes
 will be shown.

 Example:
 <pre>
 QStringList filter;
 filter << "text/html" << "image/png" << "inode/directory";
 dirOperator->setMimefilter( filter );
 </pre>

 Node: Without the mimetype inode/directory, only files would be shown.
 Call @ref updateDir() to apply it.

*/
void kde_KDirOperator_setMimeFilter(kde_KDirOperator* instPointer,qt_QStringList* mimetypes);

/** *

*/
qt_QStringList* kde_KDirOperator_mimeFilter(kde_KDirOperator* instPointer);

/** *
 Clears both the namefilter and mimetype filter, so that all files and
 directories will be shown. Call @ref updateDir() to apply it.

*/
void kde_KDirOperator_clearFilter(kde_KDirOperator* instPointer);

/** *

*/
kde_KURL* kde_KDirOperator_url(kde_KDirOperator* instPointer);

/** *
 Sets a new url to list.

*/
void kde_KDirOperator_setURL(kde_KDirOperator* instPointer,kde_KURL* url, int clearforward);

/** *
 Clears the current selection and attempts to set @p filename
 the current file. filename is just the name, no path or url.
     
*/
void kde_KDirOperator_setCurrentItem(kde_KDirOperator* instPointer,qt_QString * filename);

/** *
 Sets a new KFileView to be used for showing and browsing files.
 Note: this will read the current @ref url() to fill the view.

*/
void kde_KDirOperator_setView(kde_KDirOperator* instPointer,kde_KFileView* view);

/** *

*/
kde_KFileView* kde_KDirOperator_view(kde_KDirOperator* instPointer);

/** *
 Returns the widget of the current view. 0L if there is no view/widget.
 (KFileView itself is not a widget.)
     
*/
qt_QWidget * kde_KDirOperator_viewWidget(kde_KDirOperator* instPointer);

/** *
 Sets one of the predefined fileviews

*/
void kde_KDirOperator_setView1(kde_KDirOperator* instPointer,int view);

/** *
 Sets the way to sort files and directories.
     
*/
void kde_KDirOperator_setSorting(kde_KDirOperator* instPointer,int arg1);

/** *

*/
int kde_KDirOperator_sorting(kde_KDirOperator* instPointer);

/** *

*/
int kde_KDirOperator_isRoot(kde_KDirOperator* instPointer);

/** *

*/
kde_KDirLister* kde_KDirOperator_dirLister(kde_KDirOperator* instPointer);

/** *

*/
kde_KProgress* kde_KDirOperator_progressBar(kde_KDirOperator* instPointer);

/** *
 Sets the listing/selection mode for the views, an OR'ed combination of

 You cannot mix File and Files of course, as the former means
 single-selection mode, the latter multi-selection.
     
*/
void kde_KDirOperator_setMode(kde_KDirOperator* instPointer,int m);

/** *

*/
int kde_KDirOperator_mode(kde_KDirOperator* instPointer);

/** *
 Sets a preview-widget to be shown next to the file-view.
 The ownership of @p w is transferred to KDirOperator, so don't
 delete it yourself!
     
*/
void kde_KDirOperator_setPreviewWidget(kde_KDirOperator* instPointer,qt_QWidget * w);

/** *

*/
kde_KFileItemList* kde_KDirOperator_selectedItems(kde_KDirOperator* instPointer);

/** *

*/
int kde_KDirOperator_isSelected(kde_KDirOperator* instPointer,kde_KFileItem* item);

/** *

*/
int kde_KDirOperator_numDirs(kde_KDirOperator* instPointer);

/** *

*/
int kde_KDirOperator_numFiles(kde_KDirOperator* instPointer);

/** *

*/
kde_KCompletion* kde_KDirOperator_completionObject(kde_KDirOperator* instPointer);

/** *

*/
kde_KCompletion* kde_KDirOperator_dirCompletionObject(kde_KDirOperator* instPointer);

/** *
 an accessor to a collection of all available Actions. The actions
 are static, they will be there all the time (no need to connect to
 the signals KActionCollection::inserted() or removed().

 There are the following actions:

 The short and detailed view are in an exclusive group. The sort-by
 actions are in an exclusive group as well. Also the "separate dirs",
 "preview" and "single" actions are in an exclusive group.

 You can e.g. use
 <pre>actionCollection()->action( "up" )->plug( someToolBar );</pre>
 to add a button into a toolbar, which makes the dirOperator change to
 its parent directory.

*/
kde_KActionCollection* kde_KDirOperator_actionCollection(kde_KDirOperator* instPointer);

/** *
 Reads the default settings for a view, i.e. the default KFile::FileView.
 Also reads the sorting and whether hidden files should be shown.
 Note: the default view will not be set - you have to call
 <pre>
 setView( KFile::Default )
 </pre>
 to apply it.

*/
void kde_KDirOperator_readConfig(kde_KDirOperator* instPointer,kde_KConfig* arg1, qt_QString * group);

/** *
 Saves the current settings like sorting, simple or detailed view.

*/
void kde_KDirOperator_writeConfig(kde_KDirOperator* instPointer,kde_KConfig* arg1, qt_QString * group);

/** *
 This is a KFileDialog specific hack: we want to select directories with
 single click, but not files. But as a generic class, we have to be able
 to select files on single click as well.

 This gives us the opportunity to do both.

 The default is false, set it to true if you don't want files selected
 with single click.
     
*/
void kde_KDirOperator_setOnlyDoubleClickSelectsFiles(kde_KDirOperator* instPointer,int enable);

/** *

*/
int kde_KDirOperator_onlyDoubleClickSelectsFiles(kde_KDirOperator* instPointer);

/** *
 Creates the given directory/url. If it is a relative path,
 it will be completed with the current directory.
 If enterDirectory is true, the directory will be entered after a
 successful operation. If unsuccessful, a messagebox will be presented
 to the user.

*/
int kde_KDirOperator_mkdir(kde_KDirOperator* instPointer,qt_QString * directory, int enterDirectory);

/** *
 Starts and returns a @ref KIO::DeleteJob to delete the given @p items.

*/
kde_DeleteJob* kde_KDirOperator_del(kde_KDirOperator* instPointer,kde_KFileItemList* items, int ask, int showProgress);

/** *
 Starts and returns a @ref KIO::DeleteJob to delete the given @p items.

*/
kde_DeleteJob* kde_KDirOperator_del1(kde_KDirOperator* instPointer,kde_KFileItemList* items, qt_QWidget * parent, int ask, int showProgress);

/** *
 Clears the forward and backward history.
     
*/
void kde_KDirOperator_clearHistory(kde_KDirOperator* instPointer);

/** *
 When going up in the directory hierarchy, KDirOperator can highlight
 the directory that was just left.

 I.e. when you go from /home/gis/src to /home/gis, the item "src" will
 be made the current item.

 Default is off.
     
*/
void kde_KDirOperator_setEnableDirHighlighting(kde_KDirOperator* instPointer,int enable);

/** *

 Default is false.
     
*/
int kde_KDirOperator_dirHighlighting(kde_KDirOperator* instPointer);

/** *

*/
int kde_KDirOperator_dirOnlyMode(kde_KDirOperator* instPointer);

/** *
 Sets up the action menu.

*/
void kde_KDirOperator_setupMenu(kde_KDirOperator* instPointer,int whichActions);

/** *
 Goes one step back in the history and opens that url.
     
*/
void kde_KDirOperator_back(kde_KDirOperator* instPointer);

/** *
 Goes one step forward in the history and opens that url.
     
*/
void kde_KDirOperator_forward(kde_KDirOperator* instPointer);

/** *
 Enters the home directory.
     
*/
void kde_KDirOperator_home(kde_KDirOperator* instPointer);

/** *
 Goes one directory up from the current url.
     
*/
void kde_KDirOperator_cdUp(kde_KDirOperator* instPointer);

/** *
 to update the view after changing the settings
     
*/
void kde_KDirOperator_updateDir(kde_KDirOperator* instPointer);

/** *
 Re-reads the current url.
     
*/
void kde_KDirOperator_rereadDir(kde_KDirOperator* instPointer);

/** *
 Opens a dialog to create a new directory.
     
*/
void kde_KDirOperator_mkdir1(kde_KDirOperator* instPointer);

/** *
 Deletes the currently selected files/directories.
     
*/
void kde_KDirOperator_deleteSelected(kde_KDirOperator* instPointer);

/** *
 Enables/disables actions that are selection dependent. Call this e.g.
 when you are about to show a popup menu using some of KDirOperators
 actions.
     
*/
void kde_KDirOperator_updateSelectionDependentActions(kde_KDirOperator* instPointer);

/** *
 Tries to complete the given string (only completes files).
     
*/
qt_QString * kde_KDirOperator_makeCompletion(kde_KDirOperator* instPointer,qt_QString * arg1);

/** *
 Tries to complete the given string (only completes directores).
     
*/
qt_QString * kde_KDirOperator_makeDirCompletion(kde_KDirOperator* instPointer,qt_QString * arg1);
int kde_KDirOperator_dirOnlyMode1( unsigned int mode);

/** *
 A view factory for creating predefined fileviews. Called internally by @ref #setView
 , but you can also call it directly. Reimplement this if you depend on self defined fileviews.

*/
kde_KFileView* kde_KDirOperator_createView(kde_KDirOperator* instPointer,qt_QWidget * parent, int view);

/** *
 Sets a custom KFileReader to list directories.
     
*/
void kde_KDirOperator_setDirLister(kde_KDirOperator* instPointer,kde_KDirLister* lister);

/** *
 Sets up all the actions. Called from the constructor, you usually
 better not call this.
     
*/
void kde_KDirOperator_setupActions(kde_KDirOperator* instPointer);

/** *
 Updates the sorting-related actions to comply with the current sorting

*/
void kde_KDirOperator_updateSortActions(kde_KDirOperator* instPointer);

/** *
 Updates the view-related actions to comply with the current
 KFile::FileView
     
*/
void kde_KDirOperator_updateViewActions(kde_KDirOperator* instPointer);

/** *
 Sets up the context-menu with all the necessary actions. Called from the
 constructor, you usually don't need to call this.

*/
void kde_KDirOperator_setupMenu1(kde_KDirOperator* instPointer);

/** *
 Synchronizes the completion objects with the entries of the
 currently listed url.

 Automatically called from @ref makeCompletion() and
 @ref makeDirCompletion()
     
*/
void kde_KDirOperator_prepareCompletionObjects(kde_KDirOperator* instPointer);

/** *
 Checks if there support from @ref KIO::PreviewJob for the currently
 shown files, taking @ref mimeFilter() and @ref nameFilter() into account
 Enables/disables the preview-action accordingly.
     
*/
int kde_KDirOperator_checkPreviewSupport(kde_KDirOperator* instPointer);
void kde_KDirOperator_virtual_hook(kde_KDirOperator* instPointer,int identifier, void* data);

/** *
 Restores the normal cursor after showing the busy-cursor. Also hides
 the progressbar.
     
*/
void kde_KDirOperator_resetCursor(kde_KDirOperator* instPointer);

/** *
 Called after @ref setURL() to load the directory, update the history,
 etc.
     
*/
void kde_KDirOperator_pathChanged(kde_KDirOperator* instPointer);

/** *
 Adds a new list of KFileItems to the view
 (coming from KDirLister)
     
*/
void kde_KDirOperator_insertNewFiles(kde_KDirOperator* instPointer,kde_KFileItemList* newone);

/** *
 Removes the given KFileItem item from the view (usually called from
 KDirLister).
     
*/
void kde_KDirOperator_itemDeleted(kde_KDirOperator* instPointer,kde_KFileItem* arg1);

/** *
 Enters the directory specified by the given @p item.
     
*/
void kde_KDirOperator_selectDir(kde_KDirOperator* instPointer,kde_KFileItem* item);

/** *
 Emits fileSelected( item )
     
*/
void kde_KDirOperator_selectFile(kde_KDirOperator* instPointer,kde_KFileItem* item);

/** *
 Emits fileHighlighted( i )
     
*/
void kde_KDirOperator_highlightFile(kde_KDirOperator* instPointer,kde_KFileItem* i);

/** *
 Called upon right-click to activate the popupmenu.
     
*/
void kde_KDirOperator_activatedMenu(kde_KDirOperator* instPointer,kde_KFileItem* arg1, qt_QPoint* pos);

/** *
 Changes sorting to sort by name
     
*/
void kde_KDirOperator_sortByName(kde_KDirOperator* instPointer);

/** *
 Changes sorting to sort by size
     
*/
void kde_KDirOperator_sortBySize(kde_KDirOperator* instPointer);

/** *
 Changes sorting to sort by date
     
*/
void kde_KDirOperator_sortByDate(kde_KDirOperator* instPointer);

/** *
 Changes sorting to reverse sorting
     
*/
void kde_KDirOperator_sortReversed(kde_KDirOperator* instPointer);

/** *
 Toggles showing directories first / having them sorted like files.
     
*/
void kde_KDirOperator_toggleDirsFirst(kde_KDirOperator* instPointer);

/** *
 Toggles case sensitive / case insensitive sorting
     
*/
void kde_KDirOperator_toggleIgnoreCase(kde_KDirOperator* instPointer);

/** *
 Tries to make the given @p match as current item in the view and emits
 completion( match )
     
*/
void kde_KDirOperator_slotCompletionMatch(kde_KDirOperator* instPointer,qt_QString * match);

#endif
