/*****************************************************************

Copyright (c) 1996-2000 the kicker authors. See file AUTHORS.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#include <klocale.h>
#include <kiconloader.h>
#include <kpanelapplet.h>

#include "kicker.h"
#include "panel.h"
#include "panelop_mnu.h"
#include "appletop_mnu.h"
#include "container_button.h"
#include "childpanelextension.h"

PanelAppletOpMenu::PanelAppletOpMenu(int actions, QPopupMenu *opMenu, const QString & title, const QString &icon,
                                     QWidget *parent, const char *name)
  : QPopupMenu(parent, name)
{
/*
    if ( !title.isEmpty() )
    {
      if (icon.isEmpty())
        insertTitle(title);
      else
        insertTitle(SmallIcon(icon), title);
    }
*/
    bool needSeparator = false;
    bool isButton = (parent && parent->inherits("ButtonContainer"));
    bool isMenu = false;
    if (isButton)
    {
        isMenu = static_cast<ButtonContainer*>(parent)->isAMenu();
    }

    if (!Kicker::kicker()->isImmutable())
    {
        QString text = isButton ? (isMenu ? i18n("&Move %1 Menu") :
                                            i18n("&Move %1 Button")) :
                                  i18n("&Move %1");
        insertItem(SmallIcon("move"), text.arg(title), Move);
        text = isButton ? (isMenu ? i18n("&Remove %1 Menu") :
                                    i18n("&Remove %1 Button")) :
                          i18n("&Remove %1");
        insertItem(SmallIcon("remove"), text.arg(title), Remove);
        needSeparator = true;
    }

    if (actions & KPanelApplet::ReportBug)
    {
        if (needSeparator)
            insertSeparator();

        insertItem(i18n("Report &Bug..."), ReportBug);
        needSeparator = true;
    }

    if (actions & KPanelApplet::About)
    {
        if (needSeparator)
            insertSeparator();
        QPixmap iconPix(kapp->iconLoader()->loadIcon(icon,
                                                     KIcon::Small, 0, 
                                                     KIcon::DefaultState, 
                                                     0, true));
        insertItem(iconPix, i18n("&About %1").arg( title ), About);
        needSeparator = !(actions & KPanelApplet::Help);
    }

    if (actions & KPanelApplet::Help)
    {
        if (needSeparator)
            insertSeparator();

        insertItem(SmallIcon("help"), i18n("&Help"), Help);
        needSeparator = true;
    }

    if (!Kicker::kicker()->isImmutable() && (actions & KPanelApplet::Preferences))
    {
        if (needSeparator)
            insertSeparator();

        if (isButton)
        {
            insertItem(SmallIcon("configure"), i18n("&Properties"), Preferences);

        }
        else
        {
            insertItem(SmallIcon("configure"), i18n("&Configure %1...").arg(title), Preferences);
        }

        needSeparator = true;
    }

    if (actions & PanelAppletOpMenu::KMenuEditor)
    {
        if (needSeparator)
            insertSeparator();

        insertItem(SmallIcon("kmenuedit"), i18n("&Menu Editor"), Preferences);
        needSeparator = true;
    }

    if (needSeparator)
        insertSeparator();

    /*
     * ugliest hack ever. well, maybe not ever. but close.
     * make sure to show the child panel's op menu if this lives in 
     * a child panel, otherwise show the main panel's menu
     *
     * shouldn't we just turf the main panel and do everything with
     * child panels?
     *
    QPopupMenu* panelMenu = 0;
    QObject* ancestor = 0;
    if (parent)
    {
        ancestor = parent->parent();
    }

    while (ancestor)
    {
        if (ancestor->inherits("ChildPanelExtension"))
        {
            panelMenu = static_cast<ChildPanelExtension*>(ancestor)->opMenu();
            break;
        }

        ancestor = ancestor->parent();
    }

    if (!panelMenu)
    {
        panelMenu = new PanelOpMenu(Panel::the(), this);
    }

    insertItem(SmallIcon("panel"), i18n("Panel Menu"), panelMenu);
    */

    insertItem(SmallIcon("panel"), i18n("Panel Menu"), opMenu);
    adjustSize();
}

void PanelAppletOpMenu::keyPressEvent(QKeyEvent* e)
{
    if (e->key() == Qt::Key_Escape)
    {
        emit escapePressed();
    }

    QPopupMenu::keyPressEvent(e);
}

#include "appletop_mnu.moc" 

