/***********************************
 Update contact list in main window
 (c) 1999 Jeremy Wise  
 (c) 2001 Gediminas Paulauskas
 GnomeICU
************************************/

#ifndef __SHOWLIST_H__
#define __SHOWLIST_H__

#include "common.h"

enum {
	UPDATE_ONLINE  = 1<<0,
	UPDATE_OFFLINE = 1<<1,
	UPDATE_NOTLIST = 1<<2,
	UPDATE_RECONSTRUCT = 1<<3
};

void gnomeicu_tree_create (void);
void gnomeicu_tree_user_online (Contact_Member *contact);
void gnomeicu_tree_user_offline (Contact_Member *contact);
void gnomeicu_tree_user_remove (Contact_Member *contact);
void gnomeicu_tree_user_add (Contact_Member *contact);
void set_contact_icon (Contact_Member *contact, GdkPixbuf *pixbuf);
gint gnomeicu_tree_total_contacts (void);
gint gnomeicu_tree_online_contacts (void);
void gnomeicu_tree_add_group (const GroupInfo *ginfo);
void gnomeicu_tree_rename_group (const GroupInfo *ginfo);
void gnomeicu_tree_remove_group (const GroupInfo *ginfo);
void gnomeicu_tree_refresh_visuals (void);
void gnomeicu_tree_update_headers (void);
void gnomeicu_tree_set_status (Contact_Member *contact);

#endif /* __SHOWLIST_H__ */
