/***************************************************************************
                            kde_KStdAction.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KSTDACTION
#define KDE_KSTDACTION

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 Convenience methods to access all standard KDE actions.

 These actions should be used instead of hardcoding menubar and
 toolbar items.  Using these actions helps your application easily
 conform to the KDE UI Style Guide

 All of the documentation for @ref KAction holds for KStdAction
 also.  When in doubt on how things work, check the @ref KAction
 documention first.

 In general, using standard actions should be a drop in replacement
 for regular actions.  For example, if you previously had:

 <PRE>
 KAction *newAct = new KAction(i18n("&New"), QIconSet(BarIcon("filenew")),
                               KStdAccel::key(KStdAccel::New), this,
                               SLOT(fileNew()), actionCollection());
 </PRE>

 You could drop that and replace it with:

 <PRE>
 KAction *newAct = KStdAction::openNew(this, SLOT(fileNew()),
                                       actionCollection());
 </PRE>

 It is possible to use the standard actions in various
 non-recommended ways.  Say, for instance, you wanted to have a
 standard action (with the associated correct text and icon and
 accelerator, etc) but you didn't want it to go in the standard
 place (this is not recommended, by the way).  One way to do this is
 to simply not use the XML UI framework and plug it into wherever
 you want.  If you do want to use the XML UI framework (good!), then
 it is still possible.

 Basically, the XML building code matches names in the XML code with
 the internal names of the actions.  You can find out the internal
 names of each of the standard actions by using the @ref stdName
 action like so: @ref KStdAction::stdName(KStdAction::Cut) would return
 'edit_cut'.  The XML building code will match 'edit_cut' to the
 attribute in the global XML file and place your action there.

 However, you can change the internal name.  In this example, just
 do something like:

 <PRE>
 (void)KStdAction::cut(this, SLOT(editCut()), actionCollection(), "my_cut");
 </PRE>

 Now, in your local XML resource file (e.g., yourappui.rc), simply
 put 'my_cut' where you want it to go.

 Another non-standard usage concerns getting a pointer to an
 existing action if, say, you want to enable or disable the action.
 You could do it the recommended way and just grab a pointer when
 you instantiate it as in the the 'openNew' example above... or you
 could do it the hard way:

 <pre>
 KAction *cut = actionCollection()->action(KStdAction::stdName(KStdAction::Cut));
 </pre>

 Another non-standard usage concerns instantiating the action in the
 first place.  Usually, you would use the member functions as
 shown above (e.g., KStdAction::cut(this, SLOT, parent)).  You
 may, however, do this using the enums provided.  This author can't
 think of a reason why you would want to, but, hey, if you do,
 here's how:

 <pre>
 (void)KStdAction::action(KStdAction::New, this, SLOT(fileNew()), actionCollection());
 (void)KStdAction::action(KStdAction::Cut, this, SLOT(editCut()), actionCollection());
 </pre>

 @author Kurt Granroth <granroth@kde.org>
 
 @short *
 Convenience methods to access all standard KDE actions.
*/
#define KSTDACTION_ActionNone	0
#define KSTDACTION_New	1
#define KSTDACTION_Open	2
#define KSTDACTION_OpenRecent	3
#define KSTDACTION_Save	4
#define KSTDACTION_SaveAs	5
#define KSTDACTION_Revert	6
#define KSTDACTION_Close	7
#define KSTDACTION_Print	8
#define KSTDACTION_PrintPreview	9
#define KSTDACTION_Mail	10
#define KSTDACTION_Quit	11
#define KSTDACTION_Undo	12
#define KSTDACTION_Redo	13
#define KSTDACTION_Cut	14
#define KSTDACTION_Copy	15
#define KSTDACTION_Paste	16
#define KSTDACTION_SelectAll	17
#define KSTDACTION_Deselect	18
#define KSTDACTION_Find	19
#define KSTDACTION_FindNext	20
#define KSTDACTION_FindPrev	21
#define KSTDACTION_Replace	22
#define KSTDACTION_ActualSize	23
#define KSTDACTION_FitToPage	24
#define KSTDACTION_FitToWidth	25
#define KSTDACTION_FitToHeight	26
#define KSTDACTION_ZoomIn	27
#define KSTDACTION_ZoomOut	28
#define KSTDACTION_Zoom	29
#define KSTDACTION_Redisplay	30
#define KSTDACTION_Up	31
#define KSTDACTION_Back	32
#define KSTDACTION_Forward	33
#define KSTDACTION_Home	34
#define KSTDACTION_Prior	35
#define KSTDACTION_Next	36
#define KSTDACTION_Goto	37
#define KSTDACTION_GotoPage	38
#define KSTDACTION_GotoLine	39
#define KSTDACTION_FirstPage	40
#define KSTDACTION_LastPage	41
#define KSTDACTION_AddBookmark	42
#define KSTDACTION_EditBookmarks	43
#define KSTDACTION_Spelling	44
#define KSTDACTION_ShowMenubar	45
#define KSTDACTION_ShowToolbar	46
#define KSTDACTION_ShowStatusbar	47
#define KSTDACTION_SaveOptions	48
#define KSTDACTION_KeyBindings	49
#define KSTDACTION_Preferences	50
#define KSTDACTION_ConfigureToolbars	51
#define KSTDACTION_Help	52
#define KSTDACTION_HelpContents	53
#define KSTDACTION_WhatsThis	54
#define KSTDACTION_ReportBug	55
#define KSTDACTION_AboutApp	56
#define KSTDACTION_AboutKDE	57
#define KSTDACTION_TipofDay	58
#define KSTDACTION_ConfigureNotifications	59

/** *
 Creates an action corresponding to the
 @ref KStdAction::StdAction enum.
	 
*/
kde_KAction* kde_KStdAction_create(int identifier, char* name, qt_QObject * recvr, char* slot, kde_KActionCollection* parent);
kde_KAction* kde_KStdAction_create1(int identifier, qt_QObject * recvr, char* slot, kde_KActionCollection* parent);

/** *
 @obsolete. Creates an action corresponding to the
 @ref KStdAction::StdAction enum.
	
*/
kde_KAction* kde_KStdAction_action(int act_enum, qt_QObject * recvr, char* slot, kde_KActionCollection* parent, char* name);

/** *
 This will return the internal name of a given standard action.
	
*/
char* kde_KStdAction_name(int identifier);
char* kde_KStdAction_stdName(int act_enum);

/** *
 Returns a list of all standard names. Used by @ref KAccelManager
 to give those heigher weight.

*/
qt_QStringList* kde_KStdAction_stdNames(kde_KStdAction* instPointer);

/** *
 Create a new document or window.
	
*/
kde_KAction* kde_KStdAction_openNew(qt_QObject * recvr, char* slot, kde_KActionCollection* parent, char* name);

/** *
 Open an existing file.
	
*/
kde_KAction* kde_KStdAction_open(qt_QObject * recvr, char* slot, kde_KActionCollection* parent, char* name);

/** *
 Open a recently used document.

*/
kde_KRecentFilesAction* kde_KStdAction_openRecent(qt_QObject * recvr, char* slot, kde_KActionCollection* parent, char* name);

/** *
 Save the current document.
	
*/
kde_KAction* kde_KStdAction_save(qt_QObject * recvr, char* slot, kde_KActionCollection* parent, char* name);

/** *
 Save the current document under a different name.
	
*/
kde_KAction* kde_KStdAction_saveAs(qt_QObject * recvr, char* slot, kde_KActionCollection* parent, char* name);

/** *
 Revert the current document to the last saved version
 (essentially will undo all changes).
	
*/
kde_KAction* kde_KStdAction_revert(qt_QObject * recvr, char* slot, kde_KActionCollection* parent, char* name);

/** *
 Close the current document.
	
*/
kde_KAction* kde_KStdAction_close(qt_QObject * recvr, char* slot, kde_KActionCollection* parent, char* name);

/** *
 Print the current document.
	
*/
kde_KAction* kde_KStdAction_print(qt_QObject * recvr, char* slot, kde_KActionCollection* parent, char* name);

/** *
 Show a print preview of the current document.
	
*/
kde_KAction* kde_KStdAction_printPreview(qt_QObject * recvr, char* slot, kde_KActionCollection* parent, char* name);

/** *
 Mail this document.
	
*/
kde_KAction* kde_KStdAction_mail(qt_QObject * recvr, char* slot, kde_KActionCollection* parent, char* name);

/** *
 Quit the program.
	
*/
kde_KAction* kde_KStdAction_quit(qt_QObject * recvr, char* slot, kde_KActionCollection* parent, char* name);

/** *
 Undo the last operation.
	
*/
kde_KAction* kde_KStdAction_undo(qt_QObject * recvr, char* slot, kde_KActionCollection* parent, char* name);

/** *
 Redo the last operation.
	
*/
kde_KAction* kde_KStdAction_redo(qt_QObject * recvr, char* slot, kde_KActionCollection* parent, char* name);

/** *
 Cut selected area and store it in the clipboard.
	
*/
kde_KAction* kde_KStdAction_cut(qt_QObject * recvr, char* slot, kde_KActionCollection* parent, char* name);

/** *
 Copy the selected area into the clipboard.
	
*/
kde_KAction* kde_KStdAction_copy(qt_QObject * recvr, char* slot, kde_KActionCollection* parent, char* name);

/** *
 Paste the contents of clipboard at the current mouse or cursor
 position.
	
*/
kde_KAction* kde_KStdAction_paste(qt_QObject * recvr, char* slot, kde_KActionCollection* parent, char* name);

/** *
 Select all elements in the current document.
	
*/
kde_KAction* kde_KStdAction_selectAll(qt_QObject * recvr, char* slot, kde_KActionCollection* parent, char* name);

/** *
 Deselect any selected elements in the current document.
	
*/
kde_KAction* kde_KStdAction_deselect(qt_QObject * recvr, char* slot, kde_KActionCollection* parent, char* name);

/** *
 Initiate a 'find' request in the current document.
	
*/
kde_KAction* kde_KStdAction_find(qt_QObject * recvr, char* slot, kde_KActionCollection* parent, char* name);

/** *
 Find the next instance of a stored 'find'.
	
*/
kde_KAction* kde_KStdAction_findNext(qt_QObject * recvr, char* slot, kde_KActionCollection* parent, char* name);

/** *
 Find a previous instance of a stored 'find'.
	
*/
kde_KAction* kde_KStdAction_findPrev(qt_QObject * recvr, char* slot, kde_KActionCollection* parent, char* name);

/** *
 Find and replace matches.
	
*/
kde_KAction* kde_KStdAction_replace(qt_QObject * recvr, char* slot, kde_KActionCollection* parent, char* name);

/** *
 View the document at its actual size.
	
*/
kde_KAction* kde_KStdAction_actualSize(qt_QObject * recvr, char* slot, kde_KActionCollection* parent, char* name);

/** *
 Fit the document view to the size of the current window.
	
*/
kde_KAction* kde_KStdAction_fitToPage(qt_QObject * recvr, char* slot, kde_KActionCollection* parent, char* name);

/** *
 Fit the document view to the width of the current window.
	
*/
kde_KAction* kde_KStdAction_fitToWidth(qt_QObject * recvr, char* slot, kde_KActionCollection* parent, char* name);

/** *
 Fit the document view to the height of the current window.
	
*/
kde_KAction* kde_KStdAction_fitToHeight(qt_QObject * recvr, char* slot, kde_KActionCollection* parent, char* name);

/** *
 Zoom in.
	
*/
kde_KAction* kde_KStdAction_zoomIn(qt_QObject * recvr, char* slot, kde_KActionCollection* parent, char* name);

/** *
 Zoom out.
	
*/
kde_KAction* kde_KStdAction_zoomOut(qt_QObject * recvr, char* slot, kde_KActionCollection* parent, char* name);

/** *
 Popup a zoom dialog.
	
*/
kde_KAction* kde_KStdAction_zoom(qt_QObject * recvr, char* slot, kde_KActionCollection* parent, char* name);

/** *
 Redisplay or redraw the document.
	
*/
kde_KAction* kde_KStdAction_redisplay(qt_QObject * recvr, char* slot, kde_KActionCollection* parent, char* name);

/** *
 Move up (web style menu).
	
*/
kde_KAction* kde_KStdAction_up(qt_QObject * recvr, char* slot, kde_KActionCollection* parent, char* name);

/** *
 Move back (web style menu).
	
*/
kde_KAction* kde_KStdAction_back(qt_QObject * recvr, char* slot, kde_KActionCollection* parent, char* name);

/** *
 Move forward (web style menu).
	
*/
kde_KAction* kde_KStdAction_forward(qt_QObject * recvr, char* slot, kde_KActionCollection* parent, char* name);

/** *
 Go to the "Home" position or document.
	
*/
kde_KAction* kde_KStdAction_home(qt_QObject * recvr, char* slot, kde_KActionCollection* parent, char* name);

/** *
 Scroll up one page.
	
*/
kde_KAction* kde_KStdAction_prior(qt_QObject * recvr, char* slot, kde_KActionCollection* parent, char* name);

/** *
 Scroll down one page.
	
*/
kde_KAction* kde_KStdAction_next(qt_QObject * recvr, char* slot, kde_KActionCollection* parent, char* name);

/** *
 Go to somewhere in general.
	
*/
kde_KAction* kde_KStdAction_goTo(qt_QObject * recvr, char* slot, kde_KActionCollection* parent, char* name);

/** *
 Go to a specific page (dialog).
	
*/
kde_KAction* kde_KStdAction_gotoPage(qt_QObject * recvr, char* slot, kde_KActionCollection* parent, char* name);

/** *
 Go to a specific line (dialog).
	
*/
kde_KAction* kde_KStdAction_gotoLine(qt_QObject * recvr, char* slot, kde_KActionCollection* parent, char* name);

/** *
 Jump to the first page.
	
*/
kde_KAction* kde_KStdAction_firstPage(qt_QObject * recvr, char* slot, kde_KActionCollection* parent, char* name);

/** *
 Jump to the last page.
	
*/
kde_KAction* kde_KStdAction_lastPage(qt_QObject * recvr, char* slot, kde_KActionCollection* parent, char* name);

/** *
 Add the current page to the bookmarks tree.
	
*/
kde_KAction* kde_KStdAction_addBookmark(qt_QObject * recvr, char* slot, kde_KActionCollection* parent, char* name);

/** *
 Edit the application bookmarks.
	
*/
kde_KAction* kde_KStdAction_editBookmarks(qt_QObject * recvr, char* slot, kde_KActionCollection* parent, char* name);

/** *
 Pop up the spell checker.
	
*/
kde_KAction* kde_KStdAction_spelling(qt_QObject * recvr, char* slot, kde_KActionCollection* parent, char* name);

/** *
 Show/Hide the menubar.
	
*/
kde_KToggleAction* kde_KStdAction_showMenubar(qt_QObject * recvr, char* slot, kde_KActionCollection* parent, char* name);

/** *
 @obsolete. toolbar actions are created automatically now in the Settings menu. Don't use this anymore
 Show/Hide the primary toolbar.

*/
kde_KToggleAction* kde_KStdAction_showToolbar(qt_QObject * recvr, char* slot, kde_KActionCollection* parent, char* name);

/** *
 @obsolete. toolbar actions are created automatically now in the Settings menu. Don't use this anymore
 Show/Hide the primary toolbar.
	
*/
//KToggleToolBarAction* kde_KStdAction_showToolbar1(char* toolBarName, kde_KActionCollection* parent, char* name);

/** *
 Show/Hide the statusbar.
	
*/
kde_KToggleAction* kde_KStdAction_showStatusbar(qt_QObject * recvr, char* slot, kde_KActionCollection* parent, char* name);

/** *
 Display the save options dialog.
	
*/
kde_KAction* kde_KStdAction_saveOptions(qt_QObject * recvr, char* slot, kde_KActionCollection* parent, char* name);

/** *
 Display the configure key bindings dialog.
	
*/
kde_KAction* kde_KStdAction_keyBindings(qt_QObject * recvr, char* slot, kde_KActionCollection* parent, char* name);

/** *
 Display the preferences/options dialog.
	
*/
kde_KAction* kde_KStdAction_preferences(qt_QObject * recvr, char* slot, kde_KActionCollection* parent, char* name);

/** *
 The Customize Toolbar dialog.
	
*/
kde_KAction* kde_KStdAction_configureToolbars(qt_QObject * recvr, char* slot, kde_KActionCollection* parent, char* name);

/** *
 The Configure Notifications dialo

*/
kde_KAction* kde_KStdAction_configureNotifications(qt_QObject * recvr, char* slot, kde_KActionCollection* parent, char* name);

/** *
 Display the help.
	
*/
kde_KAction* kde_KStdAction_help(qt_QObject * recvr, char* slot, kde_KActionCollection* parent, char* name);

/** *
 Display the help contents.
	
*/
kde_KAction* kde_KStdAction_helpContents(qt_QObject * recvr, char* slot, kde_KActionCollection* parent, char* name);

/** *
 Trigger the What's This cursor.
	
*/
kde_KAction* kde_KStdAction_whatsThis(qt_QObject * recvr, char* slot, kde_KActionCollection* parent, char* name);

/** *
 Display "Tip of the Day"

*/
kde_KAction* kde_KStdAction_tipOfDay(qt_QObject * recvr, char* slot, kde_KActionCollection* parent, char* name);

/** *
 Open up the Report Bug dialog.
	
*/
kde_KAction* kde_KStdAction_reportBug(qt_QObject * recvr, char* slot, kde_KActionCollection* parent, char* name);

/** *
 Display the application's About box.
	
*/
kde_KAction* kde_KStdAction_aboutApp(qt_QObject * recvr, char* slot, kde_KActionCollection* parent, char* name);

/** *
 Display the About KDE dialog.
	
*/
kde_KAction* kde_KStdAction_aboutKDE(qt_QObject * recvr, char* slot, kde_KActionCollection* parent, char* name);

#endif
