/*
 * Decompiled with CFR 0.152.
 */
package org.cups;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.cups.CupsJob;
import org.cups.IPP;
import org.cups.IPPAttribute;
import org.cups.IPPHttp;
import org.cups.IPPRequest;
import org.cups.IPPValue;

public class Cups {
    static final int REQ_STATE_CREATE_HTTP = 0;
    static final int REQ_STATE_WRITE_HTTP_HEADER = 1;
    static final int REQ_STATE_WRITE_IPP_HEADER = 2;
    static final int REQ_STATE_WRITE_IPP_ATTRS = 3;
    static final int REQ_STATE_FINISH_IPP_ATTRS = 4;
    static final int REQ_STATE_READ_RESPONSE = 5;
    static final int REQ_STATE_DONE = 6;
    static final String[] req_state_names = new String[]{"Create HTTP", "Write Http Header", "Write IPP Header", "Write IPP Attrs", "Finish IPP Attrs", "Read Response", "Done"};
    static final int FILEREQ_STATE_CREATE_HTTP = 0;
    static final int FILEREQ_STATE_WRITE_HTTP_HEADER = 1;
    static final int FILEREQ_STATE_WRITE_IPP_HEADER = 2;
    static final int FILEREQ_STATE_WRITE_IPP_ATTRS = 3;
    static final int FILEREQ_STATE_FINISH_IPP_ATTRS = 4;
    static final int FILEREQ_STATE_WRITE_FILE_DATA = 5;
    static final int FILEREQ_STATE_READ_RESPONSE = 6;
    static final int FILEREQ_STATE_DONE = 7;
    static final String[] filereq_state_names = new String[]{"Create HTTP", "Write Http Header", "Write IPP Header", "Write IPP Attrs", "Finish IPP Attrs", "Write File Data", "Read Response", "Done"};
    IPP ipp = null;
    IPPHttp http = null;
    String protocol;
    String address;
    int port;
    String path;
    String dest;
    String instance;
    boolean encrypt;
    String user;
    String passwd;
    String site;
    int last_error;
    String error_text;

    public Cups() {
        this.protocol = "http";
        this.address = "localhost";
        this.port = 631;
        this.path = "/";
        this.site = "http://localhost:631/";
        this.dest = "";
        this.instance = "";
        this.user = "";
        this.passwd = "";
        this.encrypt = false;
    }

    public Cups(URL uRL) {
        this.protocol = uRL.getProtocol() + "://";
        this.address = uRL.getHost();
        this.port = uRL.getPort();
        this.path = uRL.getPath();
        this.site = this.protocol + this.address;
        if (this.port > 0) {
            this.site = this.site + ":" + this.port;
        }
        if (this.path.length() > 0) {
            this.site = this.site + this.path;
        }
        this.dest = "";
        this.instance = "";
        this.user = "";
        this.passwd = "";
        this.encrypt = false;
    }

    public void setProtocol(String string) {
        this.protocol = string;
        this.site = this.protocol + "://" + this.address + ":" + this.port + this.path;
    }

    public void setServer(String string) {
        this.address = string;
        this.site = this.protocol + "://" + this.address + ":" + this.port + this.path;
    }

    public void setPort(int n) {
        this.port = n;
        this.site = this.protocol + "://" + this.address + ":" + this.port + this.path;
    }

    public void setUser(String string) {
        this.user = string;
    }

    public void setPasswd(String string) {
        this.passwd = string;
    }

    public void setDest(String string) {
        this.dest = string;
    }

    public void setInstance(String string) {
        this.instance = string;
    }

    public void setEncrypt(boolean bl) {
        this.encrypt = bl;
    }

    public boolean getEncrypt() {
        return this.encrypt;
    }

    public void setPath(String string) {
        this.path = string;
        this.site = this.protocol + "://" + this.address + ":" + this.port + this.path;
    }

    public boolean doRequest(String string) throws IOException {
        return this.doRequest();
    }

    public boolean doRequest() throws IOException {
        int n = 0;
        int n2 = 0;
        block18: while (true) {
            block1 : switch (n) {
                case 0: {
                    String string = this.site + this.dest;
                    this.http = this.user.length() > 0 && this.passwd.length() > 0 ? new IPPHttp(string, "", this.user, this.passwd) : new IPPHttp(string);
                    ++n;
                    break;
                }
                case 1: {
                    switch (this.http.writeHeader(this.http.path, this.ipp.sizeInBytes())) {
                        case -1: 
                        case 400: 
                        case 401: 
                        case 402: 
                        case 403: 
                        case 404: 
                        case 405: 
                        case 426: {
                            if (++n2 < 5) {
                                if (this.http.reConnect()) break block1;
                                System.out.println("Could not reConnect(0)!");
                                return false;
                            }
                            return false;
                        }
                    }
                    ++n;
                    break;
                }
                case 2: {
                    byte[] byArray = new byte[]{1, 1, (byte)((this.ipp.request.operation_id & 0xFF00) >> 8), (byte)(this.ipp.request.operation_id & 0xFF), (byte)((this.ipp.request.request_id & 0xFF000000) >> 24), (byte)((this.ipp.request.request_id & 0xFF0000) >> 16), (byte)((this.ipp.request.request_id & 0xFF00) >> 8), (byte)(this.ipp.request.request_id & 0xFF)};
                    this.http.write(byArray);
                    if (this.http.checkForResponse() >= 400) {
                        if (++n2 < 5) {
                            if (this.http.reConnect()) {
                                n = 1;
                                break;
                            }
                            System.out.println("Could not reConnect(1)\n");
                            return false;
                        }
                        return false;
                    }
                    ++n;
                    break;
                }
                case 3: {
                    int n3 = -1;
                    boolean bl = false;
                    int n4 = 0;
                    while (n4 < this.ipp.attrs.size() && !bl) {
                        IPPAttribute iPPAttribute = (IPPAttribute)this.ipp.attrs.get(n4);
                        int n5 = iPPAttribute.sizeInBytes(n3);
                        byte[] byArray = iPPAttribute.getBytes(n5, n3);
                        n3 = iPPAttribute.group_tag;
                        this.http.write(byArray);
                        if (this.http.checkForResponse() >= 400) {
                            if (++n2 < 5) {
                                if (!this.http.reConnect()) {
                                    System.out.println("Could not reConnect(2)");
                                    return false;
                                }
                                n = 1;
                                bl = true;
                            } else {
                                return false;
                            }
                        }
                        ++n4;
                    }
                    if (bl) break;
                    ++n;
                    break;
                }
                case 4: {
                    byte[] byArray = new byte[]{3};
                    this.http.write(byArray);
                    if (this.http.checkForResponse() >= 400) {
                        if (++n2 < 5) {
                            if (!this.http.reConnect()) {
                                System.out.println("Could not reConnect(3)");
                                return false;
                            }
                            n = 1;
                            break;
                        }
                        return false;
                    }
                    ++n;
                    break;
                }
                case 5: {
                    int n6 = this.http.read_header();
                    switch (this.http.status) {
                        case 200: {
                            break;
                        }
                        case 401: {
                            this.http.reConnect();
                            n = 1;
                            n2 = 0;
                            break;
                        }
                        default: {
                            if (++n2 < 5) {
                                if (!this.http.reConnect()) {
                                    System.out.println("Could not reConnect(4)");
                                    return false;
                                }
                                n = 1;
                                break;
                            }
                            System.out.println("Too many errors: " + n2);
                            return false;
                        }
                    }
                    if (n6 <= 0 || n != 5) continue block18;
                    this.http.read_buffer = this.http.read(n6);
                    this.ipp = this.http.processResponse();
                    ++n;
                    break;
                }
                case 6: {
                    this.http.conn.close();
                    this.http = null;
                    return true;
                }
            }
        }
    }

    public boolean doRequest(File file) throws IOException {
        int n = 0;
        int n2 = 0;
        FileInputStream fileInputStream = null;
        block21: while (true) {
            block2 : switch (n) {
                case 0: {
                    String string = this.site + this.dest;
                    this.http = this.user.length() > 0 && this.passwd.length() > 0 ? new IPPHttp(string, "", this.user, this.passwd) : new IPPHttp(string);
                    ++n;
                    break;
                }
                case 1: {
                    if (fileInputStream != null) {
                        fileInputStream.close();
                    }
                    try {
                        fileInputStream = new FileInputStream(file);
                    }
                    catch (IOException iOException) {
                        this.last_error = -1;
                        this.error_text = "Error opening file input stream.";
                        throw iOException;
                    }
                    int n3 = this.ipp.sizeInBytes() + (int)file.length();
                    switch (this.http.writeHeader(this.http.path, n3)) {
                        case -1: 
                        case 400: 
                        case 401: 
                        case 402: 
                        case 403: 
                        case 404: 
                        case 405: 
                        case 426: {
                            if (++n2 < 5) {
                                this.http.reConnect();
                                break block2;
                            }
                            return false;
                        }
                    }
                    ++n;
                    break;
                }
                case 2: {
                    byte[] byArray = new byte[]{1, 1, (byte)((this.ipp.request.operation_id & 0xFF00) >> 8), (byte)(this.ipp.request.operation_id & 0xFF), (byte)((this.ipp.request.request_id & 0xFF000000) >> 24), (byte)((this.ipp.request.request_id & 0xFF0000) >> 16), (byte)((this.ipp.request.request_id & 0xFF00) >> 8), (byte)(this.ipp.request.request_id & 0xFF)};
                    this.http.write(byArray);
                    if (this.http.checkForResponse() >= 400) {
                        if (++n2 < 5) {
                            this.http.reConnect();
                            n = 1;
                            break;
                        }
                        return false;
                    }
                    ++n;
                    break;
                }
                case 3: {
                    int n4 = -1;
                    boolean bl = false;
                    int n5 = 0;
                    while (n5 < this.ipp.attrs.size() && !bl) {
                        IPPAttribute iPPAttribute = (IPPAttribute)this.ipp.attrs.get(n5);
                        int n6 = iPPAttribute.sizeInBytes(n4);
                        byte[] byArray = iPPAttribute.getBytes(n6, n4);
                        n4 = iPPAttribute.group_tag;
                        this.http.write(byArray);
                        if (this.http.checkForResponse() >= 400) {
                            if (++n2 < 5) {
                                this.http.reConnect();
                                n = 1;
                                bl = true;
                            } else {
                                return false;
                            }
                        }
                        ++n5;
                    }
                    if (bl) break;
                    ++n;
                    break;
                }
                case 4: {
                    byte[] byArray = new byte[]{3};
                    this.http.write(byArray);
                    if (this.http.checkForResponse() >= 400) {
                        if (++n2 < 5) {
                            this.http.reConnect();
                            n = 1;
                            break;
                        }
                        return false;
                    }
                    ++n;
                    break;
                }
                case 5: {
                    int n7;
                    byte[] byArray = new byte[1024];
                    while (n == 5 && (n7 = fileInputStream.read(byArray)) != -1) {
                        if (this.http.checkForResponse() >= 400) {
                            if (++n2 < 5) {
                                this.http.reConnect();
                                n = 1;
                                continue;
                            }
                            return false;
                        }
                        if (n7 <= 0) continue;
                        this.http.write(byArray, n7);
                    }
                    if (n != 5) break;
                    fileInputStream.close();
                    fileInputStream = null;
                    ++n;
                    break;
                }
                case 6: {
                    int n8 = this.http.read_header();
                    switch (this.http.status) {
                        case 200: {
                            break;
                        }
                        case 401: {
                            this.http.reConnect();
                            n = 1;
                            n2 = 0;
                            break;
                        }
                        default: {
                            if (++n2 < 5) {
                                this.http.reConnect();
                                n = 1;
                                break;
                            }
                            return false;
                        }
                    }
                    if (n8 <= 0 || n != 6) continue block21;
                    this.http.read_buffer = this.http.read(n8);
                    this.ipp = this.http.processResponse();
                    ++n;
                    break;
                }
                case 7: {
                    this.http.conn.close();
                    this.http = null;
                    return true;
                }
            }
        }
    }

    public CupsJob[] cupsGetJobs(boolean bl, boolean bl2) throws IOException {
        String[] stringArray = new String[]{"job-id", "job-priority", "job-k-octets", "job-state", "time-at-completed", "time-at-creation", "time-at-processing", "job-printer-uri", "document-format", "job-name", "job-originating-user-name"};
        this.ipp = new IPP();
        this.ipp.request = new IPPRequest(1, 10);
        IPPAttribute iPPAttribute = new IPPAttribute(1, 71, "attributes-charset");
        iPPAttribute.addString("", "iso-8859-1");
        this.ipp.addAttribute(iPPAttribute);
        iPPAttribute = new IPPAttribute(1, 72, "attributes-natural-language");
        iPPAttribute.addString("", "en");
        this.ipp.addAttribute(iPPAttribute);
        iPPAttribute = new IPPAttribute(1, 69, "printer-uri");
        if (this.site != null) {
            iPPAttribute.addString("", this.site);
        } else {
            iPPAttribute.addString("", "ipp://localhost/jobs");
        }
        this.ipp.addAttribute(iPPAttribute);
        iPPAttribute = new IPPAttribute(1, 66, "requesting-user-name");
        iPPAttribute.addString("", "root");
        this.ipp.addAttribute(iPPAttribute);
        if (bl) {
            iPPAttribute = new IPPAttribute(1, 34, "my-jobs");
            iPPAttribute.addBoolean(true);
            this.ipp.addAttribute(iPPAttribute);
        }
        if (bl2) {
            iPPAttribute = new IPPAttribute(1, 68, "which-jobs");
            iPPAttribute.addString("", "completed");
            this.ipp.addAttribute(iPPAttribute);
        }
        if (this.doRequest("cupsGetJobs")) {
            int n = 0;
            int n2 = -1;
            while (n < this.ipp.attrs.size() && n2 != 2) {
                iPPAttribute = (IPPAttribute)this.ipp.attrs.get(n);
                n2 = iPPAttribute.group_tag;
                if (n2 == 2) continue;
                ++n;
            }
            int n3 = 0;
            n2 = 2;
            while (n < this.ipp.attrs.size() && n2 == 2) {
                if ((iPPAttribute = (IPPAttribute)this.ipp.attrs.get(n++)) == null || iPPAttribute.name.compareTo("job-id") != 0) continue;
                ++n3;
            }
            if (n3 < 1) {
                return null;
            }
            int n4 = 0;
            CupsJob[] cupsJobArray = new CupsJob[n3];
            n4 = 0;
            while (n4 < n3) {
                cupsJobArray[n4] = new CupsJob();
                ++n4;
            }
            n2 = -1;
            n = 0;
            while (n < this.ipp.attrs.size() && n2 != 2) {
                iPPAttribute = (IPPAttribute)this.ipp.attrs.get(n);
                n2 = iPPAttribute.group_tag;
                if (n2 == 2) continue;
                ++n;
            }
            n4 = 0;
            while (n < this.ipp.attrs.size()) {
                iPPAttribute = (IPPAttribute)this.ipp.attrs.get(n);
                if (iPPAttribute.group_tag == 0) {
                    ++n4;
                } else {
                    try {
                        cupsJobArray[n4].updateAttribute(iPPAttribute);
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        return cupsJobArray;
                    }
                }
                ++n;
            }
            return cupsJobArray;
        }
        return null;
    }

    public String[] cupsGetPrinters() throws IOException {
        this.ipp = new IPP();
        this.ipp.request = new IPPRequest(1, 16386);
        IPPAttribute iPPAttribute = new IPPAttribute(1, 71, "attributes-charset");
        iPPAttribute.addString("", "iso-8859-1");
        this.ipp.addAttribute(iPPAttribute);
        iPPAttribute = new IPPAttribute(1, 72, "attributes-natural-language");
        iPPAttribute.addString("", "en");
        this.ipp.addAttribute(iPPAttribute);
        if (this.doRequest("cupsGetPrinters")) {
            int n = 0;
            int n2 = 0;
            while (n2 < this.ipp.attrs.size()) {
                iPPAttribute = (IPPAttribute)this.ipp.attrs.get(n2);
                if (iPPAttribute.name.compareTo("printer-name") == 0 && iPPAttribute.value_tag == 66) {
                    ++n;
                }
                ++n2;
            }
            if (n < 1) {
                return null;
            }
            String[] stringArray = new String[n];
            int n3 = 0;
            int n4 = 0;
            while (n4 < this.ipp.attrs.size()) {
                IPPValue iPPValue;
                iPPAttribute = (IPPAttribute)this.ipp.attrs.get(n4);
                if (iPPAttribute.group_tag >= 2 && iPPAttribute.name.compareTo("printer-name") == 0 && iPPAttribute.value_tag == 66 && (iPPValue = (IPPValue)iPPAttribute.values.get(0)) != null) {
                    stringArray[n3] = iPPValue.text;
                    ++n3;
                }
                ++n4;
            }
            return stringArray;
        }
        return null;
    }

    public String cupsGetDefault() throws IOException {
        this.ipp = new IPP();
        this.ipp.request = new IPPRequest(1, 16385);
        IPPAttribute iPPAttribute = new IPPAttribute(1, 71, "attributes-charset");
        iPPAttribute.addString("", "iso-8859-1");
        this.ipp.addAttribute(iPPAttribute);
        iPPAttribute = new IPPAttribute(1, 72, "attributes-natural-language");
        iPPAttribute.addString("", "en");
        this.ipp.addAttribute(iPPAttribute);
        if (this.doRequest("cupsGetDefault")) {
            if (this.ipp == null || this.ipp.attrs == null) {
                return null;
            }
            boolean bl = false;
            int n = 0;
            while (n < this.ipp.attrs.size()) {
                IPPValue iPPValue;
                iPPAttribute = (IPPAttribute)this.ipp.attrs.get(n);
                if (iPPAttribute.name.compareTo("printer-name") == 0 && iPPAttribute.value_tag == 66 && (iPPValue = (IPPValue)iPPAttribute.values.get(0)) != null) {
                    return iPPValue.text;
                }
                ++n;
            }
        }
        return null;
    }

    public List cupsGetPrinterAttributes(String string) throws IOException {
        this.ipp = new IPP();
        this.ipp.request = new IPPRequest(1, 11);
        IPPAttribute iPPAttribute = new IPPAttribute(1, 71, "attributes-charset");
        iPPAttribute.addString("", "iso-8859-1");
        this.ipp.addAttribute(iPPAttribute);
        iPPAttribute = new IPPAttribute(1, 72, "attributes-natural-language");
        iPPAttribute.addString("", "en");
        this.ipp.addAttribute(iPPAttribute);
        iPPAttribute = new IPPAttribute(1, 69, "printer-uri");
        iPPAttribute.addString("", this.site + "/printers/" + string);
        this.ipp.addAttribute(iPPAttribute);
        if (this.doRequest("cupsGetPrinterAttributes")) {
            return this.ipp.attrs;
        }
        return null;
    }

    public CupsJob cupsPrintFile(String string, IPPAttribute[] iPPAttributeArray) throws IOException {
        int n;
        File file = new File(string);
        if (!file.exists()) {
            this.last_error = -1;
            this.error_text = "File does not exist.";
            return null;
        }
        if (!file.canRead()) {
            this.last_error = -1;
            this.error_text = "File cannot be read.";
            return null;
        }
        this.ipp = new IPP();
        this.ipp.request = new IPPRequest(1, 2);
        IPPAttribute iPPAttribute = new IPPAttribute(1, 71, "attributes-charset");
        iPPAttribute.addString("", "iso-8859-1");
        this.ipp.addAttribute(iPPAttribute);
        iPPAttribute = new IPPAttribute(1, 72, "attributes-natural-language");
        iPPAttribute.addString("", "en");
        this.ipp.addAttribute(iPPAttribute);
        iPPAttribute = new IPPAttribute(1, 69, "printer-uri");
        iPPAttribute.addString("", this.site + this.dest);
        this.ipp.addAttribute(iPPAttribute);
        iPPAttribute = new IPPAttribute(1, 66, "job-name");
        iPPAttribute.addString("", file.getName());
        this.ipp.addAttribute(iPPAttribute);
        if (iPPAttributeArray != null) {
            n = 0;
            while (n < iPPAttributeArray.length) {
                iPPAttribute = iPPAttributeArray[n];
                this.ipp.addAttribute(iPPAttribute);
                ++n;
            }
        }
        if (this.doRequest(file)) {
            CupsJob cupsJob = new CupsJob();
            n = 0;
            while (n < this.ipp.attrs.size()) {
                iPPAttribute = (IPPAttribute)this.ipp.attrs.get(n);
                cupsJob.updateAttribute(iPPAttribute);
                ++n;
            }
            return cupsJob;
        }
        return null;
    }

    public int cupsCancelJob(String string, int n, String string2) throws IOException {
        this.ipp = new IPP();
        this.ipp.request = new IPPRequest(1, 8);
        IPPAttribute iPPAttribute = new IPPAttribute(1, 71, "attributes-charset");
        iPPAttribute.addString("", "iso-8859-1");
        this.ipp.addAttribute(iPPAttribute);
        iPPAttribute = new IPPAttribute(1, 72, "attributes-natural-language");
        iPPAttribute.addString("", "en");
        this.ipp.addAttribute(iPPAttribute);
        iPPAttribute = new IPPAttribute(1, 69, "printer-uri");
        iPPAttribute.addString("", this.site + this.dest);
        this.ipp.addAttribute(iPPAttribute);
        iPPAttribute = new IPPAttribute(1, 33, "job-id");
        iPPAttribute.addInteger(n);
        this.ipp.addAttribute(iPPAttribute);
        iPPAttribute = new IPPAttribute(1, 66, "requesting-user-name");
        iPPAttribute.addString("", string2);
        this.ipp.addAttribute(iPPAttribute);
        if (this.doRequest("cupsCancelJob")) {
            int n2 = 0;
            while (n2 < this.ipp.attrs.size()) {
                iPPAttribute = (IPPAttribute)this.ipp.attrs.get(n2);
                iPPAttribute.dump_values();
                ++n2;
            }
            return 0;
        }
        return 0;
    }

    public List cupsGetPrinterStatus(String string) throws IOException {
        this.ipp = new IPP();
        this.ipp.request = new IPPRequest(1, 11);
        IPPAttribute iPPAttribute = new IPPAttribute(1, 71, "attributes-charset");
        iPPAttribute.addString("", "iso-8859-1");
        this.ipp.addAttribute(iPPAttribute);
        iPPAttribute = new IPPAttribute(1, 72, "attributes-natural-language");
        iPPAttribute.addString("", "en");
        this.ipp.addAttribute(iPPAttribute);
        iPPAttribute = new IPPAttribute(1, 69, "printer-uri");
        String string2 = "ipp://" + this.address + ":" + this.port + "/printers/" + string;
        iPPAttribute.addString("", string2);
        this.ipp.addAttribute(iPPAttribute);
        if (this.doRequest("cupsGetPrinterStatus")) {
            return this.ipp.attrs;
        }
        return null;
    }
}

