/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jar;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import sun.misc.BASE64Encoder;
import sun.net.www.MessageHeader;
import sun.tools.jar.JarException;

public class Manifest {
    private Vector entries = new Vector();
    private byte[] tmpbuf = new byte[512];
    private Hashtable tableEntries = new Hashtable();
    static final String[] hashes = new String[]{"SHA"};
    static final byte[] EOL = new byte[]{13, 10};
    static final boolean debug = false;
    static final String VERSION = "1.0";

    static final void debug(String string) {
    }

    public Manifest() {
    }

    public Manifest(byte[] byArray) throws IOException {
        this(new ByteArrayInputStream(byArray), false);
    }

    public Manifest(InputStream inputStream) throws IOException {
        this(inputStream, true);
    }

    public Manifest(InputStream inputStream, boolean bl2) throws IOException {
        if (!inputStream.markSupported()) {
            inputStream = new BufferedInputStream(inputStream);
        }
        while (true) {
            inputStream.mark(1);
            if (inputStream.read() == -1) break;
            inputStream.reset();
            MessageHeader messageHeader = new MessageHeader(inputStream);
            if (bl2) {
                this.doHashes(messageHeader);
            }
            this.addEntry(messageHeader);
        }
    }

    public Manifest(String[] stringArray) throws IOException {
        MessageHeader messageHeader = new MessageHeader();
        messageHeader.add("Manifest-Version", VERSION);
        String string = System.getProperty("java.version");
        messageHeader.add("Created-By", "Manifest JDK " + string);
        this.addEntry(messageHeader);
        this.addFiles(null, stringArray);
    }

    public void addEntry(MessageHeader messageHeader) {
        this.entries.addElement(messageHeader);
        String string = messageHeader.findValue("Name");
        Manifest.debug("addEntry for name: " + string);
        if (string != null) {
            this.tableEntries.put(string, messageHeader);
        }
    }

    public MessageHeader getEntry(String string) {
        return (MessageHeader)this.tableEntries.get(string);
    }

    public MessageHeader entryAt(int n2) {
        return (MessageHeader)this.entries.elementAt(n2);
    }

    public Enumeration entries() {
        return this.entries.elements();
    }

    public void addFiles(File file, String[] stringArray) throws IOException {
        if (stringArray == null) {
            return;
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            File file2 = file == null ? new File(stringArray[n2]) : new File(file, stringArray[n2]);
            if (file2.isDirectory()) {
                this.addFiles(file2, file2.list());
            } else {
                this.addFile(file2);
            }
            ++n2;
        }
    }

    private final String stdToLocal(String string) {
        return string.replace('/', File.separatorChar);
    }

    private final String localToStd(String string) {
        if ((string = string.replace(File.separatorChar, '/')).startsWith("./")) {
            string = string.substring(2);
        } else if (string.startsWith("/")) {
            string = string.substring(1);
        }
        return string;
    }

    public void addFile(File file) throws IOException {
        String string = this.localToStd(file.getPath());
        if (this.tableEntries.get(string) == null) {
            MessageHeader messageHeader = new MessageHeader();
            messageHeader.add("Name", string);
            this.addEntry(messageHeader);
        }
    }

    public void doHashes(MessageHeader messageHeader) throws IOException {
        String string = messageHeader.findValue("Name");
        if (string == null || string.endsWith("/")) {
            return;
        }
        BASE64Encoder bASE64Encoder = new BASE64Encoder();
        int n2 = 0;
        while (n2 < hashes.length) {
            Object var9_9;
            FileInputStream fileInputStream = new FileInputStream(this.stdToLocal(string));
            try {
                try {
                    int n3;
                    MessageDigest messageDigest = MessageDigest.getInstance(hashes[n2]);
                    while ((n3 = ((InputStream)fileInputStream).read(this.tmpbuf, 0, this.tmpbuf.length)) != -1) {
                        messageDigest.update(this.tmpbuf, 0, n3);
                    }
                    messageHeader.set(hashes[n2] + "-Digest", bASE64Encoder.encode(messageDigest.digest()));
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new JarException("Digest algorithm " + hashes[n2] + " not available.");
                }
                var9_9 = null;
            }
            catch (Throwable throwable) {
                var9_9 = null;
                ((InputStream)fileInputStream).close();
                throw throwable;
            }
            ((InputStream)fileInputStream).close();
            ++n2;
        }
    }

    public void stream(OutputStream outputStream) throws IOException {
        PrintStream printStream = outputStream instanceof PrintStream ? (PrintStream)outputStream : new PrintStream(outputStream);
        MessageHeader messageHeader = (MessageHeader)this.entries.elementAt(0);
        if (messageHeader.findValue("Manifest-Version") == null) {
            String string = System.getProperty("java.version");
            if (messageHeader.findValue("Name") == null) {
                messageHeader.prepend("Manifest-Version", VERSION);
                messageHeader.add("Created-By", "Manifest JDK " + string);
            } else {
                printStream.print("Manifest-Version: 1.0\r\nCreated-By: " + string + "\r\n\r\n");
            }
            printStream.flush();
        }
        messageHeader.print(printStream);
        int n2 = 1;
        while (n2 < this.entries.size()) {
            MessageHeader messageHeader2 = (MessageHeader)this.entries.elementAt(n2);
            messageHeader2.print(printStream);
            ++n2;
        }
    }

    public static boolean isManifestName(String string) {
        if (string.charAt(0) == '/') {
            string = string.substring(1, string.length());
        }
        return (string = string.toUpperCase()).equals("META-INF/MANIFEST.MF");
    }
}

