/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.shell;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.util.List;
import sun.awt.shell.ShellFolderManager;

public abstract class ShellFolder
extends File {
    protected ShellFolder parent;
    private static ShellFolderManager shellFolderManager;
    static /* synthetic */ Class class$sun$awt$shell$ShellFolderManager;

    ShellFolder(ShellFolder shellFolder, String string) {
        super(string != null ? string : "ShellFolder");
        this.parent = shellFolder;
    }

    public boolean isFileSystem() {
        return !this.getPath().startsWith("ShellFolder");
    }

    protected abstract Object writeReplace() throws ObjectStreamException;

    public String getParent() {
        if (this.parent == null && this.isFileSystem()) {
            return super.getParent();
        }
        if (this.parent != null) {
            return this.parent.getPath();
        }
        return null;
    }

    public File getParentFile() {
        if (this.parent != null) {
            return this.parent;
        }
        if (this.isFileSystem()) {
            return super.getParentFile();
        }
        return null;
    }

    public abstract boolean isLink();

    public abstract ShellFolder getLinkLocation() throws FileNotFoundException;

    public abstract String getDisplayName();

    public abstract String getFolderType();

    public abstract String getExecutableType();

    public int compareTo(File file) {
        if (file == null || !(file instanceof ShellFolder) || file instanceof ShellFolder && ((ShellFolder)file).isFileSystem()) {
            if (this.isFileSystem()) {
                return super.compareTo(file);
            }
            return -1;
        }
        if (this.isFileSystem()) {
            return 1;
        }
        return this.getName().compareTo(file.getName());
    }

    public int compareTo(Object object) {
        return this.compareTo((File)object);
    }

    public Image getIcon(boolean bl2) {
        return null;
    }

    public static ShellFolder getShellFolder(File file) throws FileNotFoundException {
        if (file instanceof ShellFolder) {
            return (ShellFolder)file;
        }
        if (!file.exists()) {
            throw new FileNotFoundException();
        }
        return shellFolderManager.createShellFolder(file);
    }

    public static Object get(String string) {
        return shellFolderManager.get(string);
    }

    public static boolean isComputerNode(File file) {
        return shellFolderManager.isComputerNode(file);
    }

    public static boolean isFileSystemRoot(File file) {
        return shellFolderManager.isFileSystemRoot(file);
    }

    public static void sortFiles(List list) {
        shellFolderManager.sortFiles(list);
    }

    public boolean isAbsolute() {
        return !this.isFileSystem() || super.isAbsolute();
    }

    public File getAbsoluteFile() {
        return this.isFileSystem() ? super.getAbsoluteFile() : this;
    }

    public boolean canRead() {
        return this.isFileSystem() ? super.canRead() : true;
    }

    public boolean canWrite() {
        return this.isFileSystem() ? super.canWrite() : false;
    }

    public boolean exists() {
        return !this.isFileSystem() || ShellFolder.isFileSystemRoot(this) || super.exists();
    }

    public boolean isDirectory() {
        return this.isFileSystem() ? super.isDirectory() : true;
    }

    public boolean isFile() {
        return this.isFileSystem() ? super.isFile() : !this.isDirectory();
    }

    public long lastModified() {
        return this.isFileSystem() ? super.lastModified() : 0L;
    }

    public long length() {
        return this.isFileSystem() ? super.length() : 0L;
    }

    public boolean createNewFile() throws IOException {
        return this.isFileSystem() ? super.createNewFile() : false;
    }

    public boolean delete() {
        return this.isFileSystem() ? super.delete() : false;
    }

    public void deleteOnExit() {
        if (this.isFileSystem()) {
            super.deleteOnExit();
        }
    }

    public boolean mkdir() {
        return this.isFileSystem() ? super.mkdir() : false;
    }

    public boolean mkdirs() {
        return this.isFileSystem() ? super.mkdirs() : false;
    }

    public boolean renameTo(File file) {
        return this.isFileSystem() ? super.renameTo(file) : false;
    }

    public boolean setLastModified(long l2) {
        return this.isFileSystem() ? super.setLastModified(l2) : false;
    }

    public boolean setReadOnly() {
        return this.isFileSystem() ? super.setReadOnly() : false;
    }

    public String toString() {
        return this.isFileSystem() ? super.toString() : this.getDisplayName();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Class clazz = (Class)Toolkit.getDefaultToolkit().getDesktopProperty("Shell.shellFolderManager");
        if (clazz == null) {
            clazz = class$sun$awt$shell$ShellFolderManager == null ? (class$sun$awt$shell$ShellFolderManager = ShellFolder.class$("sun.awt.shell.ShellFolderManager")) : class$sun$awt$shell$ShellFolderManager;
        }
        try {
            shellFolderManager = (ShellFolderManager)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new Error("Could not instantiate Shell Folder Manager: " + clazz.getName());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new Error("Could not access Shell Folder Manager: " + clazz.getName());
        }
    }
}

