/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.IndexColorModel;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import sun.awt.image.GifFrame;
import sun.awt.image.ImageDecoder;
import sun.awt.image.ImageFetcher;
import sun.awt.image.ImageFormatException;
import sun.awt.image.InputStreamImageSource;
import sun.awt.image.NativeLibLoader;
import sun.awt.image.PixelStore8;

public class GifImageDecoder
extends ImageDecoder {
    private static final boolean verbose = false;
    private static final int IMAGESEP = 44;
    private static final int EXBLOCK = 33;
    private static final int EX_GRAPHICS_CONTROL = 249;
    private static final int EX_COMMENT = 254;
    private static final int EX_APPLICATION = 255;
    private static final int TERMINATOR = 59;
    private static final int TRANSPARENCYMASK = 1;
    private static final int INTERLACEMASK = 64;
    private static final int COLORMAPMASK = 128;
    PixelStore8 store;
    boolean cancatchup = true;
    int num_global_colors;
    byte[] global_colormap;
    int trans_pixel = -1;
    IndexColorModel global_model;
    Hashtable props = new Hashtable();
    byte[] saved_image;
    IndexColorModel saved_model;
    int global_width;
    int global_height;
    int global_bgpixel;
    GifFrame curframe;
    private static final int normalflags = 30;
    private static final int interlaceflags = 29;
    private short[] prefix = new short[4096];
    private byte[] suffix = new byte[4096];
    private byte[] outCode = new byte[4097];

    public GifImageDecoder(InputStreamImageSource inputStreamImageSource, InputStream inputStream) {
        super(inputStreamImageSource, inputStream);
    }

    public synchronized boolean catchupConsumer(InputStreamImageSource inputStreamImageSource, ImageConsumer imageConsumer) {
        return this.cancatchup && (this.store == null || this.store.replay(inputStreamImageSource, imageConsumer));
    }

    public void replayConsumer(ImageConsumer imageConsumer) {
        if (this.store != null) {
            this.store.replay(this.source, imageConsumer, false);
        }
    }

    public synchronized void makeStore(int n2, int n3) {
        if (this.cancatchup) {
            this.store = new PixelStore8(n2, n3);
        }
    }

    private static void error(String string) throws ImageFormatException {
        throw new ImageFormatException(string);
    }

    private int readBytes(byte[] byArray, int n2, int n3) {
        while (n3 > 0) {
            try {
                int n4 = this.input.read(byArray, n2, n3);
                if (n4 < 0) break;
                n2 += n4;
                n3 -= n4;
            }
            catch (IOException iOException) {
                break;
            }
        }
        return n3;
    }

    private static final int ExtractByte(byte[] byArray, int n2) {
        return byArray[n2] & 0xFF;
    }

    private static final int ExtractWord(byte[] byArray, int n2) {
        return byArray[n2] & 0xFF | (byArray[n2 + 1] & 0xFF) << 8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void produceImage() throws IOException, ImageFormatException {
        block36: {
            block43: {
                block42: {
                    block41: {
                        block40: {
                            block39: {
                                block38: {
                                    block37: {
                                        try {
                                            this.readHeader();
                                            var1_1 = 0;
                                            var2_2 = 0;
                                            var3_3 = -1;
                                            var4_4 = 0;
                                            var5_5 = -1;
                                            var6_6 = false;
                                            var7_7 = false;
                                            block15: while (true) lbl-1000:
                                            // 7 sources

                                            {
                                                if (this.aborted) {
                                                    break block36;
                                                }
                                                var8_8 = this.input.read();
                                                switch (var8_8) {
                                                    case 33: {
                                                        var8_8 = this.input.read();
                                                        switch (var8_8) {
                                                            case 249: {
                                                                var9_9 = new byte[6];
                                                                if (this.readBytes(var9_9, 0, 6) != 0) {
                                                                    var14_16 = null;
                                                                    break block37;
                                                                }
                                                                if (var9_9[0] != 4) break block38;
                                                                if (var9_9[5] != 0) {
                                                                    break block38;
                                                                } else {
                                                                    var5_5 = GifImageDecoder.ExtractWord(var9_9, 2) * 10;
                                                                    if (var5_5 > 0 && !var7_7) {
                                                                        var7_7 = true;
                                                                        this.cancatchup = false;
                                                                        this.store = null;
                                                                        ImageFetcher.startingAnimation();
                                                                    }
                                                                    var4_4 = var9_9[1] >> 2 & 7;
                                                                    if ((var9_9[1] & 1) != 0) {
                                                                        this.trans_pixel = GifImageDecoder.ExtractByte(var9_9, 4);
                                                                        ** break;
                                                                    }
                                                                    this.trans_pixel = -1;
                                                                    ** break;
                                                                }
                                                            }
                                                            default: {
                                                                var9_10 = false;
                                                                var10_11 = "";
                                                                while (true) {
                                                                    if ((var11_12 = this.input.read()) > 0) ** GOTO lbl49
                                                                    if (var8_8 == 254) {
                                                                        break;
                                                                    }
                                                                    ** GOTO lbl72
lbl49:
                                                                    // 1 sources

                                                                    var12_15 = new byte[var11_12];
                                                                    if (this.readBytes(var12_15, 0, var11_12) != 0) {
                                                                        break block39;
                                                                    }
                                                                    if (var8_8 == 254) {
                                                                        var10_11 = var10_11 + new String(var12_15, 0);
                                                                        continue;
                                                                    }
                                                                    if (var8_8 != 255) continue;
                                                                    if (!var9_10) ** GOTO lbl67
                                                                    if (var11_12 != 3 || var12_15[0] != 1) ** GOTO lbl66
                                                                    if (var6_6) {
                                                                        GifImageDecoder.ExtractWord(var12_15, 1);
                                                                    } else {
                                                                        var3_3 = GifImageDecoder.ExtractWord(var12_15, 1);
                                                                        var6_6 = true;
                                                                    }
                                                                    ** GOTO lbl67
lbl66:
                                                                    // 1 sources

                                                                    var9_10 = false;
lbl67:
                                                                    // 4 sources

                                                                    if (!"NETSCAPE2.0".equals(new String(var12_15, 0))) continue;
                                                                    var9_10 = true;
                                                                }
                                                                this.props.put("comment", var10_11);
lbl72:
                                                                // 2 sources

                                                                if (!var9_10 || var7_7) continue block15;
                                                                var7_7 = true;
                                                                this.cancatchup = false;
                                                                this.store = null;
                                                                ImageFetcher.startingAnimation();
                                                                ** break;
                                                            }
                                                            case -1: {
                                                                break;
                                                            }
                                                        }
                                                        break block40;
                                                    }
                                                    case 44: {
                                                        if (!var7_7) {
                                                            this.input.mark(0);
                                                        }
                                                        try {
                                                            if (!this.readImage(var1_1 == 0, var4_4, var5_5)) {
                                                                this.cancatchup = false;
                                                                break block41;
                                                            }
                                                        }
                                                        catch (Exception var11_13) {
                                                            var14_21 = null;
                                                            this.close();
                                                            return;
                                                        }
                                                    }
                                                    ++var2_2;
                                                    ++var1_1;
                                                    ** break;
                                                    default: {
                                                        if (var2_2 == 0) {
                                                            break block42;
                                                        }
                                                    }
                                                    case 59: {
                                                        if (var3_3 == 0 || var3_3-- >= 0) {
                                                            try {
                                                                if (this.curframe != null) {
                                                                    this.curframe.dispose();
                                                                    this.curframe = null;
                                                                }
                                                                this.input.reset();
                                                                this.saved_image = null;
                                                                this.saved_model = null;
                                                                var2_2 = 0;
                                                                ** break;
                                                            }
                                                            catch (IOException var11_14) {
                                                                var14_23 = null;
                                                                this.close();
                                                                return;
                                                            }
lbl119:
                                                            // 1 sources

                                                            continue block15;
                                                        }
                                                        if (this.store != null) {
                                                            this.store.imageComplete();
                                                            if (this.store.getBitState() != 2) {
                                                                this.source.setPixelStore(this, this.store);
                                                            }
                                                        }
                                                        this.imageComplete(3, true);
                                                        break block15;
                                                    }
                                                }
                                                break;
                                            }
                                            break block43;
                                        }
                                        catch (Throwable var13_27) {
                                            var14_26 = null;
                                            this.close();
                                            throw var13_27;
                                        }
                                    }
                                    this.close();
                                    return;
                                }
                                var14_17 = null;
                                this.close();
                                return;
                            }
                            var14_18 = null;
                            this.close();
                            return;
                        }
                        var14_19 = null;
                        this.close();
                        return;
                    }
                    var14_20 = null;
                    this.close();
                    return;
                }
                var14_22 = null;
                this.close();
                return;
            }
            var14_24 = null;
            this.close();
            return;
        }
        var14_25 = null;
        this.close();
    }

    private void readHeader() throws IOException, ImageFormatException {
        byte[] byArray = new byte[13];
        if (this.readBytes(byArray, 0, 13) != 0) {
            throw new IOException();
        }
        if (byArray[0] != 71 || byArray[1] != 73 || byArray[2] != 70) {
            GifImageDecoder.error("not a GIF file.");
        }
        this.global_width = GifImageDecoder.ExtractWord(byArray, 6);
        this.global_height = GifImageDecoder.ExtractWord(byArray, 8);
        int n2 = GifImageDecoder.ExtractByte(byArray, 10);
        if ((n2 & 0x80) == 0) {
            this.num_global_colors = 2;
            this.global_bgpixel = 0;
            this.global_colormap = new byte[6];
            this.global_colormap[2] = 0;
            this.global_colormap[1] = 0;
            this.global_colormap[0] = 0;
            this.global_colormap[5] = -1;
            this.global_colormap[4] = -1;
            this.global_colormap[3] = -1;
        } else {
            this.num_global_colors = 1 << (n2 & 7) + 1;
            this.global_bgpixel = GifImageDecoder.ExtractByte(byArray, 11);
            if (byArray[12] != 0) {
                this.props.put("aspectratio", "" + (double)(GifImageDecoder.ExtractByte(byArray, 12) + 15) / 64.0);
            }
            this.global_colormap = new byte[this.num_global_colors * 3];
            if (this.readBytes(this.global_colormap, 0, this.num_global_colors * 3) != 0) {
                throw new IOException();
            }
        }
        this.input.mark(Integer.MAX_VALUE);
    }

    private static native void initIDs();

    private native boolean parseImage(int var1, int var2, int var3, int var4, boolean var5, int var6, byte[] var7, byte[] var8, IndexColorModel var9);

    /*
     * Unable to fully structure code
     */
    private int sendPixels(int var1_1, int var2_2, int var3_3, int var4_4, byte[] var5_5, ColorModel var6_6) {
        if (var2_2 < 0) {
            var4_4 += var2_2;
            var2_2 = 0;
        }
        if (var2_2 + var4_4 > this.global_height) {
            var4_4 = this.global_height - var2_2;
        }
        if (var4_4 <= 0) {
            return 1;
        }
        if (var1_1 < 0) {
            var7_7 = -var1_1;
            var3_3 += var1_1;
            var9_8 = 0;
        } else {
            var7_7 = 0;
            var9_8 = var1_1;
        }
        if (var9_8 + var3_3 > this.global_width) {
            var3_3 = this.global_width - var9_8;
        }
        if (var3_3 <= 0) {
            return 1;
        }
        var8_9 = var7_7 + var3_3;
        var10_10 = var2_2 * this.global_width + var9_8;
        v0 = var11_11 = this.curframe.disposal_method == 1;
        if (this.trans_pixel < 0 || this.curframe.initialframe) ** GOTO lbl55
        if (this.saved_image != null && this.saved_model == var6_6) {
            var12_12 = var7_7;
            while (var12_12 < var8_9) {
                var13_14 = var5_5[var12_12];
                if ((var13_14 & 255) == this.trans_pixel) {
                    var5_5[var12_12] = this.saved_image[var10_10];
                } else if (var11_11) {
                    this.saved_image[var10_10] = var13_14;
                }
                ++var12_12;
                ++var10_10;
            }
        } else {
            var12_13 = -1;
            var13_15 = 1;
            var14_16 = var7_7;
            while (var14_16 < var8_9) {
                var15_17 = var5_5[var14_16];
                if ((var15_17 & 255) == this.trans_pixel) {
                    if (var12_13 >= 0 && (var13_15 = this.setPixels(var1_1 + var12_13, var2_2, var14_16 - var12_13, var4_4, var6_6, var5_5, var12_13, 0)) == 0) break;
                    var12_13 = -1;
                } else {
                    if (var12_13 < 0) {
                        var12_13 = var14_16;
                    }
                    if (var11_11) {
                        this.saved_image[var10_10] = var15_17;
                    }
                }
                ++var14_16;
                ++var10_10;
            }
            if (var12_13 >= 0) {
                var13_15 = this.setPixels(var1_1 + var12_13, var2_2, var8_9 - var12_13, var4_4, var6_6, var5_5, var12_13, 0);
            }
            return var13_15;
lbl55:
            // 1 sources

            if (var11_11) {
                System.arraycopy(var5_5, var7_7, this.saved_image, var10_10, var3_3);
            }
        }
        var12_12 = this.setPixels(var9_8, var2_2, var3_3, var4_4, var6_6, var5_5, var7_7, 0);
        if (this.store != null && !this.store.setPixels(var9_8, var2_2, var3_3, var4_4, var5_5, var7_7, 0)) {
            this.store = null;
        }
        return var12_12;
    }

    private boolean readImage(boolean bl2, int n2, int n3) throws IOException {
        int n4;
        byte[] byArray;
        int n5;
        if (this.curframe != null && !this.curframe.dispose()) {
            this.abort();
            this.store = null;
            return false;
        }
        long l2 = 0L;
        byte[] byArray2 = new byte[259];
        if (this.readBytes(byArray2, 0, 10) != 0) {
            throw new IOException();
        }
        int n6 = GifImageDecoder.ExtractWord(byArray2, 0);
        int n7 = GifImageDecoder.ExtractWord(byArray2, 2);
        int n8 = GifImageDecoder.ExtractWord(byArray2, 4);
        int n9 = GifImageDecoder.ExtractWord(byArray2, 6);
        boolean bl3 = (byArray2[8] & 0x40) != 0;
        IndexColorModel indexColorModel = this.global_model;
        if ((byArray2[8] & 0x80) != 0) {
            n5 = 1 << (byArray2[8] & 7) + 1;
            byArray = new byte[n5 * 3];
            byArray[0] = byArray2[9];
            if (this.readBytes(byArray, 1, n5 * 3 - 1) != 0) {
                throw new IOException();
            }
            if (this.readBytes(byArray2, 9, 1) != 0) {
                throw new IOException();
            }
            if (this.trans_pixel >= n5) {
                n5 = this.trans_pixel + 1;
                byArray = GifImageDecoder.grow_colormap(byArray, n5);
            }
            indexColorModel = new IndexColorModel(8, n5, byArray, 0, false, this.trans_pixel);
        } else if (indexColorModel == null || this.trans_pixel != indexColorModel.getTransparentPixel()) {
            if (this.trans_pixel >= this.num_global_colors) {
                this.num_global_colors = this.trans_pixel + 1;
                this.global_colormap = GifImageDecoder.grow_colormap(this.global_colormap, this.num_global_colors);
            }
            this.global_model = indexColorModel = new IndexColorModel(8, this.num_global_colors, this.global_colormap, 0, false, this.trans_pixel);
        }
        if (bl2) {
            if (this.global_width == 0) {
                this.global_width = n8;
            }
            if (this.global_height == 0) {
                this.global_height = n9;
            }
            this.makeStore(this.global_width, this.global_height);
            if (this.store != null) {
                this.store.setProperties(this.props);
                this.store.setColorModel(indexColorModel);
            }
            this.setDimensions(this.global_width, this.global_height);
            this.setProperties(this.props);
            this.setColorModel(indexColorModel);
            this.headerComplete();
        } else if (this.store != null && indexColorModel != this.store.getColorModel()) {
            this.cancatchup = false;
            this.store = null;
        }
        if (n2 == 1 && this.saved_image == null) {
            this.saved_image = new byte[this.global_width * this.global_height];
            if (n9 < this.global_height && indexColorModel != null && (n5 = (int)((byte)indexColorModel.getTransparentPixel())) >= 0) {
                byArray = new byte[this.global_width];
                n4 = 0;
                while (n4 < this.global_width) {
                    byArray[n4] = n5;
                    n4 += 1;
                }
                this.setPixels(0, 0, this.global_width, n7, (ColorModel)indexColorModel, byArray, 0, 0);
                this.setPixels(0, n7 + n9, this.global_width, this.global_height - n9 - n7, (ColorModel)indexColorModel, byArray, 0, 0);
            }
        }
        n5 = bl3 ? 29 : 30;
        this.setHints(n5);
        if (this.store != null) {
            this.store.setHints(n5);
        }
        this.curframe = new GifFrame(this, n2, n3, this.curframe == null, indexColorModel, n6, n7, n8, n9);
        byArray = new byte[n8];
        n4 = this.parseImage(n6, n7, n8, n9, bl3, GifImageDecoder.ExtractByte(byArray2, 9), byArray2, byArray, indexColorModel) ? 1 : 0;
        if (!n4) {
            this.abort();
            this.store = null;
        }
        return n4 != 0;
    }

    public static byte[] grow_colormap(byte[] byArray, int n2) {
        byte[] byArray2 = new byte[n2 * 3];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        return byArray2;
    }

    static {
        NativeLibLoader.loadLibraries();
        GifImageDecoder.initIDs();
    }
}

