/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.colorchooser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.colorchooser.CenterLayout;
import javax.swing.colorchooser.SmartGridLayout;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class DefaultRGBChooserPanel
extends AbstractColorChooserPanel
implements ChangeListener {
    protected JSlider redSlider;
    protected JSlider greenSlider;
    protected JSlider blueSlider;
    protected JSpinner redField;
    protected JSpinner blueField;
    protected JSpinner greenField;
    private final int minValue = 0;
    private final int maxValue = 255;
    private boolean isAdjusting = false;

    private void setColor(Color color) {
        int n2 = color.getRed();
        int n3 = color.getBlue();
        int n4 = color.getGreen();
        if (this.redSlider.getValue() != n2) {
            this.redSlider.setValue(n2);
        }
        if (this.greenSlider.getValue() != n4) {
            this.greenSlider.setValue(n4);
        }
        if (this.blueSlider.getValue() != n3) {
            this.blueSlider.setValue(n3);
        }
        if ((Integer)this.redField.getValue() != n2) {
            this.redField.setValue(new Integer(n2));
        }
        if ((Integer)this.greenField.getValue() != n4) {
            this.greenField.setValue(new Integer(n4));
        }
        if ((Integer)this.blueField.getValue() != n3) {
            this.blueField.setValue(new Integer(n3));
        }
    }

    public String getDisplayName() {
        return UIManager.getString("ColorChooser.rgbNameText");
    }

    public int getMnemonic() {
        return AbstractColorChooserPanel.getInt("ColorChooser.rgbMnemonic", -1);
    }

    public int getDisplayedMnemonicIndex() {
        return AbstractColorChooserPanel.getInt("ColorChooser.rgbDisplayedMnemonicIndex", -1);
    }

    public Icon getSmallDisplayIcon() {
        return null;
    }

    public Icon getLargeDisplayIcon() {
        return null;
    }

    public void installChooserPanel(JColorChooser jColorChooser) {
        super.installChooserPanel(jColorChooser);
    }

    protected void buildChooser() {
        String string = UIManager.getString("ColorChooser.rgbRedText");
        String string2 = UIManager.getString("ColorChooser.rgbGreenText");
        String string3 = UIManager.getString("ColorChooser.rgbBlueText");
        this.setLayout(new BorderLayout());
        Color color = this.getColorFromModel();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new SmartGridLayout(3, 3));
        this.add((Component)jPanel, "Center");
        JLabel jLabel = new JLabel(string);
        jLabel.setDisplayedMnemonic(UIManager.getInt("ColorChooser.rgbRedMnemonic"));
        jPanel.add(jLabel);
        this.redSlider = new JSlider(0, 0, 255, color.getRed());
        this.redSlider.setMajorTickSpacing(85);
        this.redSlider.setMinorTickSpacing(17);
        this.redSlider.setPaintTicks(true);
        this.redSlider.setPaintLabels(true);
        jPanel.add(this.redSlider);
        this.redField = new JSpinner(new SpinnerNumberModel(color.getRed(), 0, 255, 1));
        jLabel.setLabelFor(this.redSlider);
        JPanel jPanel2 = new JPanel(new CenterLayout());
        this.redField.addChangeListener(this);
        jPanel2.add(this.redField);
        jPanel.add(jPanel2);
        jLabel = new JLabel(string2);
        jLabel.setDisplayedMnemonic(UIManager.getInt("ColorChooser.rgbGreenMnemonic"));
        jPanel.add(jLabel);
        this.greenSlider = new JSlider(0, 0, 255, color.getGreen());
        this.greenSlider.setMajorTickSpacing(85);
        this.greenSlider.setMinorTickSpacing(17);
        this.greenSlider.setPaintTicks(true);
        this.greenSlider.setPaintLabels(true);
        jPanel.add(this.greenSlider);
        this.greenField = new JSpinner(new SpinnerNumberModel(color.getGreen(), 0, 255, 1));
        jLabel.setLabelFor(this.greenSlider);
        JPanel jPanel3 = new JPanel(new CenterLayout());
        jPanel3.add(this.greenField);
        this.greenField.addChangeListener(this);
        jPanel.add(jPanel3);
        jLabel = new JLabel(string3);
        jLabel.setDisplayedMnemonic(UIManager.getInt("ColorChooser.rgbBlueMnemonic"));
        jPanel.add(jLabel);
        this.blueSlider = new JSlider(0, 0, 255, color.getBlue());
        this.blueSlider.setMajorTickSpacing(85);
        this.blueSlider.setMinorTickSpacing(17);
        this.blueSlider.setPaintTicks(true);
        this.blueSlider.setPaintLabels(true);
        jPanel.add(this.blueSlider);
        this.blueField = new JSpinner(new SpinnerNumberModel(color.getBlue(), 0, 255, 1));
        jLabel.setLabelFor(this.blueSlider);
        JPanel jPanel4 = new JPanel(new CenterLayout());
        jPanel4.add(this.blueField);
        this.blueField.addChangeListener(this);
        jPanel.add(jPanel4);
        this.redSlider.addChangeListener(this);
        this.greenSlider.addChangeListener(this);
        this.blueSlider.addChangeListener(this);
        this.redSlider.putClientProperty("JSlider.isFilled", Boolean.TRUE);
        this.greenSlider.putClientProperty("JSlider.isFilled", Boolean.TRUE);
        this.blueSlider.putClientProperty("JSlider.isFilled", Boolean.TRUE);
    }

    public void uninstallChooserPanel(JColorChooser jColorChooser) {
        super.uninstallChooserPanel(jColorChooser);
    }

    public void updateChooser() {
        if (!this.isAdjusting) {
            this.isAdjusting = true;
            this.setColor(this.getColorFromModel());
            this.isAdjusting = false;
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() instanceof JSlider && !this.isAdjusting) {
            int n2 = this.redSlider.getValue();
            int n3 = this.greenSlider.getValue();
            int n4 = this.blueSlider.getValue();
            Color color = new Color(n2, n3, n4);
            this.getColorSelectionModel().setSelectedColor(color);
        } else if (changeEvent.getSource() instanceof JSpinner && !this.isAdjusting) {
            int n5 = (Integer)this.redField.getValue();
            int n6 = (Integer)this.greenField.getValue();
            int n7 = (Integer)this.blueField.getValue();
            Color color = new Color(n5, n6, n7);
            this.getColorSelectionModel().setSelectedColor(color);
        }
    }
}

