/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.IllegalComponentStateException;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Locale;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleEditableText;
import javax.accessibility.AccessibleIcon;
import javax.accessibility.AccessibleRelationSet;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleTable;
import javax.accessibility.AccessibleText;
import javax.accessibility.AccessibleValue;
import javax.swing.AbstractActionPropertyChangeListener;
import javax.swing.Action;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.ListCellRenderer;
import javax.swing.MutableComboBoxModel;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComboBoxUI;
import javax.swing.plaf.basic.ComboPopup;

public class JComboBox
extends JComponent
implements ItemSelectable,
ListDataListener,
ActionListener,
Accessible {
    private static final String uiClassID = "ComboBoxUI";
    protected ComboBoxModel dataModel;
    protected ListCellRenderer renderer;
    protected ComboBoxEditor editor;
    protected int maximumRowCount = 8;
    protected boolean isEditable = false;
    protected KeySelectionManager keySelectionManager = null;
    protected String actionCommand = "comboBoxChanged";
    protected boolean lightWeightPopupEnabled = JPopupMenu.getDefaultLightWeightPopupEnabled();
    protected Object selectedItemReminder = null;
    private Object prototypeDisplayValue;
    private boolean firingActionEvent = false;
    private boolean selectingItem = false;
    private Action action;
    private PropertyChangeListener actionPropertyChangeListener;
    static /* synthetic */ Class class$java$awt$event$ItemListener;
    static /* synthetic */ Class class$java$awt$event$ActionListener;
    static /* synthetic */ Class class$javax$swing$event$PopupMenuListener;

    public JComboBox(ComboBoxModel comboBoxModel) {
        this.setModel(comboBoxModel);
        this.init();
    }

    public JComboBox(Object[] objectArray) {
        this.setModel(new DefaultComboBoxModel(objectArray));
        this.init();
    }

    public JComboBox(Vector vector) {
        this.setModel(new DefaultComboBoxModel(vector));
        this.init();
    }

    public JComboBox() {
        this.setModel(new DefaultComboBoxModel());
        this.init();
    }

    private void init() {
        this.installAncestorListener();
        this.setOpaque(true);
        this.updateUI();
    }

    protected void installAncestorListener() {
        this.addAncestorListener(new AncestorListener(){

            public void ancestorAdded(AncestorEvent ancestorEvent) {
                JComboBox.this.hidePopup();
            }

            public void ancestorRemoved(AncestorEvent ancestorEvent) {
                JComboBox.this.hidePopup();
            }

            public void ancestorMoved(AncestorEvent ancestorEvent) {
                if (ancestorEvent.getSource() != JComboBox.this) {
                    JComboBox.this.hidePopup();
                }
            }
        });
    }

    public void setUI(ComboBoxUI comboBoxUI) {
        super.setUI(comboBoxUI);
    }

    public void updateUI() {
        this.setUI((ComboBoxUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public ComboBoxUI getUI() {
        return (ComboBoxUI)this.ui;
    }

    public void setModel(ComboBoxModel comboBoxModel) {
        ComboBoxModel comboBoxModel2 = this.dataModel;
        if (comboBoxModel2 != null) {
            comboBoxModel2.removeListDataListener(this);
        }
        this.dataModel = comboBoxModel;
        this.dataModel.addListDataListener(this);
        this.selectedItemReminder = this.dataModel.getSelectedItem();
        this.firePropertyChange("model", comboBoxModel2, this.dataModel);
    }

    public ComboBoxModel getModel() {
        return this.dataModel;
    }

    public void setLightWeightPopupEnabled(boolean bl2) {
        boolean bl3 = this.lightWeightPopupEnabled;
        this.lightWeightPopupEnabled = bl2;
        this.firePropertyChange("lightWeightPopupEnabled", bl3, this.lightWeightPopupEnabled);
    }

    public boolean isLightWeightPopupEnabled() {
        return this.lightWeightPopupEnabled;
    }

    public void setEditable(boolean bl2) {
        boolean bl3 = this.isEditable;
        this.isEditable = bl2;
        this.firePropertyChange("editable", bl3, this.isEditable);
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public void setMaximumRowCount(int n2) {
        int n3 = this.maximumRowCount;
        this.maximumRowCount = n2;
        this.firePropertyChange("maximumRowCount", n3, this.maximumRowCount);
    }

    public int getMaximumRowCount() {
        return this.maximumRowCount;
    }

    public void setRenderer(ListCellRenderer listCellRenderer) {
        ListCellRenderer listCellRenderer2 = this.renderer;
        this.renderer = listCellRenderer;
        this.firePropertyChange("renderer", listCellRenderer2, this.renderer);
        this.invalidate();
    }

    public ListCellRenderer getRenderer() {
        return this.renderer;
    }

    public void setEditor(ComboBoxEditor comboBoxEditor) {
        ComboBoxEditor comboBoxEditor2 = this.editor;
        if (this.editor != null) {
            this.editor.removeActionListener(this);
        }
        this.editor = comboBoxEditor;
        if (this.editor != null) {
            this.editor.addActionListener(this);
        }
        this.firePropertyChange("editor", comboBoxEditor2, this.editor);
    }

    public ComboBoxEditor getEditor() {
        return this.editor;
    }

    public void setSelectedItem(Object object) {
        Object object2 = this.selectedItemReminder;
        if (object2 == null || !object2.equals(object)) {
            if (object != null && !this.isEditable()) {
                boolean bl2 = false;
                int n2 = 0;
                while (n2 < this.dataModel.getSize()) {
                    if (object.equals(this.dataModel.getElementAt(n2))) {
                        bl2 = true;
                        break;
                    }
                    ++n2;
                }
                if (!bl2) {
                    return;
                }
            }
            this.selectingItem = true;
            this.dataModel.setSelectedItem(object);
            this.selectingItem = false;
            if (this.selectedItemReminder != this.dataModel.getSelectedItem()) {
                this.selectedItemChanged();
            }
        }
        this.fireActionEvent();
    }

    public Object getSelectedItem() {
        return this.dataModel.getSelectedItem();
    }

    public void setSelectedIndex(int n2) {
        int n3 = this.dataModel.getSize();
        if (n2 == -1) {
            this.setSelectedItem(null);
        } else {
            if (n2 < -1 || n2 >= n3) {
                throw new IllegalArgumentException("setSelectedIndex: " + n2 + " out of bounds");
            }
            this.setSelectedItem(this.dataModel.getElementAt(n2));
        }
    }

    public int getSelectedIndex() {
        Object object = this.dataModel.getSelectedItem();
        int n2 = 0;
        int n3 = this.dataModel.getSize();
        while (n2 < n3) {
            Object object2 = this.dataModel.getElementAt(n2);
            if (object2 != null && object2.equals(object)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public Object getPrototypeDisplayValue() {
        return this.prototypeDisplayValue;
    }

    public void setPrototypeDisplayValue(Object object) {
        Object object2 = this.prototypeDisplayValue;
        this.prototypeDisplayValue = object;
        this.firePropertyChange("prototypeDisplayValue", object2, object);
    }

    public void addItem(Object object) {
        this.checkMutableComboBoxModel();
        ((MutableComboBoxModel)this.dataModel).addElement(object);
    }

    public void insertItemAt(Object object, int n2) {
        this.checkMutableComboBoxModel();
        ((MutableComboBoxModel)this.dataModel).insertElementAt(object, n2);
    }

    public void removeItem(Object object) {
        this.checkMutableComboBoxModel();
        ((MutableComboBoxModel)this.dataModel).removeElement(object);
    }

    public void removeItemAt(int n2) {
        this.checkMutableComboBoxModel();
        ((MutableComboBoxModel)this.dataModel).removeElementAt(n2);
    }

    public void removeAllItems() {
        this.checkMutableComboBoxModel();
        MutableComboBoxModel mutableComboBoxModel = (MutableComboBoxModel)this.dataModel;
        int n2 = mutableComboBoxModel.getSize();
        if (mutableComboBoxModel instanceof DefaultComboBoxModel) {
            ((DefaultComboBoxModel)mutableComboBoxModel).removeAllElements();
        } else {
            int n3 = 0;
            while (n3 < n2) {
                Object object = mutableComboBoxModel.getElementAt(0);
                mutableComboBoxModel.removeElement(object);
                ++n3;
            }
        }
        if (this.isEditable()) {
            this.editor.setItem(null);
        }
    }

    void checkMutableComboBoxModel() {
        if (!(this.dataModel instanceof MutableComboBoxModel)) {
            throw new RuntimeException("Cannot use this method with a non-Mutable data model.");
        }
    }

    public void showPopup() {
        this.setPopupVisible(true);
    }

    public void hidePopup() {
        this.setPopupVisible(false);
    }

    public void setPopupVisible(boolean bl2) {
        this.getUI().setPopupVisible(this, bl2);
    }

    public boolean isPopupVisible() {
        return this.getUI().isPopupVisible(this);
    }

    public void addItemListener(ItemListener itemListener) {
        this.listenerList.add(class$java$awt$event$ItemListener == null ? (class$java$awt$event$ItemListener = JComboBox.class$("java.awt.event.ItemListener")) : class$java$awt$event$ItemListener, itemListener);
    }

    public void removeItemListener(ItemListener itemListener) {
        this.listenerList.remove(class$java$awt$event$ItemListener == null ? (class$java$awt$event$ItemListener = JComboBox.class$("java.awt.event.ItemListener")) : class$java$awt$event$ItemListener, itemListener);
    }

    public ItemListener[] getItemListeners() {
        return (ItemListener[])this.listenerList.getListeners(class$java$awt$event$ItemListener == null ? (class$java$awt$event$ItemListener = JComboBox.class$("java.awt.event.ItemListener")) : class$java$awt$event$ItemListener);
    }

    public void addActionListener(ActionListener actionListener) {
        this.listenerList.add(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = JComboBox.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        if (actionListener != null && this.getAction() == actionListener) {
            this.setAction(null);
        } else {
            this.listenerList.remove(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = JComboBox.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, actionListener);
        }
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.listenerList.getListeners(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = JComboBox.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener);
    }

    public void addPopupMenuListener(PopupMenuListener popupMenuListener) {
        this.listenerList.add(class$javax$swing$event$PopupMenuListener == null ? (class$javax$swing$event$PopupMenuListener = JComboBox.class$("javax.swing.event.PopupMenuListener")) : class$javax$swing$event$PopupMenuListener, popupMenuListener);
    }

    public void removePopupMenuListener(PopupMenuListener popupMenuListener) {
        this.listenerList.remove(class$javax$swing$event$PopupMenuListener == null ? (class$javax$swing$event$PopupMenuListener = JComboBox.class$("javax.swing.event.PopupMenuListener")) : class$javax$swing$event$PopupMenuListener, popupMenuListener);
    }

    public PopupMenuListener[] getPopupMenuListeners() {
        return (PopupMenuListener[])this.listenerList.getListeners(class$javax$swing$event$PopupMenuListener == null ? (class$javax$swing$event$PopupMenuListener = JComboBox.class$("javax.swing.event.PopupMenuListener")) : class$javax$swing$event$PopupMenuListener);
    }

    public void firePopupMenuWillBecomeVisible() {
        Object[] objectArray = this.listenerList.getListenerList();
        PopupMenuEvent popupMenuEvent = null;
        int n2 = objectArray.length - 2;
        while (n2 >= 0) {
            if (objectArray[n2] == (class$javax$swing$event$PopupMenuListener == null ? JComboBox.class$("javax.swing.event.PopupMenuListener") : class$javax$swing$event$PopupMenuListener)) {
                if (popupMenuEvent == null) {
                    popupMenuEvent = new PopupMenuEvent(this);
                }
                ((PopupMenuListener)objectArray[n2 + 1]).popupMenuWillBecomeVisible(popupMenuEvent);
            }
            n2 -= 2;
        }
    }

    public void firePopupMenuWillBecomeInvisible() {
        Object[] objectArray = this.listenerList.getListenerList();
        PopupMenuEvent popupMenuEvent = null;
        int n2 = objectArray.length - 2;
        while (n2 >= 0) {
            if (objectArray[n2] == (class$javax$swing$event$PopupMenuListener == null ? JComboBox.class$("javax.swing.event.PopupMenuListener") : class$javax$swing$event$PopupMenuListener)) {
                if (popupMenuEvent == null) {
                    popupMenuEvent = new PopupMenuEvent(this);
                }
                ((PopupMenuListener)objectArray[n2 + 1]).popupMenuWillBecomeInvisible(popupMenuEvent);
            }
            n2 -= 2;
        }
    }

    public void firePopupMenuCanceled() {
        Object[] objectArray = this.listenerList.getListenerList();
        PopupMenuEvent popupMenuEvent = null;
        int n2 = objectArray.length - 2;
        while (n2 >= 0) {
            if (objectArray[n2] == (class$javax$swing$event$PopupMenuListener == null ? JComboBox.class$("javax.swing.event.PopupMenuListener") : class$javax$swing$event$PopupMenuListener)) {
                if (popupMenuEvent == null) {
                    popupMenuEvent = new PopupMenuEvent(this);
                }
                ((PopupMenuListener)objectArray[n2 + 1]).popupMenuCanceled(popupMenuEvent);
            }
            n2 -= 2;
        }
    }

    public void setActionCommand(String string) {
        this.actionCommand = string;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public void setAction(Action action) {
        Action action2 = this.getAction();
        if (this.action == null || !this.action.equals(action)) {
            this.action = action;
            if (action2 != null) {
                this.removeActionListener(action2);
                action2.removePropertyChangeListener(this.actionPropertyChangeListener);
                this.actionPropertyChangeListener = null;
            }
            this.configurePropertiesFromAction(this.action);
            if (this.action != null) {
                if (!this.isListener(class$java$awt$event$ActionListener == null ? (class$java$awt$event$ActionListener = JComboBox.class$("java.awt.event.ActionListener")) : class$java$awt$event$ActionListener, this.action)) {
                    this.addActionListener(this.action);
                }
                this.actionPropertyChangeListener = this.createActionPropertyChangeListener(this.action);
                this.action.addPropertyChangeListener(this.actionPropertyChangeListener);
            }
            this.firePropertyChange("action", action2, this.action);
            this.revalidate();
            this.repaint();
        }
    }

    private boolean isListener(Class clazz, ActionListener actionListener) {
        boolean bl2 = false;
        Object[] objectArray = this.listenerList.getListenerList();
        int n2 = objectArray.length - 2;
        while (n2 >= 0) {
            if (objectArray[n2] == clazz && objectArray[n2 + 1] == actionListener) {
                bl2 = true;
            }
            n2 -= 2;
        }
        return bl2;
    }

    public Action getAction() {
        return this.action;
    }

    protected void configurePropertiesFromAction(Action action) {
        this.setEnabled(action != null ? action.isEnabled() : true);
        this.setToolTipText(action != null ? (String)action.getValue("ShortDescription") : null);
    }

    protected PropertyChangeListener createActionPropertyChangeListener(Action action) {
        return new AbstractActionPropertyChangeListener(this, action){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                JComboBox jComboBox = (JComboBox)this.getTarget();
                if (jComboBox == null) {
                    Action action = (Action)propertyChangeEvent.getSource();
                    action.removePropertyChangeListener(this);
                } else if (propertyChangeEvent.getPropertyName().equals("ShortDescription")) {
                    String string2 = (String)propertyChangeEvent.getNewValue();
                    jComboBox.setToolTipText(string2);
                } else if (string.equals("enabled")) {
                    Boolean bl2 = (Boolean)propertyChangeEvent.getNewValue();
                    jComboBox.setEnabled(bl2);
                    jComboBox.repaint();
                }
            }
        };
    }

    protected void fireItemStateChanged(ItemEvent itemEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        int n2 = objectArray.length - 2;
        while (n2 >= 0) {
            if (objectArray[n2] == (class$java$awt$event$ItemListener == null ? JComboBox.class$("java.awt.event.ItemListener") : class$java$awt$event$ItemListener)) {
                ((ItemListener)objectArray[n2 + 1]).itemStateChanged(itemEvent);
            }
            n2 -= 2;
        }
    }

    protected void fireActionEvent() {
        if (!this.firingActionEvent) {
            this.firingActionEvent = true;
            ActionEvent actionEvent = null;
            Object[] objectArray = this.listenerList.getListenerList();
            long l2 = EventQueue.getMostRecentEventTime();
            int n2 = 0;
            AWTEvent aWTEvent = EventQueue.getCurrentEvent();
            if (aWTEvent instanceof InputEvent) {
                n2 = ((InputEvent)aWTEvent).getModifiers();
            } else if (aWTEvent instanceof ActionEvent) {
                n2 = ((ActionEvent)aWTEvent).getModifiers();
            }
            int n3 = objectArray.length - 2;
            while (n3 >= 0) {
                if (objectArray[n3] == (class$java$awt$event$ActionListener == null ? JComboBox.class$("java.awt.event.ActionListener") : class$java$awt$event$ActionListener)) {
                    if (actionEvent == null) {
                        actionEvent = new ActionEvent(this, 1001, this.getActionCommand(), l2, n2);
                    }
                    ((ActionListener)objectArray[n3 + 1]).actionPerformed(actionEvent);
                }
                n3 -= 2;
            }
            this.firingActionEvent = false;
        }
    }

    protected void selectedItemChanged() {
        if (this.selectedItemReminder != null) {
            this.fireItemStateChanged(new ItemEvent(this, 701, this.selectedItemReminder, 2));
        }
        this.selectedItemReminder = this.dataModel.getSelectedItem();
        if (this.selectedItemReminder != null) {
            this.fireItemStateChanged(new ItemEvent(this, 701, this.selectedItemReminder, 1));
        }
    }

    public Object[] getSelectedObjects() {
        Object object = this.getSelectedItem();
        if (object == null) {
            return new Object[0];
        }
        Object[] objectArray = new Object[]{object};
        return objectArray;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = this.getEditor().getItem();
        this.setPopupVisible(false);
        this.getModel().setSelectedItem(object);
        String string = this.getActionCommand();
        this.setActionCommand("comboBoxEdited");
        this.fireActionEvent();
        this.setActionCommand(string);
    }

    public void contentsChanged(ListDataEvent listDataEvent) {
        Object object = this.selectedItemReminder;
        Object object2 = this.dataModel.getSelectedItem();
        if (object == null || !object.equals(object2)) {
            this.selectedItemChanged();
            if (!this.selectingItem) {
                this.fireActionEvent();
            }
        }
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
    }

    public boolean selectWithKeyChar(char c2) {
        int n2;
        if (this.keySelectionManager == null) {
            this.keySelectionManager = this.createDefaultKeySelectionManager();
        }
        if ((n2 = this.keySelectionManager.selectionForKey(c2, this.getModel())) != -1) {
            this.setSelectedIndex(n2);
            return true;
        }
        return false;
    }

    public void setEnabled(boolean bl2) {
        super.setEnabled(bl2);
        this.firePropertyChange("enabled", !this.isEnabled(), this.isEnabled());
    }

    public void configureEditor(ComboBoxEditor comboBoxEditor, Object object) {
        comboBoxEditor.setItem(object);
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 9) {
            this.hidePopup();
        }
        super.processKeyEvent(keyEvent);
    }

    public void setKeySelectionManager(KeySelectionManager keySelectionManager) {
        this.keySelectionManager = keySelectionManager;
    }

    public KeySelectionManager getKeySelectionManager() {
        return this.keySelectionManager;
    }

    public int getItemCount() {
        return this.dataModel.getSize();
    }

    public Object getItemAt(int n2) {
        return this.dataModel.getElementAt(n2);
    }

    protected KeySelectionManager createDefaultKeySelectionManager() {
        return new DefaultKeySelectionManager();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.getUIClassID().equals(uiClassID)) {
            byte by = JComponent.getWriteObjCounter(this);
            by = (byte)(by - 1);
            JComponent.setWriteObjCounter(this, by);
            if (by == 0 && this.ui != null) {
                this.ui.installUI(this);
            }
        }
    }

    protected String paramString() {
        String string = this.selectedItemReminder != null ? this.selectedItemReminder.toString() : "";
        String string2 = this.isEditable ? "true" : "false";
        String string3 = this.lightWeightPopupEnabled ? "true" : "false";
        return super.paramString() + ",isEditable=" + string2 + ",lightWeightPopupEnabled=" + string3 + ",maximumRowCount=" + this.maximumRowCount + ",selectedItemReminder=" + string;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJComboBox();
        }
        return this.accessibleContext;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class AccessibleJComboBox
    extends JComponent.AccessibleJComponent
    implements AccessibleAction,
    AccessibleSelection {
        private EditorAccessibleContext editorAccessibleContext = null;

        protected AccessibleJComboBox() {
        }

        public int getAccessibleChildrenCount() {
            if (JComboBox.this.ui != null) {
                return JComboBox.this.ui.getAccessibleChildrenCount(JComboBox.this);
            }
            return super.getAccessibleChildrenCount();
        }

        public Accessible getAccessibleChild(int n2) {
            if (JComboBox.this.ui != null) {
                return JComboBox.this.ui.getAccessibleChild(JComboBox.this, n2);
            }
            return super.getAccessibleChild(n2);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.COMBO_BOX;
        }

        public AccessibleAction getAccessibleAction() {
            return this;
        }

        public String getAccessibleActionDescription(int n2) {
            if (n2 == 0) {
                return UIManager.getString("ComboBox.togglePopupText");
            }
            return null;
        }

        public int getAccessibleActionCount() {
            return 1;
        }

        public boolean doAccessibleAction(int n2) {
            if (n2 == 0) {
                JComboBox.this.setPopupVisible(!JComboBox.this.isPopupVisible());
                return true;
            }
            return false;
        }

        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        public int getAccessibleSelectionCount() {
            Object object = JComboBox.this.getSelectedItem();
            if (object != null) {
                return 1;
            }
            return 0;
        }

        public Accessible getAccessibleSelection(int n2) {
            AccessibleSelection accessibleSelection;
            JList jList;
            AccessibleContext accessibleContext;
            Accessible accessible = JComboBox.this.getUI().getAccessibleChild(JComboBox.this, 0);
            if (accessible != null && accessible instanceof ComboPopup && (accessibleContext = (jList = ((ComboPopup)((Object)accessible)).getList()).getAccessibleContext()) != null && (accessibleSelection = accessibleContext.getAccessibleSelection()) != null) {
                return accessibleSelection.getAccessibleSelection(n2);
            }
            return null;
        }

        public boolean isAccessibleChildSelected(int n2) {
            return JComboBox.this.getSelectedIndex() == n2;
        }

        public void addAccessibleSelection(int n2) {
            JComboBox.this.setSelectedIndex(n2);
        }

        public void removeAccessibleSelection(int n2) {
            if (JComboBox.this.getSelectedIndex() == n2) {
                this.clearAccessibleSelection();
            }
        }

        public void clearAccessibleSelection() {
            JComboBox.this.setSelectedIndex(-1);
        }

        public void selectAllAccessibleSelection() {
        }

        private class EditorAccessibleContext
        extends AccessibleContext {
            private AccessibleContext ac;

            private EditorAccessibleContext() {
            }

            EditorAccessibleContext(Accessible accessible) {
                this.ac = accessible.getAccessibleContext();
            }

            public String getAccessibleName() {
                return this.ac.getAccessibleName();
            }

            public void setAccessibleName(String string) {
                this.ac.setAccessibleName(string);
            }

            public String getAccessibleDescription() {
                return this.ac.getAccessibleDescription();
            }

            public void setAccessibleDescription(String string) {
                this.ac.setAccessibleDescription(string);
            }

            public AccessibleRole getAccessibleRole() {
                return this.ac.getAccessibleRole();
            }

            public AccessibleStateSet getAccessibleStateSet() {
                return this.ac.getAccessibleStateSet();
            }

            public Accessible getAccessibleParent() {
                return this.ac.getAccessibleParent();
            }

            public void setAccessibleParent(Accessible accessible) {
                this.ac.setAccessibleParent(accessible);
            }

            public int getAccessibleIndexInParent() {
                return JComboBox.this.getSelectedIndex();
            }

            public int getAccessibleChildrenCount() {
                return this.ac.getAccessibleChildrenCount();
            }

            public Accessible getAccessibleChild(int n2) {
                return this.ac.getAccessibleChild(n2);
            }

            public Locale getLocale() throws IllegalComponentStateException {
                return this.ac.getLocale();
            }

            public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                this.ac.addPropertyChangeListener(propertyChangeListener);
            }

            public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
                this.ac.removePropertyChangeListener(propertyChangeListener);
            }

            public AccessibleAction getAccessibleAction() {
                return this.ac.getAccessibleAction();
            }

            public AccessibleComponent getAccessibleComponent() {
                return this.ac.getAccessibleComponent();
            }

            public AccessibleSelection getAccessibleSelection() {
                return this.ac.getAccessibleSelection();
            }

            public AccessibleText getAccessibleText() {
                return this.ac.getAccessibleText();
            }

            public AccessibleEditableText getAccessibleEditableText() {
                return this.ac.getAccessibleEditableText();
            }

            public AccessibleValue getAccessibleValue() {
                return this.ac.getAccessibleValue();
            }

            public AccessibleIcon[] getAccessibleIcon() {
                return this.ac.getAccessibleIcon();
            }

            public AccessibleRelationSet getAccessibleRelationSet() {
                return this.ac.getAccessibleRelationSet();
            }

            public AccessibleTable getAccessibleTable() {
                return this.ac.getAccessibleTable();
            }

            public void firePropertyChange(String string, Object object, Object object2) {
                this.ac.firePropertyChange(string, object, object2);
            }
        }

        private class AccessibleEditor
        implements Accessible {
            private AccessibleEditor() {
            }

            public AccessibleContext getAccessibleContext() {
                Component component;
                if (AccessibleJComboBox.this.editorAccessibleContext == null && (component = JComboBox.this.getEditor().getEditorComponent()) instanceof Accessible) {
                    AccessibleJComboBox.this.editorAccessibleContext = new EditorAccessibleContext((Accessible)((Object)component));
                }
                return AccessibleJComboBox.this.editorAccessibleContext;
            }
        }
    }

    class DefaultKeySelectionManager
    implements KeySelectionManager,
    Serializable {
        DefaultKeySelectionManager() {
        }

        public int selectionForKey(char c2, ComboBoxModel comboBoxModel) {
            String string;
            Object object;
            int n2;
            int n3;
            int n4 = -1;
            Object object2 = comboBoxModel.getSelectedItem();
            if (object2 != null) {
                n3 = 0;
                n2 = comboBoxModel.getSize();
                while (n3 < n2) {
                    if (object2 == comboBoxModel.getElementAt(n3)) {
                        n4 = n3;
                        break;
                    }
                    ++n3;
                }
            }
            String string2 = ("" + c2).toLowerCase();
            c2 = string2.charAt(0);
            n3 = ++n4;
            n2 = comboBoxModel.getSize();
            while (n3 < n2) {
                object = comboBoxModel.getElementAt(n3);
                if (object != null && object.toString() != null && (string = object.toString().toLowerCase()).length() > 0 && string.charAt(0) == c2) {
                    return n3;
                }
                ++n3;
            }
            n3 = 0;
            while (n3 < n4) {
                object = comboBoxModel.getElementAt(n3);
                if (object != null && object.toString() != null && (string = object.toString().toLowerCase()).length() > 0 && string.charAt(0) == c2) {
                    return n3;
                }
                ++n3;
            }
            return -1;
        }
    }

    public static interface KeySelectionManager {
        public int selectionForKey(char var1, ComboBoxModel var2);
    }
}

