/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.math.BigInteger;
import java.text.AttributedCharacterIterator;
import java.text.CharacterIteratorFieldDelegate;
import java.text.DecimalFormatSymbols;
import java.text.DigitList;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Currency;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;
import sun.text.resources.LocaleData;

public class DecimalFormat
extends NumberFormat {
    private static final int STATUS_INFINITE = 0;
    private static final int STATUS_POSITIVE = 1;
    private static final int STATUS_LENGTH = 2;
    private transient DigitList digitList = new DigitList();
    private String positivePrefix = "";
    private String positiveSuffix = "";
    private String negativePrefix = "-";
    private String negativeSuffix = "";
    private String posPrefixPattern;
    private String posSuffixPattern;
    private String negPrefixPattern;
    private String negSuffixPattern;
    private int multiplier = 1;
    private byte groupingSize = (byte)3;
    private boolean decimalSeparatorAlwaysShown = false;
    private transient boolean isCurrencyFormat = false;
    private DecimalFormatSymbols symbols = null;
    private boolean useExponentialNotation;
    private transient FieldPosition[] positivePrefixFieldPositions;
    private transient FieldPosition[] positiveSuffixFieldPositions;
    private transient FieldPosition[] negativePrefixFieldPositions;
    private transient FieldPosition[] negativeSuffixFieldPositions;
    private byte minExponentDigits;
    static final int currentSerialVersion = 2;
    private int serialVersionOnStream = 2;
    private static final char PATTERN_ZERO_DIGIT = '0';
    private static final char PATTERN_GROUPING_SEPARATOR = ',';
    private static final char PATTERN_DECIMAL_SEPARATOR = '.';
    private static final char PATTERN_PER_MILLE = '\u2030';
    private static final char PATTERN_PERCENT = '%';
    private static final char PATTERN_DIGIT = '#';
    private static final char PATTERN_SEPARATOR = ';';
    private static final char PATTERN_EXPONENT = 'E';
    private static final char PATTERN_MINUS = '-';
    private static final char CURRENCY_SIGN = '\u00a4';
    private static final char QUOTE = '\'';
    private static FieldPosition[] EmptyFieldPositionArray = new FieldPosition[0];
    static final int DOUBLE_INTEGER_DIGITS = 309;
    static final int DOUBLE_FRACTION_DIGITS = 340;
    static final long serialVersionUID = 864413376551465018L;
    private static Hashtable cachedLocaleData = new Hashtable(3);

    public DecimalFormat() {
        Locale locale = Locale.getDefault();
        String string = (String)cachedLocaleData.get(locale);
        if (string == null) {
            ResourceBundle resourceBundle = LocaleData.getLocaleElements(locale);
            String[] stringArray = resourceBundle.getStringArray("NumberPatterns");
            string = stringArray[0];
            cachedLocaleData.put(locale, string);
        }
        this.symbols = new DecimalFormatSymbols(locale);
        this.applyPattern(string, false);
    }

    public DecimalFormat(String string) {
        this.symbols = new DecimalFormatSymbols(Locale.getDefault());
        this.applyPattern(string, false);
    }

    public DecimalFormat(String string, DecimalFormatSymbols decimalFormatSymbols) {
        this.symbols = (DecimalFormatSymbols)decimalFormatSymbols.clone();
        this.applyPattern(string, false);
    }

    public StringBuffer format(double d2, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        fieldPosition.setBeginIndex(0);
        fieldPosition.setEndIndex(0);
        return this.format(d2, stringBuffer, fieldPosition.getFieldDelegate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuffer format(double d2, StringBuffer stringBuffer, Format.FieldDelegate fieldDelegate) {
        boolean bl2;
        if (Double.isNaN(d2)) {
            int n2 = stringBuffer.length();
            stringBuffer.append(this.symbols.getNaN());
            fieldDelegate.formatted(0, NumberFormat.Field.INTEGER, NumberFormat.Field.INTEGER, n2, stringBuffer.length(), stringBuffer);
            return stringBuffer;
        }
        boolean bl3 = bl2 = d2 < 0.0 || d2 == 0.0 && 1.0 / d2 < 0.0;
        if (bl2) {
            d2 = -d2;
        }
        if (this.multiplier != 1) {
            d2 *= (double)this.multiplier;
        }
        if (Double.isInfinite(d2)) {
            if (bl2) {
                this.append(stringBuffer, this.negativePrefix, fieldDelegate, this.getNegativePrefixFieldPositions(), NumberFormat.Field.SIGN);
            } else {
                this.append(stringBuffer, this.positivePrefix, fieldDelegate, this.getPositivePrefixFieldPositions(), NumberFormat.Field.SIGN);
            }
            int n3 = stringBuffer.length();
            stringBuffer.append(this.symbols.getInfinity());
            fieldDelegate.formatted(0, NumberFormat.Field.INTEGER, NumberFormat.Field.INTEGER, n3, stringBuffer.length(), stringBuffer);
            if (bl2) {
                this.append(stringBuffer, this.negativeSuffix, fieldDelegate, this.getNegativeSuffixFieldPositions(), NumberFormat.Field.SIGN);
            } else {
                this.append(stringBuffer, this.positiveSuffix, fieldDelegate, this.getPositiveSuffixFieldPositions(), NumberFormat.Field.SIGN);
            }
            return stringBuffer;
        }
        DigitList digitList = this.digitList;
        synchronized (digitList) {
            this.digitList.set(d2, this.useExponentialNotation ? this.getMaximumIntegerDigits() + this.getMaximumFractionDigits() : this.getMaximumFractionDigits(), !this.useExponentialNotation);
            return this.subformat(stringBuffer, fieldDelegate, bl2, false);
        }
    }

    public StringBuffer format(long l2, StringBuffer stringBuffer, FieldPosition fieldPosition) {
        fieldPosition.setBeginIndex(0);
        fieldPosition.setEndIndex(0);
        return this.format(l2, stringBuffer, fieldPosition.getFieldDelegate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuffer format(long l2, StringBuffer stringBuffer, Format.FieldDelegate fieldDelegate) {
        boolean bl2;
        boolean bl3 = bl2 = l2 < 0L;
        if (bl2) {
            l2 = -l2;
        }
        if (this.multiplier != 1 && this.multiplier != 0) {
            long l3;
            boolean bl4 = false;
            if (l2 < 0L) {
                l3 = Long.MIN_VALUE / (long)this.multiplier;
                bl4 = l2 < l3;
            } else {
                l3 = Long.MAX_VALUE / (long)this.multiplier;
                boolean bl5 = bl4 = l2 > l3;
            }
            if (bl4) {
                double d2 = bl2 ? -l2 : l2;
                return this.format(d2, stringBuffer, fieldDelegate);
            }
        }
        l2 *= (long)this.multiplier;
        DigitList digitList = this.digitList;
        synchronized (digitList) {
            this.digitList.set(l2, this.useExponentialNotation ? this.getMaximumIntegerDigits() + this.getMaximumFractionDigits() : 0);
            return this.subformat(stringBuffer, fieldDelegate, bl2, true);
        }
    }

    public AttributedCharacterIterator formatToCharacterIterator(Object object) {
        CharacterIteratorFieldDelegate characterIteratorFieldDelegate = new CharacterIteratorFieldDelegate();
        StringBuffer stringBuffer = new StringBuffer();
        if (object instanceof Long || object instanceof BigInteger && ((BigInteger)object).bitLength() < 64) {
            this.format(((Number)object).longValue(), stringBuffer, (Format.FieldDelegate)characterIteratorFieldDelegate);
        } else {
            if (object == null) {
                throw new NullPointerException("formatToCharacterIterator must be passed non-null object");
            }
            if (object instanceof Number) {
                this.format(((Number)object).doubleValue(), stringBuffer, (Format.FieldDelegate)characterIteratorFieldDelegate);
            } else {
                throw new IllegalArgumentException("Cannot format given Object as a Number");
            }
        }
        return characterIteratorFieldDelegate.getIterator(stringBuffer.toString());
    }

    private StringBuffer subformat(StringBuffer stringBuffer, Format.FieldDelegate fieldDelegate, boolean bl2, boolean bl3) {
        char c2;
        char c3 = this.symbols.getZeroDigit();
        int n2 = c3 - 48;
        char c4 = this.symbols.getGroupingSeparator();
        char c5 = c2 = this.isCurrencyFormat ? this.symbols.getMonetaryDecimalSeparator() : this.symbols.getDecimalSeparator();
        if (this.digitList.isZero()) {
            this.digitList.decimalAt = 0;
        }
        int n3 = stringBuffer.length();
        if (bl2) {
            this.append(stringBuffer, this.negativePrefix, fieldDelegate, this.getNegativePrefixFieldPositions(), NumberFormat.Field.SIGN);
        } else {
            this.append(stringBuffer, this.positivePrefix, fieldDelegate, this.getPositivePrefixFieldPositions(), NumberFormat.Field.SIGN);
        }
        if (this.useExponentialNotation) {
            boolean bl4;
            int n4;
            int n5;
            int n6 = stringBuffer.length();
            int n7 = -1;
            int n8 = -1;
            int n9 = this.digitList.decimalAt;
            int n10 = this.getMaximumIntegerDigits();
            int n11 = this.getMinimumIntegerDigits();
            if (n10 > 1 && n10 > n11) {
                n9 = n9 >= 1 ? (n9 - 1) / n10 * n10 : (n9 - n10) / n10 * n10;
                n11 = 1;
            } else {
                n9 -= n11;
            }
            int n12 = this.getMinimumIntegerDigits() + this.getMinimumFractionDigits();
            int n13 = n5 = this.digitList.isZero() ? n11 : this.digitList.decimalAt - n9;
            if (n12 < n5) {
                n12 = n5;
            }
            if (n12 > (n4 = this.digitList.count)) {
                n4 = n12;
            }
            boolean bl5 = false;
            int n14 = 0;
            while (n14 < n4) {
                if (n14 == n5) {
                    n7 = stringBuffer.length();
                    stringBuffer.append(c2);
                    bl5 = true;
                    n8 = stringBuffer.length();
                }
                stringBuffer.append(n14 < this.digitList.count ? (char)(this.digitList.digits[n14] + n2) : c3);
                ++n14;
            }
            if (n7 == -1) {
                n7 = stringBuffer.length();
            }
            fieldDelegate.formatted(0, NumberFormat.Field.INTEGER, NumberFormat.Field.INTEGER, n6, n7, stringBuffer);
            if (bl5) {
                fieldDelegate.formatted(NumberFormat.Field.DECIMAL_SEPARATOR, NumberFormat.Field.DECIMAL_SEPARATOR, n7, n8, stringBuffer);
            }
            if (n8 == -1) {
                n8 = stringBuffer.length();
            }
            fieldDelegate.formatted(1, NumberFormat.Field.FRACTION, NumberFormat.Field.FRACTION, n8, stringBuffer.length(), stringBuffer);
            n3 = stringBuffer.length();
            stringBuffer.append(this.symbols.getExponentialSymbol());
            fieldDelegate.formatted(NumberFormat.Field.EXPONENT_SYMBOL, NumberFormat.Field.EXPONENT_SYMBOL, n3, stringBuffer.length(), stringBuffer);
            if (this.digitList.isZero()) {
                n9 = 0;
            }
            boolean bl6 = bl4 = n9 < 0;
            if (bl4) {
                n9 = -n9;
                this.append(stringBuffer, this.negativePrefix, fieldDelegate, this.getNegativePrefixFieldPositions(), NumberFormat.Field.EXPONENT_SIGN);
            } else {
                this.append(stringBuffer, this.positivePrefix, fieldDelegate, this.getPositivePrefixFieldPositions(), NumberFormat.Field.EXPONENT_SIGN);
            }
            this.digitList.set(n9);
            int n15 = stringBuffer.length();
            int n16 = this.digitList.decimalAt;
            while (n16 < this.minExponentDigits) {
                stringBuffer.append(c3);
                ++n16;
            }
            int n17 = 0;
            while (n17 < this.digitList.decimalAt) {
                stringBuffer.append(n17 < this.digitList.count ? (char)(this.digitList.digits[n17] + n2) : c3);
                ++n17;
            }
            fieldDelegate.formatted(NumberFormat.Field.EXPONENT, NumberFormat.Field.EXPONENT, n15, stringBuffer.length(), stringBuffer);
            n3 = stringBuffer.length();
            if (bl4) {
                this.append(stringBuffer, this.negativeSuffix, fieldDelegate, this.getNegativeSuffixFieldPositions(), NumberFormat.Field.EXPONENT_SIGN);
            } else {
                this.append(stringBuffer, this.positiveSuffix, fieldDelegate, this.getPositiveSuffixFieldPositions(), NumberFormat.Field.EXPONENT_SIGN);
            }
        } else {
            int n18;
            int n19 = stringBuffer.length();
            int n20 = this.getMinimumIntegerDigits();
            int n21 = 0;
            if (this.digitList.decimalAt > 0 && n20 < this.digitList.decimalAt) {
                n20 = this.digitList.decimalAt;
            }
            if (n20 > this.getMaximumIntegerDigits()) {
                n20 = this.getMaximumIntegerDigits();
                n21 = this.digitList.decimalAt - n20;
            }
            int n22 = stringBuffer.length();
            int n23 = n20 - 1;
            while (n23 >= 0) {
                if (n23 < this.digitList.decimalAt && n21 < this.digitList.count) {
                    stringBuffer.append((char)(this.digitList.digits[n21++] + n2));
                } else {
                    stringBuffer.append(c3);
                }
                if (this.isGroupingUsed() && n23 > 0 && this.groupingSize != 0 && n23 % this.groupingSize == 0) {
                    n18 = stringBuffer.length();
                    stringBuffer.append(c4);
                    fieldDelegate.formatted(NumberFormat.Field.GROUPING_SEPARATOR, NumberFormat.Field.GROUPING_SEPARATOR, n18, stringBuffer.length(), stringBuffer);
                }
                --n23;
            }
            int n24 = n18 = this.getMinimumFractionDigits() > 0 || !bl3 && n21 < this.digitList.count ? 1 : 0;
            if (n18 == 0 && stringBuffer.length() == n22) {
                stringBuffer.append(c3);
            }
            fieldDelegate.formatted(0, NumberFormat.Field.INTEGER, NumberFormat.Field.INTEGER, n19, stringBuffer.length(), stringBuffer);
            int n25 = stringBuffer.length();
            if (this.decimalSeparatorAlwaysShown || n18 != 0) {
                stringBuffer.append(c2);
            }
            if (n25 != stringBuffer.length()) {
                fieldDelegate.formatted(NumberFormat.Field.DECIMAL_SEPARATOR, NumberFormat.Field.DECIMAL_SEPARATOR, n25, stringBuffer.length(), stringBuffer);
            }
            int n26 = stringBuffer.length();
            int n27 = 0;
            while (n27 < this.getMaximumFractionDigits()) {
                if (n27 >= this.getMinimumFractionDigits() && (bl3 || n21 >= this.digitList.count)) break;
                if (-1 - n27 > this.digitList.decimalAt - 1) {
                    stringBuffer.append(c3);
                } else if (!bl3 && n21 < this.digitList.count) {
                    stringBuffer.append((char)(this.digitList.digits[n21++] + n2));
                } else {
                    stringBuffer.append(c3);
                }
                ++n27;
            }
            fieldDelegate.formatted(1, NumberFormat.Field.FRACTION, NumberFormat.Field.FRACTION, n26, stringBuffer.length(), stringBuffer);
        }
        if (bl2) {
            this.append(stringBuffer, this.negativeSuffix, fieldDelegate, this.getNegativeSuffixFieldPositions(), NumberFormat.Field.SIGN);
        } else {
            this.append(stringBuffer, this.positiveSuffix, fieldDelegate, this.getPositiveSuffixFieldPositions(), NumberFormat.Field.SIGN);
        }
        return stringBuffer;
    }

    private void append(StringBuffer stringBuffer, String string, Format.FieldDelegate fieldDelegate, FieldPosition[] fieldPositionArray, Format.Field field) {
        int n2 = stringBuffer.length();
        if (string.length() > 0) {
            stringBuffer.append(string);
            int n3 = 0;
            int n4 = fieldPositionArray.length;
            while (n3 < n4) {
                FieldPosition fieldPosition = fieldPositionArray[n3];
                Format.Field field2 = fieldPosition.getFieldAttribute();
                if (field2 == NumberFormat.Field.SIGN) {
                    field2 = field;
                }
                fieldDelegate.formatted(field2, field2, n2 + fieldPosition.getBeginIndex(), n2 + fieldPosition.getEndIndex(), stringBuffer);
                ++n3;
            }
        }
    }

    public Number parse(String string, ParsePosition parsePosition) {
        if (string.regionMatches(parsePosition.index, this.symbols.getNaN(), 0, this.symbols.getNaN().length())) {
            parsePosition.index += this.symbols.getNaN().length();
            return new Double(Double.NaN);
        }
        boolean[] blArray = new boolean[2];
        if (!this.subparse(string, parsePosition, this.digitList, false, blArray)) {
            return null;
        }
        double d2 = 0.0;
        long l2 = 0L;
        boolean bl2 = true;
        if (blArray[0]) {
            d2 = Double.POSITIVE_INFINITY;
        } else if (this.digitList.fitsIntoLong(blArray[1], this.isParseIntegerOnly())) {
            bl2 = false;
            l2 = this.digitList.getLong();
        } else {
            d2 = this.digitList.getDouble();
        }
        if (this.multiplier != 1) {
            if (bl2) {
                d2 /= (double)this.multiplier;
            } else if (l2 % (long)this.multiplier == 0L) {
                l2 /= (long)this.multiplier;
            } else {
                d2 = (double)l2 / (double)this.multiplier;
                if (d2 < 0.0) {
                    d2 = -d2;
                }
                bl2 = true;
            }
        }
        if (!blArray[1]) {
            d2 = -d2;
            if (l2 > 0L) {
                l2 = -l2;
            }
        }
        if (this.multiplier != 1 && bl2) {
            l2 = (long)d2;
            bl2 = d2 != (double)l2 || d2 == 0.0 && !blArray[1] && !this.isParseIntegerOnly();
        }
        return bl2 ? (Number)new Double(d2) : (Number)new Long(l2);
    }

    private final boolean subparse(String string, ParsePosition parsePosition, DigitList digitList, boolean bl2, boolean[] blArray) {
        int n2 = parsePosition.index;
        int n3 = parsePosition.index;
        boolean bl3 = string.regionMatches(n2, this.positivePrefix, 0, this.positivePrefix.length());
        boolean bl4 = string.regionMatches(n2, this.negativePrefix, 0, this.negativePrefix.length());
        if (bl3 && bl4) {
            if (this.positivePrefix.length() > this.negativePrefix.length()) {
                bl4 = false;
            } else if (this.positivePrefix.length() < this.negativePrefix.length()) {
                bl3 = false;
            }
        }
        if (bl3) {
            n2 += this.positivePrefix.length();
        } else if (bl4) {
            n2 += this.negativePrefix.length();
        } else {
            parsePosition.errorIndex = n2;
            return false;
        }
        blArray[0] = false;
        if (!bl2 && string.regionMatches(n2, this.symbols.getInfinity(), 0, this.symbols.getInfinity().length())) {
            n2 += this.symbols.getInfinity().length();
            blArray[0] = true;
        } else {
            digitList.count = 0;
            digitList.decimalAt = 0;
            char c2 = this.symbols.getZeroDigit();
            char c3 = this.isCurrencyFormat ? this.symbols.getMonetaryDecimalSeparator() : this.symbols.getDecimalSeparator();
            char c4 = this.symbols.getGroupingSeparator();
            char c5 = this.symbols.getExponentialSymbol();
            boolean bl5 = false;
            boolean bl6 = false;
            boolean bl7 = false;
            int n4 = 0;
            int n5 = 0;
            int n6 = -1;
            while (n2 < string.length()) {
                char c6 = string.charAt(n2);
                int n7 = c6 - c2;
                if (n7 < 0 || n7 > 9) {
                    n7 = Character.digit(c6, 10);
                }
                if (n7 == 0) {
                    n6 = -1;
                    bl7 = true;
                    if (digitList.count == 0) {
                        if (bl5) {
                            --digitList.decimalAt;
                        }
                    } else {
                        ++n5;
                        digitList.append((char)(n7 + 48));
                    }
                } else if (n7 > 0 && n7 <= 9) {
                    bl7 = true;
                    ++n5;
                    digitList.append((char)(n7 + 48));
                    n6 = -1;
                } else if (!bl2 && c6 == c3) {
                    if (this.isParseIntegerOnly() || bl5) break;
                    digitList.decimalAt = n5;
                    bl5 = true;
                } else if (!bl2 && c6 == c4 && this.isGroupingUsed()) {
                    if (bl5) break;
                    n6 = n2;
                } else {
                    boolean[] blArray2;
                    DigitList digitList2;
                    ParsePosition parsePosition2;
                    if (bl2 || c6 != c5 || bl6 || !this.subparse(string, parsePosition2 = new ParsePosition(n2 + 1), digitList2 = new DigitList(), true, blArray2 = new boolean[2]) || !digitList2.fitsIntoLong(blArray2[1], true)) break;
                    n2 = parsePosition2.index;
                    n4 = (int)digitList2.getLong();
                    if (!blArray2[1]) {
                        n4 = -n4;
                    }
                    bl6 = true;
                    break;
                }
                ++n2;
            }
            if (n6 != -1) {
                n2 = n6;
            }
            if (!bl5) {
                digitList.decimalAt = n5;
            }
            digitList.decimalAt += n4;
            if (!bl7 && n5 == 0) {
                parsePosition.index = n3;
                parsePosition.errorIndex = n3;
                return false;
            }
        }
        if (bl3) {
            bl3 = string.regionMatches(n2, this.positiveSuffix, 0, this.positiveSuffix.length());
        }
        if (bl4) {
            bl4 = string.regionMatches(n2, this.negativeSuffix, 0, this.negativeSuffix.length());
        }
        if (bl3 && bl4) {
            if (this.positiveSuffix.length() > this.negativeSuffix.length()) {
                bl4 = false;
            } else if (this.positiveSuffix.length() < this.negativeSuffix.length()) {
                bl3 = false;
            }
        }
        if (bl3 == bl4) {
            parsePosition.errorIndex = n2;
            return false;
        }
        parsePosition.index = n2 + (bl3 ? this.positiveSuffix.length() : this.negativeSuffix.length());
        blArray[1] = bl3;
        if (parsePosition.index == n3) {
            parsePosition.errorIndex = n2;
            return false;
        }
        return true;
    }

    public DecimalFormatSymbols getDecimalFormatSymbols() {
        try {
            return (DecimalFormatSymbols)this.symbols.clone();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void setDecimalFormatSymbols(DecimalFormatSymbols decimalFormatSymbols) {
        try {
            this.symbols = (DecimalFormatSymbols)decimalFormatSymbols.clone();
            this.expandAffixes();
        }
        catch (Exception exception) {}
    }

    public String getPositivePrefix() {
        return this.positivePrefix;
    }

    public void setPositivePrefix(String string) {
        this.positivePrefix = string;
        this.posPrefixPattern = null;
        this.positivePrefixFieldPositions = null;
    }

    private FieldPosition[] getPositivePrefixFieldPositions() {
        if (this.positivePrefixFieldPositions == null) {
            this.positivePrefixFieldPositions = this.posPrefixPattern != null ? this.expandAffix(this.posPrefixPattern) : EmptyFieldPositionArray;
        }
        return this.positivePrefixFieldPositions;
    }

    public String getNegativePrefix() {
        return this.negativePrefix;
    }

    public void setNegativePrefix(String string) {
        this.negativePrefix = string;
        this.negPrefixPattern = null;
    }

    private FieldPosition[] getNegativePrefixFieldPositions() {
        if (this.negativePrefixFieldPositions == null) {
            this.negativePrefixFieldPositions = this.negPrefixPattern != null ? this.expandAffix(this.negPrefixPattern) : EmptyFieldPositionArray;
        }
        return this.negativePrefixFieldPositions;
    }

    public String getPositiveSuffix() {
        return this.positiveSuffix;
    }

    public void setPositiveSuffix(String string) {
        this.positiveSuffix = string;
        this.posSuffixPattern = null;
    }

    private FieldPosition[] getPositiveSuffixFieldPositions() {
        if (this.positiveSuffixFieldPositions == null) {
            this.positiveSuffixFieldPositions = this.posSuffixPattern != null ? this.expandAffix(this.posSuffixPattern) : EmptyFieldPositionArray;
        }
        return this.positiveSuffixFieldPositions;
    }

    public String getNegativeSuffix() {
        return this.negativeSuffix;
    }

    public void setNegativeSuffix(String string) {
        this.negativeSuffix = string;
        this.negSuffixPattern = null;
    }

    private FieldPosition[] getNegativeSuffixFieldPositions() {
        if (this.negativeSuffixFieldPositions == null) {
            this.negativeSuffixFieldPositions = this.negSuffixPattern != null ? this.expandAffix(this.negSuffixPattern) : EmptyFieldPositionArray;
        }
        return this.negativeSuffixFieldPositions;
    }

    public int getMultiplier() {
        return this.multiplier;
    }

    public void setMultiplier(int n2) {
        this.multiplier = n2;
    }

    public int getGroupingSize() {
        return this.groupingSize;
    }

    public void setGroupingSize(int n2) {
        this.groupingSize = (byte)n2;
    }

    public boolean isDecimalSeparatorAlwaysShown() {
        return this.decimalSeparatorAlwaysShown;
    }

    public void setDecimalSeparatorAlwaysShown(boolean bl2) {
        this.decimalSeparatorAlwaysShown = bl2;
    }

    public Object clone() {
        try {
            DecimalFormat decimalFormat = (DecimalFormat)super.clone();
            decimalFormat.symbols = (DecimalFormatSymbols)this.symbols.clone();
            decimalFormat.digitList = (DigitList)this.digitList.clone();
            return decimalFormat;
        }
        catch (Exception exception) {
            throw new InternalError();
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        DecimalFormat decimalFormat = (DecimalFormat)object;
        return (this.posPrefixPattern == decimalFormat.posPrefixPattern && this.positivePrefix.equals(decimalFormat.positivePrefix) || this.posPrefixPattern != null && this.posPrefixPattern.equals(decimalFormat.posPrefixPattern)) && (this.posSuffixPattern == decimalFormat.posSuffixPattern && this.positiveSuffix.equals(decimalFormat.positiveSuffix) || this.posSuffixPattern != null && this.posSuffixPattern.equals(decimalFormat.posSuffixPattern)) && (this.negPrefixPattern == decimalFormat.negPrefixPattern && this.negativePrefix.equals(decimalFormat.negativePrefix) || this.negPrefixPattern != null && this.negPrefixPattern.equals(decimalFormat.negPrefixPattern)) && (this.negSuffixPattern == decimalFormat.negSuffixPattern && this.negativeSuffix.equals(decimalFormat.negativeSuffix) || this.negSuffixPattern != null && this.negSuffixPattern.equals(decimalFormat.negSuffixPattern)) && this.multiplier == decimalFormat.multiplier && this.groupingSize == decimalFormat.groupingSize && this.decimalSeparatorAlwaysShown == decimalFormat.decimalSeparatorAlwaysShown && this.useExponentialNotation == decimalFormat.useExponentialNotation && (!this.useExponentialNotation || this.minExponentDigits == decimalFormat.minExponentDigits) && this.symbols.equals(decimalFormat.symbols);
    }

    public int hashCode() {
        return super.hashCode() * 37 + this.positivePrefix.hashCode();
    }

    public String toPattern() {
        return this.toPattern(false);
    }

    public String toLocalizedPattern() {
        return this.toPattern(true);
    }

    private void expandAffixes() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.posPrefixPattern != null) {
            this.positivePrefix = this.expandAffix(this.posPrefixPattern, stringBuffer);
            this.positivePrefixFieldPositions = null;
        }
        if (this.posSuffixPattern != null) {
            this.positiveSuffix = this.expandAffix(this.posSuffixPattern, stringBuffer);
            this.positiveSuffixFieldPositions = null;
        }
        if (this.negPrefixPattern != null) {
            this.negativePrefix = this.expandAffix(this.negPrefixPattern, stringBuffer);
            this.negativePrefixFieldPositions = null;
        }
        if (this.negSuffixPattern != null) {
            this.negativeSuffix = this.expandAffix(this.negSuffixPattern, stringBuffer);
            this.negativeSuffixFieldPositions = null;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private String expandAffix(String string, StringBuffer stringBuffer) {
        stringBuffer.setLength(0);
        int n2 = 0;
        block6: while (n2 < string.length()) {
            char c2;
            if ((c2 = string.charAt(n2++)) == '\'') {
                c2 = string.charAt(n2++);
                switch (c2) {
                    case '\u00a4': {
                        if (n2 < string.length() && string.charAt(n2) == '\u00a4') {
                            ++n2;
                            stringBuffer.append(this.symbols.getInternationalCurrencySymbol());
                            continue block6;
                        }
                        stringBuffer.append(this.symbols.getCurrencySymbol());
                        continue block6;
                    }
                    case '%': {
                        c2 = this.symbols.getPercent();
                        break;
                    }
                    case '\u2030': {
                        c2 = this.symbols.getPerMill();
                        break;
                    }
                    case '-': {
                        c2 = this.symbols.getMinusSign();
                    }
                }
            }
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    private FieldPosition[] expandAffix(String string) {
        ArrayList arrayList = null;
        int n2 = 0;
        int n3 = 0;
        block6: while (n3 < string.length()) {
            char c2;
            if ((c2 = string.charAt(n3++)) == '\'') {
                FieldPosition fieldPosition;
                int n4 = -1;
                NumberFormat.Field field = null;
                c2 = string.charAt(n3++);
                switch (c2) {
                    case '\u00a4': {
                        String string2;
                        if (n3 < string.length() && string.charAt(n3) == '\u00a4') {
                            ++n3;
                            string2 = this.symbols.getInternationalCurrencySymbol();
                        } else {
                            string2 = this.symbols.getCurrencySymbol();
                        }
                        if (string2.length() <= 0) continue block6;
                        if (arrayList == null) {
                            arrayList = new ArrayList(2);
                        }
                        fieldPosition = new FieldPosition(NumberFormat.Field.CURRENCY);
                        fieldPosition.setBeginIndex(n2);
                        fieldPosition.setEndIndex(n2 + string2.length());
                        arrayList.add(fieldPosition);
                        n2 += string2.length();
                        continue block6;
                    }
                    case '%': {
                        c2 = this.symbols.getPercent();
                        n4 = -1;
                        field = NumberFormat.Field.PERCENT;
                        break;
                    }
                    case '\u2030': {
                        c2 = this.symbols.getPerMill();
                        n4 = -1;
                        field = NumberFormat.Field.PERMILLE;
                        break;
                    }
                    case '-': {
                        c2 = this.symbols.getMinusSign();
                        n4 = -1;
                        field = NumberFormat.Field.SIGN;
                    }
                }
                if (field != null) {
                    if (arrayList == null) {
                        arrayList = new ArrayList(2);
                    }
                    fieldPosition = new FieldPosition(field, n4);
                    fieldPosition.setBeginIndex(n2);
                    fieldPosition.setEndIndex(n2 + 1);
                    arrayList.add(fieldPosition);
                }
            }
            ++n2;
        }
        if (arrayList != null) {
            return (FieldPosition[])arrayList.toArray(EmptyFieldPositionArray);
        }
        return EmptyFieldPositionArray;
    }

    private void appendAffix(StringBuffer stringBuffer, String string, String string2, boolean bl2) {
        if (string == null) {
            this.appendAffix(stringBuffer, string2, bl2);
        } else {
            int n2 = 0;
            while (n2 < string.length()) {
                int n3 = string.indexOf(39, n2);
                if (n3 < 0) {
                    this.appendAffix(stringBuffer, string.substring(n2), bl2);
                    break;
                }
                if (n3 > n2) {
                    this.appendAffix(stringBuffer, string.substring(n2, n3), bl2);
                }
                char c2 = string.charAt(++n3);
                ++n3;
                if (c2 == '\'') {
                    stringBuffer.append(c2);
                } else if (c2 == '\u00a4' && n3 < string.length() && string.charAt(n3) == '\u00a4') {
                    stringBuffer.append(c2);
                } else if (bl2) {
                    switch (c2) {
                        case '%': {
                            c2 = this.symbols.getPercent();
                            break;
                        }
                        case '\u2030': {
                            c2 = this.symbols.getPerMill();
                            break;
                        }
                        case '-': {
                            c2 = this.symbols.getMinusSign();
                        }
                    }
                }
                stringBuffer.append(c2);
                n2 = ++n3;
            }
        }
    }

    private void appendAffix(StringBuffer stringBuffer, String string, boolean bl2) {
        boolean bl3;
        if (bl2) {
            bl3 = string.indexOf(this.symbols.getZeroDigit()) >= 0 || string.indexOf(this.symbols.getGroupingSeparator()) >= 0 || string.indexOf(this.symbols.getDecimalSeparator()) >= 0 || string.indexOf(this.symbols.getPercent()) >= 0 || string.indexOf(this.symbols.getPerMill()) >= 0 || string.indexOf(this.symbols.getDigit()) >= 0 || string.indexOf(this.symbols.getPatternSeparator()) >= 0 || string.indexOf(this.symbols.getMinusSign()) >= 0 || string.indexOf(164) >= 0;
        } else {
            boolean bl4 = bl3 = string.indexOf(48) >= 0 || string.indexOf(44) >= 0 || string.indexOf(46) >= 0 || string.indexOf(37) >= 0 || string.indexOf(8240) >= 0 || string.indexOf(35) >= 0 || string.indexOf(59) >= 0 || string.indexOf(45) >= 0 || string.indexOf(164) >= 0;
        }
        if (bl3) {
            stringBuffer.append('\'');
        }
        if (string.indexOf(39) < 0) {
            stringBuffer.append(string);
        } else {
            int n2 = 0;
            while (n2 < string.length()) {
                char c2 = string.charAt(n2);
                stringBuffer.append(c2);
                if (c2 == '\'') {
                    stringBuffer.append(c2);
                }
                ++n2;
            }
        }
        if (bl3) {
            stringBuffer.append('\'');
        }
    }

    private String toPattern(boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 1;
        while (n2 >= 0) {
            int n3;
            if (n2 == 1) {
                this.appendAffix(stringBuffer, this.posPrefixPattern, this.positivePrefix, bl2);
            } else {
                this.appendAffix(stringBuffer, this.negPrefixPattern, this.negativePrefix, bl2);
            }
            int n4 = n3 = this.useExponentialNotation ? this.getMaximumIntegerDigits() : Math.max(this.groupingSize, this.getMinimumIntegerDigits()) + 1;
            while (n4 > 0) {
                if (n4 != n3 && this.isGroupingUsed() && this.groupingSize != 0 && n4 % this.groupingSize == 0) {
                    stringBuffer.append(bl2 ? this.symbols.getGroupingSeparator() : (char)',');
                }
                stringBuffer.append(n4 <= this.getMinimumIntegerDigits() ? (bl2 ? this.symbols.getZeroDigit() : (char)'0') : (bl2 ? this.symbols.getDigit() : (char)'#'));
                --n4;
            }
            if (this.getMaximumFractionDigits() > 0 || this.decimalSeparatorAlwaysShown) {
                stringBuffer.append(bl2 ? this.symbols.getDecimalSeparator() : (char)'.');
            }
            n4 = 0;
            while (n4 < this.getMaximumFractionDigits()) {
                if (n4 < this.getMinimumFractionDigits()) {
                    stringBuffer.append(bl2 ? this.symbols.getZeroDigit() : (char)'0');
                } else {
                    stringBuffer.append(bl2 ? this.symbols.getDigit() : (char)'#');
                }
                ++n4;
            }
            if (this.useExponentialNotation) {
                stringBuffer.append(bl2 ? this.symbols.getExponentialSymbol() : (char)'E');
                n4 = 0;
                while (n4 < this.minExponentDigits) {
                    stringBuffer.append(bl2 ? this.symbols.getZeroDigit() : (char)'0');
                    ++n4;
                }
            }
            if (n2 == 1) {
                this.appendAffix(stringBuffer, this.posSuffixPattern, this.positiveSuffix, bl2);
                if ((this.negSuffixPattern == this.posSuffixPattern && this.negativeSuffix.equals(this.positiveSuffix) || this.negSuffixPattern != null && this.negSuffixPattern.equals(this.posSuffixPattern)) && (this.negPrefixPattern != null && this.posPrefixPattern != null && this.negPrefixPattern.equals("'-" + this.posPrefixPattern) || this.negPrefixPattern == this.posPrefixPattern && this.negativePrefix.equals(this.symbols.getMinusSign() + this.positivePrefix))) break;
                stringBuffer.append(bl2 ? this.symbols.getPatternSeparator() : (char)';');
            } else {
                this.appendAffix(stringBuffer, this.negSuffixPattern, this.negativeSuffix, bl2);
            }
            --n2;
        }
        return stringBuffer.toString();
    }

    public void applyPattern(String string) {
        this.applyPattern(string, false);
    }

    public void applyLocalizedPattern(String string) {
        this.applyPattern(string, true);
    }

    private void applyPattern(String string, boolean bl2) {
        char c2 = '0';
        char c3 = ',';
        char c4 = '.';
        char c5 = '%';
        char c6 = '\u2030';
        char c7 = '#';
        char c8 = ';';
        char c9 = 'E';
        char c10 = '-';
        if (bl2) {
            c2 = this.symbols.getZeroDigit();
            c3 = this.symbols.getGroupingSeparator();
            c4 = this.symbols.getDecimalSeparator();
            c5 = this.symbols.getPercent();
            c6 = this.symbols.getPerMill();
            c7 = this.symbols.getDigit();
            c8 = this.symbols.getPatternSeparator();
            c9 = this.symbols.getExponentialSymbol();
            c10 = this.symbols.getMinusSign();
        }
        boolean bl3 = false;
        this.decimalSeparatorAlwaysShown = false;
        this.isCurrencyFormat = false;
        this.useExponentialNotation = false;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 1;
        while (n5 >= 0 && n4 < string.length()) {
            char c11;
            char c12;
            boolean bl4 = false;
            StringBuffer stringBuffer = new StringBuffer();
            StringBuffer stringBuffer2 = new StringBuffer();
            char c13 = '\uffffffff';
            int n6 = 1;
            char c14 = '\u0000';
            int n7 = 0;
            int n8 = 0;
            int n9 = -1;
            int n10 = 0;
            StringBuffer stringBuffer3 = stringBuffer;
            int n11 = n4;
            while (n11 < string.length()) {
                c12 = string.charAt(n11);
                switch (n10) {
                    case 0: 
                    case 2: {
                        if (bl4) {
                            if (c12 == '\'') {
                                if (n11 + 1 < string.length() && string.charAt(n11 + 1) == '\'') {
                                    ++n11;
                                    stringBuffer3.append("''");
                                    break;
                                }
                                bl4 = false;
                                break;
                            }
                        } else {
                            if (c12 == c7 || c12 == c2 || c12 == c3 || c12 == c4) {
                                n10 = 1;
                                if (n5 == 1) {
                                    n2 = n11;
                                }
                                --n11;
                                break;
                            }
                            if (c12 == '\u00a4') {
                                char c15 = c11 = n11 + 1 < string.length() && string.charAt(n11 + 1) == '\u00a4' ? (char)'\u0001' : '\u0000';
                                if (c11 != '\u0000') {
                                    ++n11;
                                }
                                this.isCurrencyFormat = true;
                                stringBuffer3.append(c11 != '\u0000' ? "'\u00a4\u00a4" : "'\u00a4");
                                break;
                            }
                            if (c12 == '\'') {
                                if (c12 == '\'') {
                                    if (n11 + 1 < string.length() && string.charAt(n11 + 1) == '\'') {
                                        ++n11;
                                        stringBuffer3.append("''");
                                        break;
                                    }
                                    bl4 = true;
                                    break;
                                }
                            } else {
                                if (c12 == c8) {
                                    if (n10 == 0 || n5 == 0) {
                                        throw new IllegalArgumentException("Unquoted special character '" + c12 + "' in pattern \"" + string + '\"');
                                    }
                                    n4 = n11 + 1;
                                    n11 = string.length();
                                    break;
                                }
                                if (c12 == c5) {
                                    if (n6 != 1) {
                                        throw new IllegalArgumentException("Too many percent/permille characters in pattern \"" + string + '\"');
                                    }
                                    n6 = 100;
                                    stringBuffer3.append("'%");
                                    break;
                                }
                                if (c12 == c6) {
                                    if (n6 != 1) {
                                        throw new IllegalArgumentException("Too many percent/permille characters in pattern \"" + string + '\"');
                                    }
                                    n6 = 1000;
                                    stringBuffer3.append("'\u2030");
                                    break;
                                }
                                if (c12 == c10) {
                                    stringBuffer3.append("'-");
                                    break;
                                }
                            }
                        }
                        stringBuffer3.append(c12);
                        break;
                    }
                    case 1: {
                        if (n5 == 1) {
                            ++n3;
                        } else {
                            if (--n3 != 0) break;
                            n10 = 2;
                            stringBuffer3 = stringBuffer2;
                            break;
                        }
                        if (c12 == c7) {
                            if (n7 > 0) {
                                ++n8;
                            } else {
                                ++c14;
                            }
                            if (n9 < 0 || c13 >= '\u0000') break;
                            n9 = (byte)(n9 + 1);
                            break;
                        }
                        if (c12 == c2) {
                            if (n8 > 0) {
                                throw new IllegalArgumentException("Unexpected '0' in pattern \"" + string + '\"');
                            }
                            ++n7;
                            if (n9 < 0 || c13 >= '\u0000') break;
                            n9 = (byte)(n9 + 1);
                            break;
                        }
                        if (c12 == c3) {
                            n9 = 0;
                            break;
                        }
                        if (c12 == c4) {
                            if (c13 >= '\u0000') {
                                throw new IllegalArgumentException("Multiple decimal separators in pattern \"" + string + '\"');
                            }
                            c13 = c14 + n7 + n8;
                            break;
                        }
                        if (c12 == c9) {
                            if (this.useExponentialNotation) {
                                throw new IllegalArgumentException("Multiple exponential symbols in pattern \"" + string + '\"');
                            }
                            this.useExponentialNotation = true;
                            this.minExponentDigits = 0;
                            while (++n11 < string.length() && string.charAt(n11) == c2) {
                                this.minExponentDigits = (byte)(this.minExponentDigits + 1);
                                ++n3;
                            }
                            if (c14 + n7 < 1 || this.minExponentDigits < 1) {
                                throw new IllegalArgumentException("Malformed exponential pattern \"" + string + '\"');
                            }
                            n10 = 2;
                            stringBuffer3 = stringBuffer2;
                            --n11;
                            break;
                        }
                        n10 = 2;
                        stringBuffer3 = stringBuffer2;
                        --n11;
                        --n3;
                        break;
                    }
                }
                ++n11;
            }
            if (n7 == 0 && c14 > '\u0000' && c13 >= '\u0000') {
                c12 = c13;
                if (c12 == '\u0000') {
                    ++c12;
                }
                n8 = c14 - c12;
                c14 = c12 - '\u0001';
                n7 = 1;
            }
            if (c13 < '\u0000' && n8 > 0 || c13 >= '\u0000' && (c13 < c14 || c13 > c14 + n7) || n9 == 0 || bl4) {
                throw new IllegalArgumentException("Malformed pattern \"" + string + '\"');
            }
            if (n5 == 1) {
                this.posPrefixPattern = stringBuffer.toString();
                this.posSuffixPattern = stringBuffer2.toString();
                this.negPrefixPattern = this.posPrefixPattern;
                this.negSuffixPattern = this.posSuffixPattern;
                c12 = c14 + n7 + n8;
                c11 = c13 >= '\u0000' ? c13 : c12;
                this.setMinimumIntegerDigits(c11 - c14);
                this.setMaximumIntegerDigits(this.useExponentialNotation ? c14 + this.getMinimumIntegerDigits() : 309);
                this.setMaximumFractionDigits(c13 >= '\u0000' ? c12 - c13 : 0);
                this.setMinimumFractionDigits(c13 >= '\u0000' ? c14 + n7 - c13 : 0);
                this.setGroupingUsed(n9 > 0);
                this.groupingSize = (byte)(n9 > 0 ? n9 : 0);
                this.multiplier = n6;
                this.setDecimalSeparatorAlwaysShown(c13 == '\u0000' || c13 == c12);
            } else {
                this.negPrefixPattern = stringBuffer.toString();
                this.negSuffixPattern = stringBuffer2.toString();
                bl3 = true;
            }
            --n5;
        }
        if (string.length() == 0) {
            this.posSuffixPattern = "";
            this.posPrefixPattern = "";
            this.setMinimumIntegerDigits(0);
            this.setMaximumIntegerDigits(309);
            this.setMinimumFractionDigits(0);
            this.setMaximumFractionDigits(340);
        }
        if (!bl3 || this.negPrefixPattern.equals(this.posPrefixPattern) && this.negSuffixPattern.equals(this.posSuffixPattern)) {
            this.negSuffixPattern = this.posSuffixPattern;
            this.negPrefixPattern = "'-" + this.posPrefixPattern;
        }
        this.expandAffixes();
    }

    public void setMaximumIntegerDigits(int n2) {
        super.setMaximumIntegerDigits(Math.min(n2, 309));
    }

    public void setMinimumIntegerDigits(int n2) {
        super.setMinimumIntegerDigits(Math.min(n2, 309));
    }

    public void setMaximumFractionDigits(int n2) {
        super.setMaximumFractionDigits(Math.min(n2, 340));
    }

    public void setMinimumFractionDigits(int n2) {
        super.setMinimumFractionDigits(Math.min(n2, 340));
    }

    public Currency getCurrency() {
        return this.symbols.getCurrency();
    }

    public void setCurrency(Currency currency) {
        if (currency != this.symbols.getCurrency()) {
            this.symbols.setCurrency(currency);
            if (this.isCurrencyFormat) {
                this.expandAffixes();
            }
        }
    }

    void adjustForCurrencyDefaultFractionDigits() {
        int n2;
        Currency currency = this.symbols.getCurrency();
        if (currency == null) {
            try {
                currency = Currency.getInstance(this.symbols.getInternationalCurrencySymbol());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (currency != null && (n2 = currency.getDefaultFractionDigits()) != -1) {
            int n3 = this.getMinimumFractionDigits();
            if (n3 == this.getMaximumFractionDigits()) {
                this.setMinimumFractionDigits(n2);
                this.setMaximumFractionDigits(n2);
            } else {
                this.setMinimumFractionDigits(Math.min(n2, n3));
                this.setMaximumFractionDigits(n2);
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.getMaximumIntegerDigits() > 309 || this.getMaximumFractionDigits() > 340) {
            throw new InvalidObjectException("Digit count out of range");
        }
        if (this.serialVersionOnStream < 1) {
            this.useExponentialNotation = false;
        }
        this.serialVersionOnStream = 2;
        this.digitList = new DigitList();
    }
}

