/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.PipedReader;
import java.io.Writer;

public class PipedWriter
extends Writer {
    private PipedReader sink;
    private boolean closed = false;

    public PipedWriter(PipedReader pipedReader) throws IOException {
        this.connect(pipedReader);
    }

    public PipedWriter() {
    }

    public synchronized void connect(PipedReader pipedReader) throws IOException {
        if (pipedReader == null) {
            throw new NullPointerException();
        }
        if (this.sink != null || pipedReader.connected) {
            throw new IOException("Already connected");
        }
        if (pipedReader.closedByReader || this.closed) {
            throw new IOException("Pipe closed");
        }
        this.sink = pipedReader;
        pipedReader.in = -1;
        pipedReader.out = 0;
        pipedReader.connected = true;
    }

    public void write(int n2) throws IOException {
        if (this.sink == null) {
            throw new IOException("Pipe not connected");
        }
        this.sink.receive(n2);
    }

    public void write(char[] cArray, int n2, int n3) throws IOException {
        if (this.sink == null) {
            throw new IOException("Pipe not connected");
        }
        if ((n2 | n3 | n2 + n3 | cArray.length - (n2 + n3)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.sink.receive(cArray, n2, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void flush() throws IOException {
        if (this.sink != null) {
            if (this.sink.closedByReader || this.closed) {
                throw new IOException("Pipe closed");
            }
            PipedReader pipedReader = this.sink;
            synchronized (pipedReader) {
                this.sink.notifyAll();
            }
        }
    }

    public void close() throws IOException {
        this.closed = true;
        if (this.sink != null) {
            this.sink.receivedLast();
        }
    }
}

