/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.internal.Activation;

import com.sun.corba.se.ActivationIDL.Activator;
import com.sun.corba.se.ActivationIDL.ActivatorHelper;
import com.sun.corba.se.ActivationIDL.Locator;
import com.sun.corba.se.ActivationIDL.LocatorHelper;
import com.sun.corba.se.ActivationIDL.RepositoryPackage.ServerDef;
import com.sun.corba.se.internal.Activation.InitialNamingImpl;
import com.sun.corba.se.internal.Activation.NameServiceStartThread;
import com.sun.corba.se.internal.Activation.RepositoryImpl;
import com.sun.corba.se.internal.Activation.ServerManagerImpl;
import com.sun.corba.se.internal.CosNaming.BootstrapServer;
import com.sun.corba.se.internal.CosNaming.TransientNameService;
import com.sun.corba.se.internal.POA.POAORB;
import com.sun.corba.se.internal.core.ServerGIOP;
import com.sun.corba.se.internal.orbutil.CorbaResourceUtil;
import java.io.File;
import java.util.Properties;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;

public class ORBD {
    private int initSvcPort;
    protected File dbDir;
    private String dbDirName;
    protected InitialNamingImpl ins;
    protected Locator locator;
    protected Activator activator;
    protected RepositoryImpl repository;
    private static String[][] orbServers = new String[][]{{""}};

    protected InitialNamingImpl initializeBootNaming(POAORB pOAORB) {
        Properties properties = new Properties();
        String string = System.getProperty("file.separator");
        File file = new File(this.dbDir, string + "initial.db");
        this.initSvcPort = pOAORB.getORBInitialPort();
        BootstrapServer bootstrapServer = new BootstrapServer(pOAORB, this.initSvcPort, file, properties);
        bootstrapServer.start();
        InitialNamingImpl initialNamingImpl = new InitialNamingImpl(pOAORB, bootstrapServer);
        return initialNamingImpl;
    }

    protected POAORB createORB(String[] stringArray) {
        Properties properties = System.getProperties();
        properties.put("com.sun.CORBA.POA.ORBPersistentServerPort", properties.getProperty("com.sun.CORBA.activation.Port", Integer.toString(1049)));
        properties.put("org.omg.CORBA.ORBClass", "com.sun.corba.se.internal.Interceptors.PIORB");
        return (POAORB)ORB.init(stringArray, properties);
    }

    private void run(String[] stringArray) {
        try {
            java.lang.Object object;
            this.processArgs(stringArray);
            POAORB pOAORB = this.createORB(stringArray);
            if (pOAORB.orbdDebugFlag) {
                System.out.println("ORBD begins initialization.");
            }
            boolean bl2 = this.createSystemDirs("orb.db");
            this.startActivationObjects(pOAORB);
            if (bl2) {
                this.installOrbServers(this.getRepository(), this.getActivator());
            }
            if (pOAORB.orbdDebugFlag) {
                System.out.println("ORBD is ready.");
                System.out.println("ORBD serverid: " + System.getProperty("com.sun.CORBA.POA.ORBServerId"));
                System.out.println("activation dbdir: " + System.getProperty("com.sun.CORBA.activation.DbDir"));
                System.out.println("activation port: " + System.getProperty("com.sun.CORBA.activation.Port"));
                object = System.getProperty("com.sun.CORBA.activation.ServerPollingTime");
                if (object == null) {
                    object = Integer.toString(1000);
                }
                System.out.println("activation Server Polling Time: " + (String)object + " milli-seconds ");
                String string = System.getProperty("com.sun.CORBA.activation.ServerStartupDelay");
                if (string == null) {
                    string = Integer.toString(1000);
                }
                System.out.println("activation Server Startup Delay: " + string + " milli-seconds ");
            }
            object = new NameServiceStartThread(pOAORB, this.dbDir, this.ins);
            ((Thread)object).start();
            pOAORB.run();
        }
        catch (COMM_FAILURE cOMM_FAILURE) {
            System.out.println(CorbaResourceUtil.getText("orbd.commfailure"));
        }
        catch (INTERNAL iNTERNAL) {
            System.out.println(CorbaResourceUtil.getText("orbd.internalexception"));
        }
        catch (Exception exception) {
            System.out.println(CorbaResourceUtil.getText("orbd.usage", "orbd"));
            System.out.println(exception);
            exception.printStackTrace();
        }
    }

    private void processArgs(String[] stringArray) {
        Properties properties = System.getProperties();
        int n2 = 0;
        while (n2 < stringArray.length) {
            if (stringArray[n2].equals("-port")) {
                if (n2 + 1 < stringArray.length) {
                    properties.put("com.sun.CORBA.activation.Port", stringArray[++n2]);
                } else {
                    System.out.println(CorbaResourceUtil.getText("orbd.usage", "orbd"));
                }
            } else if (stringArray[n2].equals("-defaultdb")) {
                if (n2 + 1 < stringArray.length) {
                    properties.put("com.sun.CORBA.activation.DbDir", stringArray[++n2]);
                } else {
                    System.out.println(CorbaResourceUtil.getText("orbd.usage", "orbd"));
                }
            } else if (stringArray[n2].equals("-serverid")) {
                if (n2 + 1 < stringArray.length) {
                    properties.put("com.sun.CORBA.POA.ORBServerId", stringArray[++n2]);
                } else {
                    System.out.println(CorbaResourceUtil.getText("orbd.usage", "orbd"));
                }
            } else if (stringArray[n2].equals("-serverPollingTime")) {
                if (n2 + 1 < stringArray.length) {
                    properties.put("com.sun.CORBA.activation.ServerPollingTime", stringArray[++n2]);
                } else {
                    System.out.println(CorbaResourceUtil.getText("orbd.usage", "orbd"));
                }
            } else if (stringArray[n2].equals("-serverStartupDelay")) {
                if (n2 + 1 < stringArray.length) {
                    properties.put("com.sun.CORBA.activation.ServerStartupDelay", stringArray[++n2]);
                } else {
                    System.out.println(CorbaResourceUtil.getText("orbd.usage", "orbd"));
                }
            }
            ++n2;
        }
    }

    protected boolean createSystemDirs(String string) {
        File file;
        boolean bl2 = false;
        Properties properties = System.getProperties();
        String string2 = properties.getProperty("file.separator");
        this.dbDir = new File(properties.getProperty("com.sun.CORBA.activation.DbDir", properties.getProperty("user.dir") + string2 + string));
        this.dbDirName = this.dbDir.getAbsolutePath();
        properties.put("com.sun.CORBA.activation.DbDir", this.dbDirName);
        if (!this.dbDir.exists()) {
            this.dbDir.mkdir();
            bl2 = true;
        }
        if (!(file = new File(this.dbDir, "logs")).exists()) {
            file.mkdir();
        }
        return bl2;
    }

    protected File getDbDir() {
        return this.dbDir;
    }

    protected String getDbDirName() {
        return this.dbDirName;
    }

    protected void startActivationObjects(POAORB pOAORB) throws Exception {
        this.ins = this.initializeBootNaming(pOAORB);
        this.repository = new RepositoryImpl(pOAORB, this.dbDir, pOAORB.orbdDebugFlag);
        this.ins.bind("ServerRepository", this.repository, false);
        ServerGIOP serverGIOP = pOAORB.getServerGIOP();
        serverGIOP.initEndpoints();
        ServerManagerImpl serverManagerImpl = new ServerManagerImpl(pOAORB, serverGIOP, this.repository, this.getDbDirName(), pOAORB.orbdDebugFlag);
        this.locator = LocatorHelper.narrow(serverManagerImpl);
        this.ins.bind("ServerLocator", this.locator, false);
        this.activator = ActivatorHelper.narrow(serverManagerImpl);
        this.ins.bind("ServerActivator", this.activator, false);
        TransientNameService transientNameService = new TransientNameService(pOAORB, "TNameService");
        Object object = transientNameService.initialNamingContext();
        this.ins.bind("TNameService", object, false);
    }

    protected Locator getLocator() {
        return this.locator;
    }

    protected Activator getActivator() {
        return this.activator;
    }

    protected RepositoryImpl getRepository() {
        return this.repository;
    }

    protected void installOrbServers(RepositoryImpl repositoryImpl, Activator activator) {
        int n2 = 0;
        while (n2 < orbServers.length) {
            try {
                String[] stringArray = orbServers[n2];
                ServerDef serverDef = new ServerDef(stringArray[1], stringArray[2], stringArray[3], stringArray[4], stringArray[5]);
                int n3 = Integer.valueOf(orbServers[n2][0]);
                repositoryImpl.registerServer(serverDef, n3);
                activator.activate(n3);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
    }

    public static void main(String[] stringArray) {
        ORBD oRBD = new ORBD();
        oRBD.run(stringArray);
    }
}

