#!/usr/bin/perl

##
## Simple example of how to implement a '[add|delete] share command' for
## use with the Windows NT Server Manager. See smb.conf(5) for details
## on the '[add|delete] share command'
##
## Author : Gerald (Jerry) Carter <jerry@samba.org>
##

use POSIX qw(tmpnam);

##
## local variables
##
my $delete_mode = undef;
my $add_mode = undef;
my $tmp_file_name = undef;


## check for correct parameters
if ($#ARGV == 1) {
	$delete_mode = 1;
}
elsif ($#ARGV == 3) {
	$add_mode = 1;
}
else {
	print "Usage: $0 configfile share [path] [comment]\n"; 
	exit -1;
}

## first param is always the config file
open (CONFIGFILE, "$ARGV[0]") || die "Unable to open $ARGV[0] for reading!\n";

## FIXME!!  Right now we throw away all comments in the file.
while (<CONFIGFILE>) {

	chomp($_);
	
	## eat leading whitespace
	$_ =~ s/^\s*//;
	
	## eat trailing whitespace
	$_ =~ s/\s*$//;
	

	## throw away comments
	next if (($_ =~ /^#/) || ($_ =~ /^;/));

	## set the current section name for storing the hash
	if ($_ =~ /^\[.*\]$/) {
	
		$_ = substr($_, 1, length($_)-2);
		
		if ( length($_) ) {
			$section = $_;
		}
		else {
			print "Bad Section Name - no closing ]\n";
			exit -1;
		}

		next;
	}	
	
	## check for a param = value
	if ($_ =~ /=/) {
		($param, $value) = split (/=/, $_);
		$param =~ s/./\l$&/g;
		$param =~ s/\s+//g;
		$value =~ s/^\s+//;
		
		$config{$section}{$param} = $value;
		
		next;
	}

	## should have a hash of hashes indexed by section name
}
close (CONFIGFILE);

##
## We have the smb.conf in our hash of hashes now.
## Add or delete 
##
if ($add_mode) {
	$config{$ARGV[1]}{'path'} = $ARGV[2];
	$config{$ARGV[1]}{'comment'} = $ARGV[3];
}
elsif ($delete_mode) {
	delete $config{$ARGV[1]};
}

##
## Print the resulting configuration
##
#do {
#	$tmp_file_name = tmpnam();
#	print "Using temporary file - $tmp_file_name\n";
#} while (!sysopen(TMP, $tmp_file_name, O_RDWR|O_CREAT|O_EXCL));
$tmp_file_name = tmpnam();
open (TMP, ">$tmp_file_name") || die "Unable to open temporary file for writing!\n";

PrintConfigFile(TMP);

## now overwrite the original config file
close (TMP);
system ("cp -pf $ARGV[0] $ARGV[0].bak");
system ("cp -pf $tmp_file_name $ARGV[0]");
unlink $tmp_file_name; 


exit 0;





#######################################################################################
## PrintConfigFile()
##
sub PrintConfigFile {
	my ($output) = @_;

	## print the file back out, beginning with the global section
	print $output "#\n# Generated by $0\n#\n";

	PrintSection ($output, 'global', $config{'global'});

	foreach $section (keys %config) {

		if ("$section" ne "global") {
			print $output "## Section - [$section]\n";
			PrintSection ($output, $section, $config{$section});
		}
	}

	print $output "#\n# end of generated smb.conf\n#\n";
}

#######################################################################################
## PrintSection()
##
sub PrintSection {
	my ($outfile, $name, $section) = @_;

	print $outfile "[$name]\n";
	foreach $param (keys %$section) {
		print $outfile "\t$param".' 'x(25-length($param)). " = $$section{$param}\n";
	}
	print $outfile "\n";

}
