/*
    cwbugdetails.h  -  Details of a bug report
    
    copyright   : (c) 2001 by Martijn Klingens
    email       : klingens@kde.org

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#ifndef KBBMAINWINDOW_CWBUGDETAILS_H
#define KBBMAINWINDOW_CWBUGDETAILS_H

#include "bug.h"
#include "bugdetails.h"

#include "cwbugdetails_base.h"

#include <kparts/browserextension.h>

class KHTMLPart;

namespace KBugBusterMainWindow
{

/**
 * @author Martijn Klingens
 */
class CWBugDetails : public CWBugDetails_Base
{
    Q_OBJECT

public:
    CWBugDetails( QWidget* parent = 0, const char* name = 0 );
    ~CWBugDetails();

    void setBug( const Bug &, const BugDetails & );

private slots:
    void handleOpenURLRequest( const KURL &url, const KParts::URLArgs & );

private:
    QString textBugDetailsAttribute( const QString &value,
                                     const QString &name );

    KHTMLPart *m_bugDesc;
};
 
}   // namespace

#endif // KBBMAINWINDOW_CWBUGDETAILS_H

/* vim: set et ts=4 softtabstop=4 sw=4: */

