/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 1999-2001 by Matthias Kiefer
                            <matthias.kiefer@gmx.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

**************************************************************************** */
#ifndef PREFWIDGETS_H
#define PREFWIDGETS_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <ktabctl.h>
#include <qlist.h>
#include "settings.h"


class KLineEdit;
class QLineEdit;
class QCheckBox;
class QComboBox;
class QRadioButton;
class QSpinBox;
class CmdEdit;
class KFontChooser;
class KColorButton;
class KComboBox;
class KSpellConfig;
class KURLRequester;
class QPushButton;

struct ModuleInfo;

class SavePreferences : public QWidget
{
   Q_OBJECT
public:
   SavePreferences(QWidget* parent=0);
   void mergeSettings(SaveSettings& settings) const;
   void setSettings(const SaveSettings&);
   void defaults();

private:
   QCheckBox* _lastButton;
   QCheckBox* _revisionButton;
   QCheckBox* _languageButton;
   QCheckBox* _charsetButton;
   QCheckBox* _encodingButton;

   QCheckBox* _updateButton;
   QCheckBox* _autoCheckButton;

   QComboBox* _encodingBox;
   QCheckBox* _oldEncodingButton;

   QRadioButton* _defaultDateButton;
   QRadioButton* _localDateButton;
   QRadioButton* _customDateButton;
   QLineEdit* _dateFormatEdit;

private slots:
   void customDateActivated(bool on);
};


class IdentityPreferences : public QWidget
{
    Q_OBJECT
public:
    IdentityPreferences(QWidget *parent = 0);
    void mergeSettings(IdentitySettings& settings) const;
    void setSettings(const IdentitySettings&);
    void defaults();

    virtual bool eventFilter(QObject *, QEvent*);

private slots:
    void checkTestPluralButton();
    void testPluralForm();
    
private:
   QLineEdit* _nameEdit;
   QLineEdit* _mailEdit;
   QLineEdit* _langEdit;
   QLineEdit* _langCodeEdit;
   QLineEdit* _listEdit;

   QLineEdit* _timezoneEdit;
   QSpinBox *_pluralFormsBox;
   QPushButton *_testPluralButton;
};


class EditorPreferences : public KTabCtl
{
    Q_OBJECT
public:
    EditorPreferences(QWidget *parent = 0);
    void mergeSettings(EditorSettings& settings) const;
    void setSettings(const EditorSettings&);
    void defaults();

private slots:
    void showOnlyFixedFonts(bool);
    void ledWarning(bool show);

private:
    QCheckBox* _fuzzyButton;
    QCheckBox* _cleverEditButton;

    QCheckBox* _checkArgsButton;
    QCheckBox* _checkAccelButton;
    QCheckBox* _checkEquationButton;
    QCheckBox* _checkContextButton;
    QCheckBox* _checkPluralButton;

    QCheckBox* _beepButton;
    QCheckBox* _colorErrorButton;

    QCheckBox* _onlyFixedFontsButton;
    KFontChooser* _fontBox;

    QCheckBox* _quotesButton;
    QCheckBox* _spacePointsButton;
    QCheckBox* _hlBgButton;
    QCheckBox* _hlSyntaxButton;

    KColorButton* _bgColorButton;
    KColorButton* _quotedColorButton;
    KColorButton* _errorColorButton;
    KColorButton* _cformatColorButton;
    KColorButton* _accelColorButton;

    QRadioButton* _ledInStatusbarBtn;
    QRadioButton* _ledInEditorBtn;
    KColorButton* _ledColorButton;
};


class SearchPreferences : public QWidget
{
    Q_OBJECT
public:
    SearchPreferences(QPtrList<ModuleInfo> ml,QWidget *parent = 0);
    virtual ~SearchPreferences();
    void mergeSettings(SearchSettings& settings);
    void setSettings(const SearchSettings&);
    void defaults();

private:
    QCheckBox* _searchButton;
    KComboBox* _defaultModuleBox;

    QPtrList<ModuleInfo> moduleList;
};

class MiscPreferences : public QWidget
{
   Q_OBJECT
public:
   MiscPreferences(QWidget *parent=0);
   virtual ~MiscPreferences();

   void mergeSettings(MiscSettings& settings) const;
   void setSettings(const MiscSettings&);
   void defaults();

private slots:
   void regExpButtonClicked();
   
private:
   void setContextInfo(QString reg);
   QString contextInfo() const;
   
   KLineEdit *contextInfoEdit;
   KLineEdit *accelMarkerEdit;
   
   QDialog *_regExpEditDialog;
   QPushButton *_regExpButton;
};

class DiffPreferences : public QWidget
{
public: 
    DiffPreferences(QWidget *parent=0);
    
    void mergeSettings(EditorSettings& set) const;
    void setSettings(const EditorSettings&);
    void defaults();

private:
    KColorButton* _diffAddColorBtn;
    KColorButton* _diffDelColorBtn;
    KComboBox* _diffAddCombo;
    KComboBox* _diffDelCombo;
    KURLRequester* _diffBaseDirEdit;
    QCheckBox *_useDBBtn;
};


class SpellPreferences : public QWidget
{
public: 
    SpellPreferences(QWidget *parent=0);
    
    void mergeSettings(EditorSettings& set) const;
    void setSettings(const EditorSettings&);
    void defaults();

private:
    KSpellConfig* spellConfig;
    QCheckBox* remIgnoredBtn;
    KURLRequester* ignoreURLEdit;

};


#endif // PREFWIDGETS_H
