/* vi:set ts=8 sts=0 sw=8:
 * $Id: prjbar.c,v 1.15 2000/03/21 08:25:45 kahn Exp kahn $
 *
 * Copyright (C) 1998 Andy C. Kahn
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <stdarg.h>
#include <string.h>
#include "config.h"
#include "win.h"
#include "doc.h"
#include "project.h"
#include "prjbar.h"
#include "prefs.h"
#include "gnpintl.h"


#ifdef WANT_PROJECT

static const char *no_project = N_("Project: NONE / Files: NONE");

/*** global function definitions ***/
#if 0
/*
 * PUBLIC: prjbar_clear
 *
 * clears the text by using a space (" ").  apparently, Gtk has no provision
 * for clearing a label widget.
 */
void
prjbar_clear(gpointer data)
{
	win_t *w = (win_t *)data;

	prjbar_update(w);
} /* prjbar_clear */
#endif


/*** global function definitions ***/
/*
 * PUBLIC: prjbar_init
 *
 * initialize the message bar.  called from win_new().
 */
void
prjbar_init(win_t *w)
{
	GtkWidget *tmp;

	tmp = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(w->mainbox), tmp, FALSE, TRUE, 0);
	gtk_widget_show(tmp);
	w->prjbar = gtk_label_new( _(no_project));
	gtk_box_pack_start(GTK_BOX(w->mainbox), w->prjbar, FALSE, TRUE, 0);
	tmp = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(w->mainbox), tmp, FALSE, TRUE, 0);
	gtk_widget_show(tmp);

	/* set according to preferences */
	if (IS_SHOW_PRJBAR())
		gtk_widget_show(w->prjbar);
} /* prjbar_init */


/*
 * PUBLIC: prjbar_update
 *
 * sets the project status bar.
 */
void
prjbar_update(win_t *w)
{
	char *msg;
	doc_t *d = DOC_CURRENT(w);
	prj_t *prj = d->prj;

	if (prj) {
#ifdef GTK_HAVE_FEATURES_1_1_0
		msg = g_strdup_printf(_("Project: %s / Files: %d"),
						prj->name, prj->numfiles);
#else
		msg = g_new(char, strlen(prj->name) + 128);
		g_snprintf(msg, strlen(prj->name) + 128,
				_("Project: %s / Files: %d"),
				prj->name, prj->numfiles);
#endif
		gtk_label_set(GTK_LABEL(w->prjbar), msg);
		g_free(msg);
	} else
		gtk_label_set(GTK_LABEL(w->prjbar), _(no_project));
} /* prjbar_update */


/*
 * PUBLIC: prjbar_redraw
 *
 * redraws the prjbar for a specified window
 */
void
prjbar_redraw(void *data)
{
	win_t *w = (win_t *)data;

	if (IS_SHOW_PRJBAR())
		gtk_widget_show(w->prjbar);
	else
		gtk_widget_hide(w->prjbar);
} /* prjbar_redraw */


/*
 * PUBLIC: prjbar toggle
 *
 * toggles the prjbar on/off
 */
void
prjbar_toggle(GtkWidget *wgt, gpointer cbdata)
{
	win_t *w = (win_t *)cbdata;

	g_assert(w != NULL);
	if (IS_SHOW_PRJBAR()) {
		gtk_widget_hide(w->prjbar);
		CLEAR_SHOW_PRJBAR();
	} else {
		gtk_widget_show(w->prjbar);
		SET_SHOW_PRJBAR();
	}
} /* prjbar_toggle */


#endif	/* WANT_PROJECT */
/* the end */
