/* vi:set ts=8 sts=0 sw=8:
 * $Id: msgbox.h,v 1.5 1999/09/12 14:20:57 kahn Exp kahn $
 *
 * Copyright (C) 1998 Andy C. Kahn
 *
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 *
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifndef __MSGBOX_H__
#define __MSGBOX_H__

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#include "main.h"
#ifdef WANT_MSGBOX
#include <gtk/gtk.h>

extern void msgbox_init(void);
extern void msgbox_show(GtkWidget *, gpointer data);
extern void msgbox_close(void);

#else

#define msgbox_init()
#define msgbox_close()

#endif  /* #ifdef WANT_MSGBOX */

extern void msgbox_printf(const char *fmt, ...);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif	/* __MSGBOX_H__ */
