/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs;

import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import sun.nio.cs.HistoricallyNamedCharset;
import sun.nio.cs.ISO_8859_1;
import sun.nio.cs.ISO_8859_15;
import sun.nio.cs.MS1252;
import sun.nio.cs.StandardCharsets;
import sun.nio.cs.Surrogate;
import sun.nio.cs.US_ASCII;
import sun.nio.cs.UTF_16;
import sun.nio.cs.UTF_16BE;
import sun.nio.cs.UTF_8;
import sun.nio.cs.UnicodeDecoder;
import sun.nio.cs.UnicodeEncoder;

class UTF_16LE
extends Charset
implements HistoricallyNamedCharset {
    public UTF_16LE() {
        super("UTF-16LE", StandardCharsets.aliasesFor("UTF-16LE"));
    }

    public String historicalName() {
        return "UnicodeLittleUnmarked";
    }

    public boolean contains(Charset charset) {
        return charset instanceof US_ASCII || charset instanceof ISO_8859_1 || charset instanceof ISO_8859_15 || charset instanceof MS1252 || charset instanceof UTF_8 || charset instanceof UTF_16 || charset instanceof UTF_16BE || charset instanceof UTF_16LE;
    }

    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    private static class Encoder
    extends UnicodeEncoder {
        public Encoder(Charset charset) {
            super(charset, 1, false);
        }

        public boolean canEncode(char c2) {
            if (Surrogate.isHigh(c2) || Surrogate.isLow(c2)) {
                return false;
            }
            return c2 <= '\uffff';
        }
    }

    private static class Decoder
    extends UnicodeDecoder {
        public Decoder(Charset charset) {
            super(charset, 2);
        }
    }
}

