/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.AbstractMap;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public class LinkedHashMap
extends HashMap {
    private static final long serialVersionUID = 3801124242820219131L;
    transient LinkedHashEntry head;
    transient LinkedHashEntry tail;
    final boolean accessOrder;

    public LinkedHashMap() {
        this.accessOrder = false;
    }

    public LinkedHashMap(Map m) {
        super(m);
        this.accessOrder = false;
    }

    public LinkedHashMap(int initialCapacity) {
        super(initialCapacity);
        this.accessOrder = false;
    }

    public LinkedHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this.accessOrder = false;
    }

    public LinkedHashMap(int initialCapacity, float loadFactor, boolean accessOrder) {
        super(initialCapacity, loadFactor);
        this.accessOrder = accessOrder;
    }

    public void clear() {
        super.clear();
        this.head = null;
        this.tail = null;
    }

    public boolean containsValue(Object value) {
        LinkedHashEntry e = this.head;
        while (e != null) {
            if (AbstractMap.equals(value, e.value)) {
                return true;
            }
            e = e.succ;
        }
        return false;
    }

    public Object get(Object key) {
        int idx = this.hash(key);
        HashMap.HashEntry e = this.buckets[idx];
        while (e != null) {
            if (AbstractMap.equals(key, e.key)) {
                if (this.accessOrder) {
                    ++this.modCount;
                    LinkedHashEntry l = (LinkedHashEntry)e;
                    if (l.succ != null) {
                        l.succ.pred = l.pred;
                        if (l.pred == null) {
                            this.head = l.succ;
                        } else {
                            l.pred.succ = l.succ;
                        }
                        l.succ = null;
                        l.pred = this.tail;
                        this.tail.succ = l;
                        this.tail = l;
                    }
                }
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    protected boolean removeEldestEntry(Map.Entry eldest) {
        return false;
    }

    void addEntry(Object key, Object value, int idx, boolean callRemove) {
        LinkedHashEntry e = new LinkedHashEntry(this, key, value);
        e.next = this.buckets[idx];
        this.buckets[idx] = e;
        if (callRemove && this.removeEldestEntry(this.head)) {
            this.remove(this.head);
        }
    }

    void putAllInternal(Map m) {
        this.head = null;
        this.tail = null;
        super.putAllInternal(m);
    }

    Iterator iterator(int type) {
        return new Iterator(this, type){
            private /* synthetic */ LinkedHashMap this$0;
            private /* synthetic */ int val$type;
            LinkedHashEntry current;
            LinkedHashEntry last;
            int knownMod;
            {
                this.this$0 = this$0;
                this.finit$(parm$type);
            }

            private /* synthetic */ void finit$(int parm$type) {
                this.val$type = parm$type;
                this.current = this.this$0.head;
                this.knownMod = this.this$0.modCount;
            }

            public boolean hasNext() {
                if (this.knownMod != this.this$0.modCount) {
                    throw new ConcurrentModificationException();
                }
                return this.current != null;
            }

            public Object next() {
                if (this.knownMod != this.this$0.modCount) {
                    throw new ConcurrentModificationException();
                }
                if (this.current == null) {
                    throw new NoSuchElementException();
                }
                this.last = this.current;
                this.current = this.current.succ;
                if (this.val$type == 1) {
                    return this.last.value;
                }
                if (this.val$type == 0) {
                    return this.last.key;
                }
                return this.last;
            }

            public void remove() {
                if (this.knownMod != this.this$0.modCount) {
                    throw new ConcurrentModificationException();
                }
                if (this.last == null) {
                    throw new IllegalStateException();
                }
                this.this$0.remove(this.last.key);
                this.last = null;
                ++this.knownMod;
            }
        };
    }

    class LinkedHashEntry
    extends HashMap.HashEntry {
        private /* synthetic */ LinkedHashMap this$0;
        LinkedHashEntry pred;
        LinkedHashEntry succ;

        LinkedHashEntry(LinkedHashMap this$0, Object key, Object value) {
            this.this$0 = this$0;
            super(key, value);
            if (this$0.head == null) {
                this$0.head = this;
            }
            this.pred = this$0.tail;
            this$0.tail = this;
            if (this.pred != null) {
                this.pred.succ = this;
            }
        }

        public Object setValue(Object value) {
            if (this.this$0.accessOrder && this.succ != null) {
                this.succ.pred = this.pred;
                if (this.pred == null) {
                    this.this$0.head = this.succ;
                } else {
                    this.pred.succ = this.succ;
                }
                this.succ = null;
                this.pred = this.this$0.tail;
                this.pred.succ = this;
                this.this$0.tail = this;
            }
            return super.setValue(value);
        }

        Object cleanup() {
            if (this.pred == null) {
                this.this$0.head = this.succ;
            } else {
                this.pred.succ = this.succ;
            }
            if (this.succ == null) {
                this.this$0.tail = this.pred;
            } else {
                this.succ.pred = this.pred;
            }
            return this.value;
        }
    }
}

