/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.RandomAccessSubList;
import java.util.SubList;

public abstract class AbstractList
extends AbstractCollection
implements List {
    protected int modCount;

    protected AbstractList() {
    }

    public abstract Object get(int var1);

    public void add(int index, Object o) {
        throw new UnsupportedOperationException();
    }

    public boolean add(Object o) {
        this.add(this.size(), o);
        return true;
    }

    public boolean addAll(int index, Collection c) {
        int size;
        Iterator itr = c.iterator();
        for (int pos = size = c.size(); pos > 0; --pos) {
            this.add(index++, itr.next());
        }
        return size > 0;
    }

    public void clear() {
        this.removeRange(0, this.size());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof List)) {
            return false;
        }
        int size = this.size();
        if (size != ((List)o).size()) {
            return false;
        }
        Iterator itr1 = this.iterator();
        Iterator itr2 = ((List)o).iterator();
        while (--size >= 0) {
            if (AbstractCollection.equals(itr1.next(), itr2.next())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        Iterator itr = this.iterator();
        int pos = this.size();
        while (--pos >= 0) {
            hashCode = 31 * hashCode + AbstractCollection.hashCode(itr.next());
        }
        return hashCode;
    }

    public int indexOf(Object o) {
        ListIterator itr = this.listIterator();
        int size = this.size();
        for (int pos = 0; pos < size; ++pos) {
            if (!AbstractCollection.equals(o, itr.next())) continue;
            return pos;
        }
        return -1;
    }

    public Iterator iterator() {
        return new Iterator(this){
            private /* synthetic */ AbstractList this$0;
            private int pos;
            private int size;
            private int last;
            private int knownMod;
            {
                this.this$0 = this$0;
                this.finit$();
            }

            private /* synthetic */ void finit$() {
                this.pos = 0;
                this.size = this.this$0.size();
                this.last = -1;
                this.knownMod = this.this$0.modCount;
            }

            private void checkMod() {
                if (this.knownMod != this.this$0.modCount) {
                    throw new ConcurrentModificationException();
                }
            }

            public boolean hasNext() {
                this.checkMod();
                return this.pos < this.size;
            }

            public Object next() {
                this.checkMod();
                if (this.pos == this.size) {
                    throw new NoSuchElementException();
                }
                this.last = this.pos;
                return this.this$0.get(this.pos++);
            }

            public void remove() {
                this.checkMod();
                if (this.last < 0) {
                    throw new IllegalStateException();
                }
                this.this$0.remove(this.last);
                --this.pos;
                --this.size;
                this.last = -1;
                this.knownMod = this.this$0.modCount;
            }
        };
    }

    public int lastIndexOf(Object o) {
        int pos = this.size();
        ListIterator itr = this.listIterator(pos);
        while (--pos >= 0) {
            if (!AbstractCollection.equals(o, itr.previous())) continue;
            return pos;
        }
        return -1;
    }

    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    public ListIterator listIterator(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size:" + this.size());
        }
        return new ListIterator(this, index){
            private /* synthetic */ AbstractList this$0;
            private /* synthetic */ int val$index;
            private int knownMod;
            private int position;
            private int lastReturned;
            private int size;
            {
                this.this$0 = this$0;
                this.finit$(parm$index);
            }

            private /* synthetic */ void finit$(int parm$index) {
                this.val$index = parm$index;
                this.knownMod = this.this$0.modCount;
                this.position = this.val$index;
                this.lastReturned = -1;
                this.size = this.this$0.size();
            }

            private void checkMod() {
                if (this.knownMod != this.this$0.modCount) {
                    throw new ConcurrentModificationException();
                }
            }

            public boolean hasNext() {
                this.checkMod();
                return this.position < this.size;
            }

            public boolean hasPrevious() {
                this.checkMod();
                return this.position > 0;
            }

            public Object next() {
                this.checkMod();
                if (this.position == this.size) {
                    throw new NoSuchElementException();
                }
                this.lastReturned = this.position;
                return this.this$0.get(this.position++);
            }

            public Object previous() {
                this.checkMod();
                if (this.position == 0) {
                    throw new NoSuchElementException();
                }
                this.lastReturned = --this.position;
                return this.this$0.get(this.lastReturned);
            }

            public int nextIndex() {
                this.checkMod();
                return this.position;
            }

            public int previousIndex() {
                this.checkMod();
                return this.position - 1;
            }

            public void remove() {
                this.checkMod();
                if (this.lastReturned < 0) {
                    throw new IllegalStateException();
                }
                this.this$0.remove(this.lastReturned);
                --this.size;
                this.position = this.lastReturned;
                this.lastReturned = -1;
                this.knownMod = this.this$0.modCount;
            }

            public void set(Object o) {
                this.checkMod();
                if (this.lastReturned < 0) {
                    throw new IllegalStateException();
                }
                this.this$0.set(this.lastReturned, o);
            }

            public void add(Object o) {
                this.checkMod();
                this.this$0.add(this.position++, o);
                ++this.size;
                this.lastReturned = -1;
                this.knownMod = this.this$0.modCount;
            }
        };
    }

    public Object remove(int index) {
        throw new UnsupportedOperationException();
    }

    protected void removeRange(int fromIndex, int toIndex) {
        ListIterator itr = this.listIterator(fromIndex);
        for (int index = fromIndex; index < toIndex; ++index) {
            itr.next();
            itr.remove();
        }
    }

    public Object set(int index, Object o) {
        throw new UnsupportedOperationException();
    }

    public List subList(int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException(fromIndex + " > " + toIndex);
        }
        if (fromIndex < 0 || toIndex > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (this instanceof RandomAccess) {
            return new RandomAccessSubList(this, fromIndex, toIndex);
        }
        return new SubList(this, fromIndex, toIndex);
    }
}

