/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;

public class ProtectionDomain {
    private static final String linesep = System.getProperty("line.separator");
    private CodeSource code_source;
    private PermissionCollection perms;

    public ProtectionDomain(CodeSource code_source, PermissionCollection perms) {
        this.code_source = code_source;
        this.perms = perms;
        if (perms != null) {
            perms.setReadOnly();
        }
    }

    public final CodeSource getCodeSource() {
        return this.code_source;
    }

    public final PermissionCollection getPermissions() {
        return this.perms;
    }

    public boolean implies(Permission perm) {
        PermissionCollection pc = this.getPermissions();
        if (pc == null) {
            return false;
        }
        return pc.implies(perm);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("");
        sb.append(super.toString() + " (" + linesep);
        sb.append(this.code_source.toString());
        sb.append(this.perms.toString());
        sb.append(")" + linesep);
        return sb.toString();
    }
}

