/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.Serializable;
import java.security.AllPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;

public final class Permissions
extends PermissionCollection
implements Serializable {
    private PermissionCollection allPermission;
    Hashtable perms;

    private /* synthetic */ void finit$() {
        this.perms = new Hashtable();
    }

    public Permissions() {
        this.finit$();
    }

    public void add(Permission perm) throws SecurityException, IllegalArgumentException {
        if (this.isReadOnly()) {
            throw new SecurityException("PermissionCollection is read only");
        }
        if (perm instanceof AllPermission) {
            if (this.allPermission == null) {
                this.allPermission = new DefaultPermissionCollection("java.security.AllPermission");
                this.perms.put("java.security.AllPermission", this.allPermission);
            }
        } else {
            Object obj = this.perms.get(perm.getClass().getName());
            if (obj != null) {
                if (!(obj instanceof PermissionCollection)) {
                    throw new RuntimeException("Internal error in Permissions");
                }
                ((PermissionCollection)obj).add(perm);
            } else {
                PermissionCollection pc = perm.newPermissionCollection();
                if (pc == null) {
                    pc = new DefaultPermissionCollection(perm.getClass().getName());
                }
                pc.add(perm);
                this.perms.put(perm.getClass().getName(), pc);
            }
        }
    }

    public boolean implies(Permission perm) {
        if (this.allPermission != null) {
            return true;
        }
        Object obj = this.perms.get(perm.getClass().getName());
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PermissionCollection)) {
            return false;
        }
        return ((PermissionCollection)obj).implies(perm);
    }

    public Enumeration elements() {
        return new Enumeration(this){
            private /* synthetic */ Permissions this$0;
            Enumeration main_enum;
            Enumeration sub_enum;
            {
                this.this$0 = this$0;
                this.finit$();
            }

            private /* synthetic */ void finit$() {
                this.main_enum = this.this$0.perms.elements();
            }

            public boolean hasMoreElements() {
                if (this.sub_enum == null) {
                    if (this.main_enum == null) {
                        return false;
                    }
                    if (!this.main_enum.hasMoreElements()) {
                        return false;
                    }
                    try {
                        PermissionCollection pc = (PermissionCollection)this.main_enum.nextElement();
                        this.sub_enum = pc.elements();
                    }
                    catch (NoSuchElementException e) {
                        return false;
                    }
                } else if (!this.sub_enum.hasMoreElements()) {
                    this.sub_enum = null;
                    return this.hasMoreElements();
                }
                return true;
            }

            public Object nextElement() throws NoSuchElementException {
                if (!this.hasMoreElements()) {
                    throw new NoSuchElementException();
                }
                return this.sub_enum.nextElement();
            }
        };
    }

    static class DefaultPermissionCollection
    extends PermissionCollection
    implements Serializable {
        private Class permcls;
        private Hashtable perms;

        private /* synthetic */ void finit$() {
            this.perms = new Hashtable();
        }

        DefaultPermissionCollection(String permtype) throws IllegalArgumentException {
            this.finit$();
            try {
                this.permcls = Class.forName(permtype);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
        }

        public void add(Permission perm) throws SecurityException, IllegalArgumentException {
            if (this.isReadOnly()) {
                throw new SecurityException("PermissionCollection is read only");
            }
            if (!this.permcls.isInstance(perm)) {
                throw new IllegalArgumentException("Wrong permission type: " + perm.getClass().getName());
            }
            if (this.perms.get(perm.getName()) != null) {
                throw new IllegalArgumentException("Duplicate permission: " + perm.getName());
            }
            this.perms.put(perm.getName(), perm);
        }

        public boolean implies(Permission perm) {
            Object obj = this.perms.get(perm.getName());
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Permission)) {
                return false;
            }
            Permission p = (Permission)obj;
            return p.implies(perm);
        }

        public Enumeration elements() {
            return this.perms.elements();
        }
    }
}

