/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public class AlgorithmParameters {
    private AlgorithmParametersSpi paramSpi;
    private Provider provider;
    private String algorithm;

    protected AlgorithmParameters(AlgorithmParametersSpi paramSpi, Provider provider, String algorithm) {
        this.paramSpi = paramSpi;
        this.provider = provider;
        this.algorithm = algorithm;
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public static AlgorithmParameters getInstance(String algorithm) throws NoSuchAlgorithmException {
        Provider[] p = Security.getProviders();
        for (int i = 0; i < p.length; ++i) {
            String classname = p[i].getProperty("AlgorithmParameters." + algorithm);
            if (classname == null) continue;
            return AlgorithmParameters.getInstance(classname, algorithm, p[i]);
        }
        throw new NoSuchAlgorithmException(algorithm);
    }

    public static AlgorithmParameters getInstance(String algorithm, String provider) throws NoSuchAlgorithmException, NoSuchProviderException {
        Provider p = Security.getProvider(provider);
        if (p == null) {
            throw new NoSuchProviderException();
        }
        return AlgorithmParameters.getInstance(p.getProperty("AlgorithmParameters." + algorithm), algorithm, p);
    }

    private static AlgorithmParameters getInstance(String classname, String algorithm, Provider provider) throws NoSuchAlgorithmException {
        try {
            return new AlgorithmParameters((AlgorithmParametersSpi)Class.forName(classname).newInstance(), provider, algorithm);
        }
        catch (ClassNotFoundException cnfe) {
            throw new NoSuchAlgorithmException("Class not found");
        }
        catch (InstantiationException ie) {
            throw new NoSuchAlgorithmException("Class instantiation failed");
        }
        catch (IllegalAccessException iae) {
            throw new NoSuchAlgorithmException("Illegal Access");
        }
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final void init(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
        this.paramSpi.engineInit(paramSpec);
    }

    public final void init(byte[] params) throws IOException {
        this.paramSpi.engineInit(params);
    }

    public final void init(byte[] params, String format) throws IOException {
        this.paramSpi.engineInit(params, format);
    }

    public final AlgorithmParameterSpec getParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
        return this.paramSpi.engineGetParameterSpec(paramSpec);
    }

    public final byte[] getEncoded() throws IOException {
        return this.paramSpi.engineGetEncoded();
    }

    public final byte[] getEncoded(String format) throws IOException {
        return this.paramSpi.engineGetEncoded(format);
    }

    public final String toString() {
        return this.paramSpi.engineToString();
    }
}

