/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.UnsupportedEncodingException;

public class URLEncoder {
    public static String encode(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException uee) {
            return s;
        }
    }

    public static String encode(String s, String encoding) throws UnsupportedEncodingException {
        StringBuffer result = new StringBuffer();
        int length = s.length();
        int start = 0;
        int i = 0;
        while (true) {
            if (i < length && URLEncoder.isSafe(s.charAt(i))) {
                ++i;
                continue;
            }
            result.append(s.substring(start, i));
            if (i >= length) {
                return result.toString();
            }
            if (s.charAt(i) == ' ') {
                result.append('+');
            } else {
                char c;
                start = i;
                while (i < length && (c = s.charAt(i)) != ' ' && !URLEncoder.isSafe(c)) {
                    ++i;
                }
                String unsafe = s.substring(start, i);
                byte[] bytes = unsafe.getBytes(encoding);
                for (int j = 0; j < bytes.length; ++j) {
                    result.append('%');
                    result.append(Integer.toHexString(bytes[j] & 0xFF));
                }
            }
            start = ++i;
        }
    }

    private static boolean isSafe(char c) {
        return c > '`' && c <= 'z' || c > '@' && c <= 'Z' || c > '/' && c <= '9' || c == '-' || c == '_' || c == '.' || c == '*';
    }

    private URLEncoder() {
    }
}

