/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.Enumeration;
import java.util.Vector;

public class URLClassLoader
extends ClassLoader {
    URLStreamHandlerFactory factory;
    private Vector path;
    private Vector info;

    private /* synthetic */ void finit$() {
        this.factory = null;
    }

    private URLStreamHandler getHandler0(String protocol) {
        if (this.factory != null) {
            return this.factory.createURLStreamHandler(protocol);
        }
        return null;
    }

    public URLClassLoader(URL[] urls) {
        this(urls, null, null);
    }

    public URLClassLoader(URL[] urls, ClassLoader parent) {
        this(urls, parent, null);
    }

    private URL jarFileize(URL url) {
        String f;
        if (!url.getProtocol().equals("jar") && (f = url.getFile()).charAt(f.length() - 1) != '/') {
            try {
                url = new URL("jar", "", -1, url.toExternalForm() + "!/", this.getHandler0("jar"));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return url;
    }

    protected void addURL(URL url) {
        JarURLConnection conn = null;
        url = this.jarFileize(url);
        this.path.addElement(url);
        if (url.getProtocol().equals("jar")) {
            try {
                conn = (JarURLConnection)url.openConnection();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.info.addElement(conn);
    }

    public URLClassLoader(URL[] urls, ClassLoader parent, URLStreamHandlerFactory fac) {
        super(parent);
        this.finit$();
        this.factory = fac;
        if (urls == null || urls.length == 0) {
            this.path = new Vector(1);
            this.info = new Vector(1);
            return;
        }
        this.path = new Vector(urls.length);
        this.info = new Vector(urls.length);
        for (int i = 0; i < urls.length; ++i) {
            URL u = this.jarFileize(urls[i]);
            this.path.addElement(u);
            if (u.getProtocol().equals("jar")) {
                JarURLConnection conn = null;
                try {
                    conn = (JarURLConnection)u.openConnection();
                }
                catch (IOException x) {
                    // empty catch block
                }
                this.info.addElement(conn);
                continue;
            }
            this.info.addElement(null);
        }
    }

    public URL[] getURLs() {
        Object[] urls = new URL[this.path.size()];
        this.path.copyInto(urls);
        return urls;
    }

    public Enumeration findResources(String name) {
        Vector results = new Vector();
        for (int i = 0; i < this.path.size(); ++i) {
            URL u = (URL)this.path.elementAt(i);
            try {
                JarURLConnection conn = (JarURLConnection)this.info.elementAt(i);
                if (conn != null) {
                    if (conn.getJarFile().getJarEntry(name) == null) continue;
                    results.addElement(new URL(u, name, this.getHandler0(u.getProtocol())));
                    continue;
                }
                URL p = new URL(u, name, this.getHandler0(u.getProtocol()));
                InputStream is = p.openStream();
                if (is == null) continue;
                is.close();
                results.addElement(p);
                continue;
            }
            catch (IOException x) {
                // empty catch block
            }
        }
        return results.elements();
    }

    public URL findResource(String name) {
        for (int i = 0; i < this.path.size(); ++i) {
            URL u = (URL)this.path.elementAt(i);
            try {
                JarURLConnection conn = (JarURLConnection)this.info.elementAt(i);
                if (conn != null) {
                    if (conn.getJarFile().getJarEntry(name) == null) continue;
                    return new URL(u, name, this.getHandler0(u.getProtocol()));
                }
                URL p = new URL(u, name, this.getHandler0(u.getProtocol()));
                InputStream is = p.openStream();
                if (is == null) continue;
                is.close();
                return p;
            }
            catch (IOException x) {
                // empty catch block
            }
        }
        return null;
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        if (name == null) {
            throw new ClassNotFoundException("null");
        }
        try {
            URL u = this.getResource(name.replace('.', '/') + ".class");
            if (u == null) {
                throw new ClassNotFoundException(name);
            }
            URLConnection connection = u.openConnection();
            InputStream is = connection.getInputStream();
            int len = connection.getContentLength();
            byte[] data = new byte[len];
            int left = len;
            int off = 0;
            while (left > 0) {
                int c = is.read(data, off, len - off);
                if (c == -1 || c == 0) {
                    throw new InternalError("premature end of file");
                }
                left -= c;
                off += c;
            }
            return this.defineClass(name, data, 0, len);
        }
        catch (IOException x) {
            throw new ClassNotFoundException(name);
        }
    }
}

