/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.net.URL;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class Package {
    private final String name;
    private final String implTitle;
    private final String implVendor;
    private final String implVersion;
    private final String specTitle;
    private final String specVendor;
    private final String specVersion;
    private final URL sealed;

    Package(String name, String specTitle, String specVendor, String specVersion, String implTitle, String implVendor, String implVersion, URL sealed) {
        if (name == null) {
            throw new IllegalArgumentException("null Package name");
        }
        this.name = name;
        this.implTitle = implTitle;
        this.implVendor = implVendor;
        this.implVersion = implVersion;
        this.specTitle = specTitle;
        this.specVendor = specVendor;
        this.specVersion = specVersion;
        this.sealed = sealed;
    }

    public String getName() {
        return this.name;
    }

    public String getImplementationTitle() {
        return this.implTitle;
    }

    public String getImplementationVendor() {
        return this.implVendor;
    }

    public String getImplementationVersion() {
        return this.implVersion;
    }

    public String getSpecificationTitle() {
        return this.specTitle;
    }

    public String getSpecificationVendor() {
        return this.specVendor;
    }

    public String getSpecificationVersion() {
        return this.specVersion;
    }

    public boolean isSealed() {
        return this.sealed != null;
    }

    public boolean isSealed(URL url) {
        return url.equals(this.sealed);
    }

    public boolean isCompatibleWith(String version) throws NumberFormatException {
        StringTokenizer versionTokens = new StringTokenizer(version, ".");
        StringTokenizer specTokens = new StringTokenizer(this.specVersion, ".");
        try {
            while (versionTokens.hasMoreElements()) {
                int vers = Integer.parseInt(versionTokens.nextToken());
                int spec = Integer.parseInt(specTokens.nextToken());
                if (spec < vers) {
                    return false;
                }
                if (spec <= vers) continue;
                return true;
            }
        }
        catch (NoSuchElementException e) {
            return false;
        }
        return true;
    }

    public static Package getPackage(String name) {
        SecurityManager sm = System.getSecurityManager();
        Class c = sm.getClassContext()[1];
        ClassLoader cl = c.getClassLoader();
        if (cl != null) {
            return cl.getPackage(name);
        }
        return null;
    }

    public static Package[] getPackages() {
        SecurityManager sm = System.getSecurityManager();
        Class c = sm.getClassContext()[1];
        ClassLoader cl = c.getClassLoader();
        if (cl != null) {
            return cl.getPackages();
        }
        return new Package[0];
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return "package: " + this.name + " spec: " + this.specTitle + " version: " + this.specVersion + " vendor: " + this.specVendor + " implementation: " + this.implTitle + " version: " + this.implVersion + " vendor: " + this.implVendor + " sealed: " + this.sealed;
    }
}

