/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Double
extends Number
implements Comparable {
    public static final double MIN_VALUE = 4.9E-324;
    public static final double MAX_VALUE = 1.7976931348623157E308;
    public static final double NEGATIVE_INFINITY = -1.0 / 0.0;
    public static final double POSITIVE_INFINITY = 1.0 / 0.0;
    public static final double NaN = 0.0 / 0.0;
    public static final Class TYPE = VMClassLoader.getPrimitiveClass('D');
    private final double value;
    private static final long serialVersionUID = -9172774392245257468L;

    public Double(double value) {
        this.value = value;
    }

    public Double(String s) throws NumberFormatException {
        this.value = Double.parseDouble(s);
    }

    public String toString() {
        return Double.toString(this.value);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Double)) {
            return false;
        }
        double d = ((Double)obj).value;
        return Double.doubleToLongBits(this.value) == Double.doubleToLongBits(d);
    }

    public int hashCode() {
        long v = Double.doubleToLongBits(this.value);
        return (int)v ^ (int)(v >>> 32);
    }

    public int intValue() {
        return (int)this.value;
    }

    public long longValue() {
        return (long)this.value;
    }

    public float floatValue() {
        return (float)this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public static Double valueOf(String s) throws NumberFormatException {
        return new Double(s);
    }

    public boolean isNaN() {
        return Double.isNaN(this.value);
    }

    public static boolean isNaN(double v) {
        return v != v;
    }

    public boolean isInfinite() {
        return Double.isInfinite(this.value);
    }

    public static boolean isInfinite(double v) {
        return v == Double.POSITIVE_INFINITY || v == Double.NEGATIVE_INFINITY;
    }

    public int compareTo(Double d) {
        return Double.compare(this.value, d.value);
    }

    public static int compare(double x, double y) {
        if (Double.isNaN(x)) {
            if (Double.isNaN(y)) {
                return 0;
            }
            return 1;
        }
        if (Double.isNaN(y)) {
            return -1;
        }
        if (x == 0.0 && y == 0.0) {
            return (int)(1.0 / x - 1.0 / y);
        }
        if (x == y) {
            return 0;
        }
        if (x > y) {
            return 1;
        }
        return -1;
    }

    public int compareTo(Object o) {
        return this.compareTo((Double)o);
    }

    public static String toString(double d) {
        return Double.toString(d, false);
    }

    static native String toString(double var0, boolean var2);

    public static native long doubleToLongBits(double var0);

    public static native long doubleToRawLongBits(double var0);

    public static native double longBitsToDouble(long var0);

    public static native double parseDouble(String var0) throws NumberFormatException;

    private static native void initIDs();
}

