/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public abstract class RectangularShape
implements Shape,
Cloneable {
    protected RectangularShape() {
    }

    public abstract double getX();

    public abstract double getY();

    public abstract double getWidth();

    public abstract double getHeight();

    public double getMinX() {
        return Math.min(this.getX(), this.getX() + this.getWidth());
    }

    public double getMinY() {
        return Math.min(this.getY(), this.getY() + this.getHeight());
    }

    public double getMaxX() {
        return Math.max(this.getX(), this.getX() + this.getWidth());
    }

    public double getMaxY() {
        return Math.max(this.getY(), this.getY() + this.getHeight());
    }

    public double getCenterX() {
        return this.getX() + this.getWidth() / 2.0;
    }

    public double getCenterY() {
        return this.getY() + this.getHeight() / 2.0;
    }

    public Rectangle2D getFrame() {
        return new Rectangle2D.Double(this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    public abstract boolean isEmpty();

    public abstract void setFrame(double var1, double var3, double var5, double var7);

    public void setFrame(Point2D loc, Dimension2D size) {
        this.setFrame(loc.getX(), loc.getY(), size.getWidth(), size.getHeight());
    }

    public void setFrame(Rectangle2D r) {
        this.setFrame(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public void setFrameFromDiagonal(double x1, double y1, double x2, double y2) {
        double t;
        if (x1 > x2) {
            t = x2;
            x2 = x1;
            x1 = t;
        }
        if (y1 > y2) {
            t = y2;
            y2 = y1;
            y1 = t;
        }
        this.setFrame(x1, y1, x2 - x1, y2 - y1);
    }

    public void setFrameFromDiagonal(Point2D p1, Point2D p2) {
        this.setFrameFromDiagonal(p1.getX(), p1.getY(), p2.getX(), p2.getY());
    }

    public void setFrameFromCenter(double centerX, double centerY, double cornerX, double cornerY) {
        double halfw = Math.abs(cornerX - centerX);
        double halfh = Math.abs(cornerY - centerY);
        this.setFrame(centerX - halfw, centerY - halfh, 2.0 * halfw, 2.0 * halfh);
    }

    public void setFrameFromCenter(Point2D center, Point2D corner) {
        this.setFrameFromCenter(center.getX(), center.getY(), corner.getX(), corner.getY());
    }

    public boolean contains(Point2D p) {
        double x = p.getX();
        double y = p.getY();
        double rx = this.getX();
        double ry = this.getY();
        double w = this.getWidth();
        double h = this.getHeight();
        return x >= rx && x < rx + w && y >= ry && y < ry + h;
    }

    public boolean intersects(Rectangle2D r) {
        double x = this.getX();
        double w = this.getWidth();
        double mx = r.getX();
        double mw = r.getWidth();
        if (x < mx || x >= mx + mw || x + w < mx || x + w >= mx + mw) {
            return false;
        }
        double y = this.getY();
        double h = this.getHeight();
        double my = r.getY();
        double mh = r.getHeight();
        return y >= my && y < my + mh && y + h >= my && y + h < my + mh;
    }

    private boolean containsPoint(double x, double y) {
        double mx = this.getX();
        double mw = this.getWidth();
        if (x < mx || x >= mx + mw) {
            return false;
        }
        double my = this.getY();
        double mh = this.getHeight();
        return y >= my && y < my + mh;
    }

    public boolean contains(Rectangle2D r) {
        return this.containsPoint(r.getMinX(), r.getMinY()) && this.containsPoint(r.getMaxX(), r.getMaxY());
    }

    public Rectangle getBounds() {
        return new Rectangle((int)this.getX(), (int)this.getY(), (int)this.getWidth(), (int)this.getHeight());
    }

    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return new AffineTransform.Iterator(at, new Iterator(this));
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException _) {
            return null;
        }
    }

    class Iterator
    implements PathIterator {
        private /* synthetic */ RectangularShape this$0;
        private int coord = 0;
        private static final int START = 0;
        private static final int END_PLUS_ONE = 5;

        public Iterator(RectangularShape this$0) {
            this.this$0 = this$0;
        }

        public int currentSegment(double[] coords) {
            int r;
            switch (this.coord) {
                case 0: {
                    coords[0] = this.this$0.getX();
                    coords[1] = this.this$0.getY();
                    r = 0;
                    break;
                }
                case 1: {
                    coords[0] = this.this$0.getX() + this.this$0.getWidth();
                    coords[1] = this.this$0.getY();
                    r = 1;
                    break;
                }
                case 2: {
                    coords[0] = this.this$0.getX() + this.this$0.getWidth();
                    coords[1] = this.this$0.getY() + this.this$0.getHeight();
                    r = 1;
                    break;
                }
                case 3: {
                    coords[0] = this.this$0.getX();
                    coords[1] = this.this$0.getY() + this.this$0.getHeight();
                    r = 1;
                    break;
                }
                case 4: {
                    r = 4;
                    break;
                }
                default: {
                    r = 4;
                }
            }
            return r;
        }

        public int currentSegment(float[] coords) {
            int r;
            switch (this.coord) {
                case 0: {
                    coords[0] = (float)this.this$0.getX();
                    coords[1] = (float)this.this$0.getY();
                    r = 0;
                    break;
                }
                case 1: {
                    coords[0] = (float)(this.this$0.getX() + this.this$0.getWidth());
                    coords[1] = (float)this.this$0.getY();
                    r = 1;
                    break;
                }
                case 2: {
                    coords[0] = (float)(this.this$0.getX() + this.this$0.getWidth());
                    coords[1] = (float)(this.this$0.getY() + this.this$0.getHeight());
                    r = 1;
                    break;
                }
                case 3: {
                    coords[0] = (float)this.this$0.getX();
                    coords[1] = (float)(this.this$0.getY() + this.this$0.getHeight());
                    r = 1;
                    break;
                }
                default: {
                    r = 4;
                }
            }
            return r;
        }

        public int getWindingRule() {
            return 1;
        }

        public boolean isDone() {
            return this.coord == 5;
        }

        public void next() {
            if (this.coord < 5) {
                ++this.coord;
            }
        }
    }
}

