/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public class Rectangle
extends Rectangle2D
implements Cloneable,
Shape,
Serializable {
    public int x;
    public int y;
    public int width;
    public int height;

    public Rectangle() {
        this.x = 0;
        this.y = 0;
        this.width = 0;
        this.height = 0;
    }

    public Rectangle(Rectangle r) {
        this.x = r.x;
        this.y = r.y;
        this.width = r.width;
        this.height = r.height;
    }

    public Rectangle(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public Rectangle(int width, int height) {
        this.x = 0;
        this.y = 0;
        this.width = width;
        this.height = height;
    }

    public Rectangle(Point p, Dimension d) {
        this.x = p.x;
        this.y = p.y;
        this.width = d.width;
        this.height = d.height;
    }

    public Rectangle(Point p) {
        this.x = p.x;
        this.y = p.y;
        this.width = 0;
        this.height = 0;
    }

    public Rectangle(Dimension d) {
        this.x = 0;
        this.y = 0;
        this.width = d.width;
        this.height = d.height;
    }

    public Rectangle getBounds() {
        return (Rectangle)this.clone();
    }

    public void add(int newx, int newy) {
        int x = this.x > newx ? newx : this.x;
        int y = this.y > newy ? newy : this.y;
        this.width = (this.x + this.width > newx ? this.x + this.width : newx) - x;
        this.height = (this.y + this.height > newy ? this.y + this.height : newy) - y;
        this.x = x;
        this.y = y;
    }

    public void add(Point pt) {
        this.add(pt.x, pt.y);
    }

    public void add(Rectangle r) {
        int x = this.x > r.x ? r.x : this.x;
        int y = this.y > r.y ? r.y : this.y;
        this.width = (this.x + this.width > r.x + r.width ? this.x + this.width : r.x + r.width) - x;
        this.height = (this.y + this.height > r.y + r.height ? this.y + this.height : r.y + r.height) - y;
        this.x = x;
        this.y = y;
    }

    public boolean contains(int x, int y) {
        return x >= this.x && x <= this.x + this.width && y >= this.y && y <= this.y + this.height;
    }

    public boolean contains(int x, int y, int w, int h) {
        return x >= this.x && x + w <= this.x + this.width && y >= this.y && y + h <= this.y + this.height;
    }

    public boolean contains(Point p) {
        return this.contains(p.x, p.y);
    }

    public boolean contains(Rectangle r) {
        return this.contains(r.x, r.y, r.width, r.height);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Rectangle) {
            Rectangle r = (Rectangle)obj;
            return r.x == this.x && r.y == this.y && r.width == this.width && r.height == this.height;
        }
        return false;
    }

    public double getHeight() {
        return this.height;
    }

    public Point getLocation() {
        return new Point(this.x, this.y);
    }

    public Dimension getSize() {
        return new Dimension(this.width, this.height);
    }

    public double getWidth() {
        return this.width;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public void grow(int h, int v) {
        this.width += h;
        this.height += v;
    }

    public boolean inside(int x, int y) {
        return this.contains(x, y);
    }

    public Rectangle intersection(Rectangle r) {
        int newx = this.x < r.x ? r.x : this.x;
        int newy = this.y < r.y ? r.y : this.y;
        int neww = (this.x + this.width < r.x + r.width ? this.x + this.width : r.x + r.width) - newx;
        int newh = (this.y + this.height < r.y + r.height ? this.y + this.height : r.y + r.height) - newy;
        if (neww >= 0 && newh >= 0) {
            return new Rectangle(newx, newy, neww, newh);
        }
        return new Rectangle(0, 0, 0, 0);
    }

    public boolean intersects(Rectangle r) {
        int neww = (this.x + this.width < r.x + r.width ? this.x + this.width : r.x + r.width) - (this.x < r.x ? r.x : this.x);
        int newh = (this.y + this.height < r.y + r.height ? this.y + this.height : r.y + r.height) - (this.y < r.y ? r.y : this.y);
        return neww > 0 && newh > 0;
    }

    public boolean isEmpty() {
        return this.width <= 0 || this.height <= 0;
    }

    public void move(int x, int y) {
        this.setLocation(x, y);
    }

    public int outcode(double x, double y) {
        return 0;
    }

    public void reshape(int x, int y, int width, int height) {
        this.setBounds(x, y, width, height);
    }

    public void resize(int width, int height) {
        this.setSize(width, height);
    }

    public void setBounds(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public void setBounds(Rectangle r) {
        this.x = r.x;
        this.y = r.y;
        this.width = r.width;
        this.height = r.height;
    }

    public void setLocation(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void setLocation(Point p) {
        this.x = p.x;
        this.y = p.y;
    }

    public void setRect(double x, double y, double width, double height) {
        this.x = (int)x;
        this.y = (int)y;
        this.width = (int)width;
        this.height = (int)height;
    }

    public void setSize(Dimension d) {
        this.width = d.width;
        this.height = d.height;
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public void translate(int x, int y) {
        x += x;
        y += y;
    }

    public Rectangle union(Rectangle r) {
        int newx = this.x > r.x ? r.x : this.x;
        int newy = this.y > r.y ? r.y : this.y;
        int neww = (this.x + this.width > r.x + r.width ? this.x + this.width : r.x + r.width) - newx;
        int newh = (this.y + this.height > r.y + r.height ? this.y + this.height : r.y + r.height) - newy;
        return new Rectangle(newx, newy, neww, newh);
    }

    public Rectangle2D createIntersection(Rectangle2D r) {
        Rectangle2D.Double res = new Rectangle2D.Double();
        Rectangle2D.intersect(this, r, res);
        return res;
    }

    public Rectangle2D createUnion(Rectangle2D r) {
        Rectangle2D.Double res = new Rectangle2D.Double();
        Rectangle2D.union(this, r, res);
        return res;
    }

    public Rectangle2D getBounds2D() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public String toString() {
        return this.getClass().getName() + "[x=" + this.x + ",y=" + this.y + ",width=" + this.width + ",height=" + this.height + "]";
    }

    public int hashCode() {
        return this.x * this.y * this.width * this.height * 37;
    }
}

