/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Font;
import java.io.Serializable;

public abstract class FontMetrics
implements Serializable {
    private static final long serialVersionUID = 1681126225205050147L;
    protected Font font;

    protected FontMetrics(Font font) {
        this.font = font;
    }

    public Font getFont() {
        return this.font;
    }

    public int getLeading() {
        return 0;
    }

    public int getAscent() {
        return 1;
    }

    public int getDescent() {
        return 1;
    }

    public int getHeight() {
        return this.getAscent() + this.getDescent() + this.getLeading();
    }

    public int getMaxAscent() {
        return this.getAscent();
    }

    public int getMaxDescent() {
        return this.getDescent();
    }

    public int getMaxDecent() {
        return this.getMaxDescent();
    }

    public int getMaxAdvance() {
        return -1;
    }

    public int charWidth(int ch) {
        return this.charWidth((char)ch);
    }

    public int charWidth(char ch) {
        return 1;
    }

    public int stringWidth(String str) {
        char[] buf = new char[str.length()];
        str.getChars(0, str.length(), buf, 0);
        return this.charsWidth(buf, 0, buf.length);
    }

    public int charsWidth(char[] buf, int offset, int len) {
        int total_width = 0;
        for (int i = offset; i < len; ++i) {
            total_width = this.charWidth(buf[i]);
        }
        return total_width;
    }

    public int bytesWidth(byte[] buf, int offset, int len) {
        int total_width = 0;
        for (int i = offset; i < len; ++i) {
            total_width = this.charWidth((char)buf[i]);
        }
        return total_width;
    }

    public int[] getWidths() {
        return new int[256];
    }

    public String toString() {
        return this.getClass() + "[font=" + this.font + ",ascent=" + this.getAscent() + ",descent=" + this.getDescent() + ",height=" + this.getHeight() + "]";
    }
}

