.\" t
.\" @(#)FvwmFileMgr.1	6/6/94
.TH FvwmFileMgr 1.22 "June 6 1994"
.UC
.SH NAME
FvwmFileMgr \- the FVWM file manager module
.SH SYNOPSIS
FvwmFileMgr is spawned by fvwm, so no command line invocation will work.
From within the .fvwmrc file, FvwmFileMgr is spawned as follows:
.nf
.sp
Module FvwmFileMgr -a
.sp
.fi
or from within an fvwm pop-up menu:
.nf
.sp
Popup "Module-Popup"
	Title	"Modules"
	Module	"GoodStuff"	GoodStuff
	Module	"NoClutter"	FvwmClean
	Module	"FvwmIdentify"	FvwmIdent
	Module  "Banner"        FvwmBanner
	Module	"Debug"		FvwmDebug
	Module  "SaveDesktop"   FvwmSave
	Module  "Pager"         FvwmPager 0 3
	Module  "File Manager"  FvwmFileMgr /local/tools
EndPopup
.sp
.fi

In the above examples, I have shown the command line option "-a" to
indicate "show all files, even the ones whose name starts with .",
an the optional specification of a starting directory. Sorry, you
can't use both options at once.

.SH DESCRIPTION
The FvwmFileMgr module provides the user with an iconic representation
of the selected directories. Simple drag, click, and double click
operations allow graphical manipulation of files and starting of
applications.

FvwmFileMgr reads the same .fvwmrc file as fvwm reads when it starts up,
and looks for lines similar to "*FvwmFileMgrFore green". It also reads
the file "~/.fvwmfmgr" or "/usr/lib/X11/fvwm/system.fvwmfmgr" to
obtain a mapping of file-name/type to icon and open-methods.

.SH COPYRIGHTS
The FvwmFileMgr program, and the concept for
interfacing this module to the Window Manager, are all original work
by Robert Nation.

Copyright 1994, Robert Nation. No guarantees or warranties or anything 
are provided or implied in any way whatsoever. Use this program at your
own risk. Permission to use this program for any purpose is given,
as long as the copyright is kept intact. 


.SH INITIALIZATION
During initialization, \fIFvwmFileMgr\fP will eventually search a 
configuration file which describes the colors and font to use.
The configuration file is the same file that fvwm used during initialization.

If the FvwmIdent executable is linked to another name, ie ln -s
FvwmFileMgr MoreFvwmFileMgr, then another module called
MoreFvwmFileMgr can be
started, with a completely different configuration than FvwmFileMgr,
simply by changing the keyword  FvwmFileMgr to MoreFvwmFileMgr. 
This way multiple file-manager programs can be used.

.SH INVOCATION
The invocation method was shown in the synopsis section

.SH CONFIGURATION OPTIONS
FvwmFileMgr reads the same .fvwmrc file as fvwm reads when it starts up,
and looks for lines as listed below:

.IP "*FvwmFileMgrFore \fIcolor\fP"
Tells the module to use \fIcolor\fP instead of black for text.

.IP "*FvwmFileMgrBack \fIcolor\fP"
Tells the module to use \fIcolor\fP instead of white for the window
background.

.IP "*FvwmFileMgrFont \fIfontname\fP"
Tells the module to use \fIfontname\fP instead of fixed for text.

.IP "IconPath \fIpathname\fp"
Lists the directories to search when attempting to locate an
black-and-white X11 bitmap file (for use as an icon).

.IP "PixmapPath \fIpathname\fp"
Lists the directories to search when attempting to locate an
X11 XPM file (for use as an color icon).

.IP "*FvwmFileMgrGeometry \fIgeometry\fp
Describes the window geometry to use for directory-contents windows.
Normally, you should let the file manager select appropriate-sized
windows by itself.

.IP "*FvwmFileMgrMaxGeometry \fIgeometry\fp
Describes the maximum window size to use for directory-contents
windows. The x and y offset portions of the geometry are ignored. If
you specify this option, the file-manager will auto-size its windows
to fit the directory-contents, unless the window would be larger than
the specified maximum size.

.IP "*FvwmFileMgrMinGeometry \fIgeometry\fp
Describes the minimum window size to use for directory-contents
windows. The x and y offset portions of the geometry are ignored. If
you specify this option, the file-manager will auto-size its windows
to fit the directory-contents, unless the window would be smaller than
the specified minimum size.

.SH MORE CONFIGURATION OPTIONS
FvwmFileMgr also reads the ~/.fvwmfmgr or
/usr/lib/X11/fvwm/system.fvwmfmgr
file as fvwm reads when it starts up, and looks for lines as listed
below:

.nf
.sp
name, unused, permission: open-command, icon
.sp
.fi

where name is the file name, and permission is the file's permissions
(as shown in ls -l). If the file name and permissions fields match a
file which is found in a directory which is being searched, then the
icon and open-command will be used for that file.

The name and permissions field can contain the wildcards "*" and "?".
the open-command can contain the wildcard "$file" which expands to the
name of the file which is being opened. If no "$file" argument is
found, then the file name is tacked on to the end of the command.
Since the system() command is used to execute the command, environment
variables may also be used. Entries in this file are searched in the
order in which they appear, and the first match is used.

Here is a representative sample:
.nf
.sp
# .dvi files can be previewed with xdvi ...
*.dvi,,:xdvi ,wierd_page3.xpm

# man pages can't be previed with man or xman, since they may not be
# in a manpath directory
*.man,,:xterm -e sh -c "nroff -man $file | more" ,xman.xpm
*.1,,:xterm -e sh -c "nroff -man $file | more" ,xman.xpm

# .txt files are probably plain text
# if you use a windowing version of emacs, skip the xterm -e part...
*.txt,,:xterm -e emacs, page.xpm

# .c and .h files - assume that we'll just edit them
# if you use a windowing version of emacs, skip the xterm -e part...
*.c,,:xterm -e emacs,ccode.icon
*.h,,:xterm -e emacs,hcode.icon

# map a folder icon to sub-directories.
,,d*: ,folder2.xpm 
name, unused, permission: open-command, icon
.sp
.fi


.SH AUTHOR
Robert Nation (nation@rocket.sanders.lockheed.com).

