; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-- | FileCheck %s --check-prefix=i686
; RUN: llc < %s -mtriple=x86_64-- | FileCheck %s --check-prefix=x86_64

define i32 @test(i32 %f12) nounwind {
; i686-LABEL: test:
; i686:       # %bb.0:
; i686-NEXT:    movsbl {{[0-9]+}}(%esp), %eax
; i686-NEXT:    retl
;
; x86_64-LABEL: test:
; x86_64:       # %bb.0:
; x86_64-NEXT:    shrl $16, %edi
; x86_64-NEXT:    movsbl %dil, %eax
; x86_64-NEXT:    retq
	%tmp7.25 = lshr i32 %f12, 16
	%tmp7.26 = trunc i32 %tmp7.25 to i8
	%tmp78.2 = sext i8 %tmp7.26 to i32
	ret i32 %tmp78.2
}

define i32 @test2(i32 %f12) nounwind {
; i686-LABEL: test2:
; i686:       # %bb.0:
; i686-NEXT:    movsbl {{[0-9]+}}(%esp), %eax
; i686-NEXT:    retl
;
; x86_64-LABEL: test2:
; x86_64:       # %bb.0:
; x86_64-NEXT:    shrl $16, %edi
; x86_64-NEXT:    movsbl %dil, %eax
; x86_64-NEXT:    retq
	%f11 = shl i32 %f12, 8
	%tmp7.25 = ashr i32 %f11, 24
	ret i32 %tmp7.25
}

define i32 @test3(i32 %f12) nounwind {
; i686-LABEL: test3:
; i686:       # %bb.0:
; i686-NEXT:    movl {{[0-9]+}}(%esp), %eax
; i686-NEXT:    shrl $11, %eax
; i686-NEXT:    movsbl %al, %eax
; i686-NEXT:    retl
;
; x86_64-LABEL: test3:
; x86_64:       # %bb.0:
; x86_64-NEXT:    shrl $11, %edi
; x86_64-NEXT:    movsbl %dil, %eax
; x86_64-NEXT:    retq
	%f11 = shl i32 %f12, 13
	%tmp7.25 = ashr i32 %f11, 24
	ret i32 %tmp7.25
}

define i64 @test4(i64 %f12) nounwind {
; i686-LABEL: test4:
; i686:       # %bb.0:
; i686-NEXT:    movl {{[0-9]+}}(%esp), %eax
; i686-NEXT:    movl %eax, %edx
; i686-NEXT:    sarl $31, %edx
; i686-NEXT:    retl
;
; x86_64-LABEL: test4:
; x86_64:       # %bb.0:
; x86_64-NEXT:    movslq %edi, %rax
; x86_64-NEXT:    retq
	%f11 = shl i64 %f12, 32
	%tmp7.25 = ashr i64 %f11, 32
	ret i64 %tmp7.25
}

define i16 @test5(i16 %f12) nounwind {
; i686-LABEL: test5:
; i686:       # %bb.0:
; i686-NEXT:    movl {{[0-9]+}}(%esp), %eax
; i686-NEXT:    shrl $6, %eax
; i686-NEXT:    movsbl %al, %eax
; i686-NEXT:    # kill: def $ax killed $ax killed $eax
; i686-NEXT:    retl
;
; x86_64-LABEL: test5:
; x86_64:       # %bb.0:
; x86_64-NEXT:    shrl $6, %edi
; x86_64-NEXT:    movsbl %dil, %eax
; x86_64-NEXT:    # kill: def $ax killed $ax killed $eax
; x86_64-NEXT:    retq
	%f11 = shl i16 %f12, 2
	%tmp7.25 = ashr i16 %f11, 8
	ret i16 %tmp7.25
}

define i16 @test6(i16 %f12) nounwind {
; i686-LABEL: test6:
; i686:       # %bb.0:
; i686-NEXT:    movsbl {{[0-9]+}}(%esp), %eax
; i686-NEXT:    # kill: def $ax killed $ax killed $eax
; i686-NEXT:    retl
;
; x86_64-LABEL: test6:
; x86_64:       # %bb.0:
; x86_64-NEXT:    movsbl %dil, %eax
; x86_64-NEXT:    # kill: def $ax killed $ax killed $eax
; x86_64-NEXT:    retq
	%f11 = shl i16 %f12, 8
	%tmp7.25 = ashr i16 %f11, 8
	ret i16 %tmp7.25
}
