; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-apple-darwin -mcpu=corei7 --show-mc-encoding | FileCheck %s --check-prefix=CHECK --check-prefix=NOADX
; RUN: llc < %s -mtriple=x86_64-apple-darwin -mcpu=broadwell --show-mc-encoding | FileCheck %s --check-prefix=CHECK --check-prefix=ADX

declare i8 @llvm.x86.addcarryx.u32(i8, i32, i32, i8*)

define i8 @test_addcarryx_u32(i8 %c, i32 %a, i32 %b, i8* %ptr) {
; CHECK-LABEL: test_addcarryx_u32:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    addb $-1, %dil ## encoding: [0x40,0x80,0xc7,0xff]
; CHECK-NEXT:    adcl %edx, %esi ## encoding: [0x11,0xd6]
; CHECK-NEXT:    setb %al ## encoding: [0x0f,0x92,0xc0]
; CHECK-NEXT:    movl %esi, (%rcx) ## encoding: [0x89,0x31]
; CHECK-NEXT:    retq ## encoding: [0xc3]
  %ret = tail call i8 @llvm.x86.addcarryx.u32(i8 %c, i32 %a, i32 %b, i8* %ptr)
  ret i8 %ret;
}

declare i8 @llvm.x86.addcarryx.u64(i8, i64, i64, i8*)

define i8 @test_addcarryx_u64(i8 %c, i64 %a, i64 %b, i8* %ptr) {
; CHECK-LABEL: test_addcarryx_u64:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    addb $-1, %dil ## encoding: [0x40,0x80,0xc7,0xff]
; CHECK-NEXT:    adcq %rdx, %rsi ## encoding: [0x48,0x11,0xd6]
; CHECK-NEXT:    setb %al ## encoding: [0x0f,0x92,0xc0]
; CHECK-NEXT:    movq %rsi, (%rcx) ## encoding: [0x48,0x89,0x31]
; CHECK-NEXT:    retq ## encoding: [0xc3]
  %ret = tail call i8 @llvm.x86.addcarryx.u64(i8 %c, i64 %a, i64 %b, i8* %ptr)
  ret i8 %ret;
}

declare i8 @llvm.x86.addcarry.u32(i8, i32, i32, i8*)

define i8 @test_addcarry_u32(i8 %c, i32 %a, i32 %b, i8* %ptr) {
; CHECK-LABEL: test_addcarry_u32:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    addb $-1, %dil ## encoding: [0x40,0x80,0xc7,0xff]
; CHECK-NEXT:    adcl %edx, %esi ## encoding: [0x11,0xd6]
; CHECK-NEXT:    setb %al ## encoding: [0x0f,0x92,0xc0]
; CHECK-NEXT:    movl %esi, (%rcx) ## encoding: [0x89,0x31]
; CHECK-NEXT:    retq ## encoding: [0xc3]
  %ret = tail call i8 @llvm.x86.addcarry.u32(i8 %c, i32 %a, i32 %b, i8* %ptr)
  ret i8 %ret;
}

declare i8 @llvm.x86.addcarry.u64(i8, i64, i64, i8*)

define i8 @test_addcarry_u64(i8 %c, i64 %a, i64 %b, i8* %ptr) {
; CHECK-LABEL: test_addcarry_u64:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    addb $-1, %dil ## encoding: [0x40,0x80,0xc7,0xff]
; CHECK-NEXT:    adcq %rdx, %rsi ## encoding: [0x48,0x11,0xd6]
; CHECK-NEXT:    setb %al ## encoding: [0x0f,0x92,0xc0]
; CHECK-NEXT:    movq %rsi, (%rcx) ## encoding: [0x48,0x89,0x31]
; CHECK-NEXT:    retq ## encoding: [0xc3]
  %ret = tail call i8 @llvm.x86.addcarry.u64(i8 %c, i64 %a, i64 %b, i8* %ptr)
  ret i8 %ret;
}

declare i8 @llvm.x86.subborrow.u32(i8, i32, i32, i8*)

define i8 @test_subborrow_u32(i8 %c, i32 %a, i32 %b, i8* %ptr) {
; CHECK-LABEL: test_subborrow_u32:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    addb $-1, %dil ## encoding: [0x40,0x80,0xc7,0xff]
; CHECK-NEXT:    sbbl %edx, %esi ## encoding: [0x19,0xd6]
; CHECK-NEXT:    setb %al ## encoding: [0x0f,0x92,0xc0]
; CHECK-NEXT:    movl %esi, (%rcx) ## encoding: [0x89,0x31]
; CHECK-NEXT:    retq ## encoding: [0xc3]
  %ret = tail call i8 @llvm.x86.subborrow.u32(i8 %c, i32 %a, i32 %b, i8* %ptr)
  ret i8 %ret;
}

declare i8 @llvm.x86.subborrow.u64(i8, i64, i64, i8*)

define i8 @test_subborrow_u64(i8 %c, i64 %a, i64 %b, i8* %ptr) {
; CHECK-LABEL: test_subborrow_u64:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    addb $-1, %dil ## encoding: [0x40,0x80,0xc7,0xff]
; CHECK-NEXT:    sbbq %rdx, %rsi ## encoding: [0x48,0x19,0xd6]
; CHECK-NEXT:    setb %al ## encoding: [0x0f,0x92,0xc0]
; CHECK-NEXT:    movq %rsi, (%rcx) ## encoding: [0x48,0x89,0x31]
; CHECK-NEXT:    retq ## encoding: [0xc3]
  %ret = tail call i8 @llvm.x86.subborrow.u64(i8 %c, i64 %a, i64 %b, i8* %ptr)
  ret i8 %ret;
}

; Try a version with loads. Previously we crashed on this.
define i32 @load_crash(i64* nocapture readonly %a, i64* nocapture readonly %b, i64* %res)  {
; CHECK-LABEL: load_crash:
; CHECK:       ## %bb.0:
; CHECK-NEXT:    movq (%rdi), %rcx ## encoding: [0x48,0x8b,0x0f]
; CHECK-NEXT:    xorl %eax, %eax ## encoding: [0x31,0xc0]
; CHECK-NEXT:    addq (%rsi), %rcx ## encoding: [0x48,0x03,0x0e]
; CHECK-NEXT:    setb %al ## encoding: [0x0f,0x92,0xc0]
; CHECK-NEXT:    movq %rcx, (%rdx) ## encoding: [0x48,0x89,0x0a]
; CHECK-NEXT:    retq ## encoding: [0xc3]
  %1 = load i64, i64* %a, align 8
  %2 = load i64, i64* %b, align 8
  %3 = bitcast i64* %res to i8*
  %4 = tail call i8 @llvm.x86.addcarryx.u64(i8 0, i64 %1, i64 %2, i8* %3)
  %conv = zext i8 %4 to i32
  ret i32 %conv
}

; Try a really simple all zero input case, which also used to crash
define void @allzeros() {
; CHECK-LABEL: allzeros:
; CHECK:       ## %bb.0: ## %entry
; CHECK-NEXT:    xorl %eax, %eax ## encoding: [0x31,0xc0]
; CHECK-NEXT:    addq $0, %rax ## encoding: [0x48,0x83,0xc0,0x00]
; CHECK-NEXT:    movq %rax, 0 ## encoding: [0x48,0x89,0x04,0x25,0x00,0x00,0x00,0x00]
; CHECK-NEXT:    retq ## encoding: [0xc3]
entry:
  %0 = tail call i8 @llvm.x86.addcarryx.u64(i8 0, i64 0, i64 0, i8* null)
  ret void
}
