/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jdbc3;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import openlink.util.Vector;
import virtuoso.jdbc3.VirtuosoBlobStream;
import virtuoso.jdbc3.VirtuosoClobStream;
import virtuoso.jdbc3.VirtuosoConnection;
import virtuoso.jdbc3.VirtuosoException;
import virtuoso.jdbc3.VirtuosoFuture;

public class VirtuosoBlob
implements Blob,
Clob {
    private boolean request = true;
    private long length;
    private long bh_page;
    private long ask;
    private long bh_current_page;
    private long bh_start_offset;
    private long bh_position;
    private byte[] buffer;
    private Reader rd;
    private InputStream is;
    private VirtuosoConnection connection;
    protected int dtp;
    protected long key_id = 0L;
    protected long frag_no = 0L;
    protected long dir_page = 0L;
    protected long bh_timestamp = 0L;
    protected Object pages = null;

    VirtuosoBlob(InputStream inputStream, long l, long l2) throws VirtuosoException {
        this.is = inputStream;
        this.bh_page = l2;
        this.length = l;
        this.rewind();
    }

    private void rewind() {
        this.bh_current_page = this.bh_page;
        this.bh_start_offset = 0L;
        this.bh_position = 0L;
    }

    private long bh_offset() {
        return this.bh_start_offset;
    }

    VirtuosoBlob(byte[] byArray) throws VirtuosoException {
        this.buffer = byArray;
        this.request = false;
        this.length = byArray.length;
    }

    VirtuosoBlob() throws VirtuosoException {
    }

    VirtuosoBlob(Object object, long l) throws VirtuosoException {
    }

    VirtuosoBlob(Reader reader, long l, long l2) throws VirtuosoException {
        this.rd = reader;
        this.length = l;
        this.bh_page = l2;
        this.rewind();
    }

    VirtuosoBlob(VirtuosoConnection virtuosoConnection, long l, long l2, long l3) throws VirtuosoException {
        this.connection = virtuosoConnection;
        this.ask = l;
        this.bh_page = l2;
        this.length = l3;
        this.dtp = 126;
        this.rewind();
    }

    VirtuosoBlob(VirtuosoConnection virtuosoConnection, long l, long l2, long l3, long l4, long l5, long l6, long l7, Object object, int n) throws VirtuosoException {
        this.connection = virtuosoConnection;
        this.ask = l;
        this.bh_page = l2;
        this.length = l3;
        this.dtp = n;
        this.key_id = l4;
        this.frag_no = l5;
        this.dir_page = l6;
        this.bh_timestamp = l7;
        this.pages = object;
        this.rewind();
    }

    protected void setInputStream(InputStream inputStream, long l) {
        this.is = inputStream;
        this.length = l;
    }

    protected void setReader(Reader reader, long l) {
        this.rd = reader;
        this.length = l;
    }

    protected void setObject(Object object) {
    }

    private void checkBlobError(Vector vector) throws VirtuosoException {
        if (vector.firstElement() instanceof Long && ((Number)vector.firstElement()).longValue() == 3L) {
            throw new VirtuosoException(vector.elementAt(2).toString(), vector.elementAt(1).toString(), -8);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes(long l, int n) throws VirtuosoException {
        if (l <= 0L) {
            throw new VirtuosoException("Invalid param to the getBytes", "22023", -4);
        }
        if (!this.request) {
            if (--l > (long)this.buffer.length || l + (long)n > (long)this.buffer.length) {
                return null;
            }
            byte[] byArray = new byte[n];
            System.arraycopy(this.buffer, (int)l, byArray, 0, n);
            return byArray;
        }
        try {
            Object object;
            Object object2;
            Object object3;
            if (l < 0L || n <= 0 || l + (long)n - 1L > this.length) {
                return null;
            }
            Long l2 = null;
            if (l - 1L < this.bh_offset()) {
                this.rewind();
                l2 = new Long(l - 1L);
            } else if (l - 1L > this.bh_offset()) {
                l2 = new Long(l - this.bh_offset() - 1L);
            }
            if (l2 != null) {
                object3 = null;
                VirtuosoConnection virtuosoConnection = this.connection;
                synchronized (virtuosoConnection) {
                    object2 = new Object[]{new Long(this.bh_current_page), l2, new Long(this.bh_position), new Long(this.key_id), new Long(this.frag_no), new Long(this.dir_page), this.pages, this.dtp == 133 ? new Long(1L) : new Long(0L), new Long(this.bh_timestamp)};
                    object = this.connection.getFuture("GETDA", (Object[])object2, -1);
                    object3 = ((VirtuosoFuture)object).nextResult();
                    object3 = (Vector)((Vector)object3).firstElement();
                    this.connection.removeFuture((VirtuosoFuture)object);
                }
                if (!(object3 instanceof Vector)) {
                    return null;
                }
                this.checkBlobError((Vector)object3);
                for (int i = 0; i < ((Vector)object3).size(); ++i) {
                    object2 = ((Vector)object3).elementAt(i);
                    if (object2 instanceof Vector) {
                        object = (Vector)object2;
                        this.bh_current_page = ((Number)((Vector)object).elementAt(1)).longValue();
                        this.bh_position = ((Number)((Vector)object).elementAt(2)).longValue();
                        break;
                    }
                    if (!(object2 instanceof String)) continue;
                    object = (String)object2;
                    if (this.dtp == 133) {
                        this.bh_start_offset += (long)((String)object).length();
                        continue;
                    }
                    this.bh_start_offset += (long)((String)object).getBytes("8859_1").length;
                }
            }
            object3 = new ByteArrayOutputStream();
            Vector vector = null;
            object2 = this.connection;
            synchronized (this.connection) {
                object = new Object[]{new Long(this.bh_current_page), new Long(n), new Long(this.bh_position), new Long(this.key_id), new Long(this.frag_no), new Long(this.dir_page), this.pages, this.dtp == 133 ? new Long(1L) : new Long(0L), new Long(this.bh_timestamp)};
                Object object4 = this.connection.getFuture("GETDA", (Object[])object, -1);
                vector = ((VirtuosoFuture)object4).nextResult();
                vector = (Vector)vector.firstElement();
                this.connection.removeFuture((VirtuosoFuture)object4);
                // ** MonitorExit[var7_10 /* !! */ ] (shouldn't be in output)
                if (!(vector instanceof Vector)) {
                    return null;
                }
                this.checkBlobError(vector);
                for (int i = 0; i < vector.size(); ++i) {
                    object = vector.elementAt(i);
                    if (object instanceof Vector) {
                        object4 = (Vector)object;
                        this.bh_current_page = ((Number)((Vector)object4).elementAt(1)).longValue();
                        this.bh_position = ((Number)((Vector)object4).elementAt(2)).longValue();
                        continue;
                    }
                    if (!(object instanceof String)) continue;
                    object4 = (String)object;
                    ((OutputStream)object3).write(((String)object4).getBytes("8859_1"));
                    this.bh_start_offset += (long)((String)object4).getBytes("8859_1").length;
                }
                byte[] byArray = ((ByteArrayOutputStream)object3).toByteArray();
                return byArray;
            }
        }
        catch (IOException iOException) {
            throw new VirtuosoException("I/O error occurred : " + iOException.getMessage(), -3);
        }
    }

    public String getSubString(long l, int n) throws VirtuosoException {
        byte[] byArray = this.getBytes(l, n);
        if (this.dtp == 133) {
            try {
                return new String(byArray, "UTF8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new VirtuosoException("UTF8 not supported in getSubString", -17);
            }
        }
        try {
            return new String(byArray, "8859_1");
        }
        catch (Exception exception) {
            throw new VirtuosoException("8859-1 not supported in getSubString", -17);
        }
    }

    public long length() throws VirtuosoException {
        return this.length;
    }

    public InputStream getBinaryStream() throws VirtuosoException {
        if (this.is != null) {
            return this.is;
        }
        if (this.buffer != null) {
            return new ByteArrayInputStream(this.buffer);
        }
        return new VirtuosoBlobStream(this);
    }

    public Reader getCharacterStream() throws VirtuosoException {
        if (this.rd != null) {
            return this.rd;
        }
        if (this.buffer != null) {
            return new StringReader(new String(this.buffer));
        }
        try {
            switch (this.dtp) {
                case 132: {
                    return new InputStreamReader((InputStream)new VirtuosoBlobStream(this), "UTF8");
                }
                case 131: {
                    return new InputStreamReader((InputStream)new VirtuosoBlobStream(this), "8859_1");
                }
            }
            return new InputStreamReader((InputStream)new VirtuosoBlobStream(this), this.connection.charset != null ? this.connection.charset : "8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new VirtuosoException("Unsupported charset encoding : " + unsupportedEncodingException.getMessage(), -10);
        }
    }

    public InputStream getAsciiStream() throws VirtuosoException {
        if (this.is != null) {
            return this.is;
        }
        if (this.buffer != null) {
            return new ByteArrayInputStream(this.buffer);
        }
        return new VirtuosoClobStream(this);
    }

    public long position(byte[] byArray, long l) throws VirtuosoException {
        if (!this.request) {
            int n;
            if (l >= (long)this.buffer.length || l + (long)byArray.length >= (long)this.buffer.length) {
                return -1L;
            }
            boolean bl = true;
            for (n = (int)l - 1; n < this.buffer.length && bl; bl &= this.buffer[n] == byArray[n], ++n) {
            }
            if (bl) {
                return n;
            }
            return -1L;
        }
        try {
            VirtuosoBlobStream virtuosoBlobStream = (VirtuosoBlobStream)this.getBinaryStream();
            virtuosoBlobStream.skip(l - 1L);
            byte[] byArray2 = new byte[byArray.length];
            while (virtuosoBlobStream.available() > byArray2.length) {
                if (virtuosoBlobStream.read(byArray2, 0, byArray2.length) == -1) {
                    throw new VirtuosoException("End of stream reached.", -14);
                }
                boolean bl = true;
                for (int i = 0; i < byArray2.length && bl; bl &= byArray2[i] == byArray[i], ++i) {
                }
                if (!bl) continue;
                return virtuosoBlobStream.pos;
            }
            return -1L;
        }
        catch (IOException iOException) {
            throw new VirtuosoException("I/O error occurred : " + iOException.getMessage(), -3);
        }
    }

    public long position(Blob blob, long l) throws VirtuosoException {
        try {
            VirtuosoBlobStream virtuosoBlobStream = (VirtuosoBlobStream)blob.getBinaryStream();
            virtuosoBlobStream.skip(l - 1L);
            byte[] byArray = new byte[8192];
            while (virtuosoBlobStream.available() > 8192) {
                if (virtuosoBlobStream.read(byArray, 0, 8192) == -1) {
                    throw new VirtuosoException("End of stream reached.", -14);
                }
                long l2 = this.position(byArray, l += 8192L);
                if (l2 == -1L) continue;
                return l2;
            }
            return -1L;
        }
        catch (IOException iOException) {
            throw new VirtuosoException("I/O error occurred : " + iOException.getMessage(), -3);
        }
        catch (SQLException sQLException) {
            throw new VirtuosoException("SQL error occurred : " + sQLException.getMessage(), -8);
        }
    }

    public long position(String string, long l) throws VirtuosoException {
        try {
            VirtuosoClobStream virtuosoClobStream = (VirtuosoClobStream)this.getAsciiStream();
            virtuosoClobStream.skip(l - 1L);
            byte[] byArray = new byte[string.length()];
            while (virtuosoClobStream.available() > byArray.length) {
                if (virtuosoClobStream.read(byArray, 0, byArray.length) == -1) {
                    throw new VirtuosoException("End of stream reached.", -14);
                }
                if (!string.equals(new String(byArray))) continue;
                return virtuosoClobStream.pos;
            }
            return -1L;
        }
        catch (IOException iOException) {
            throw new VirtuosoException("I/O error occurred : " + iOException.getMessage(), -3);
        }
    }

    public long position(Clob clob, long l) throws VirtuosoException {
        try {
            VirtuosoClobStream virtuosoClobStream = (VirtuosoClobStream)clob.getAsciiStream();
            virtuosoClobStream.skip(l - 1L);
            byte[] byArray = new byte[8192];
            while (virtuosoClobStream.available() > 8192) {
                if (virtuosoClobStream.read(byArray, 0, 8192) == -1) {
                    throw new VirtuosoException("End of stream reached.", -14);
                }
                long l2 = this.position(new String(byArray), l += 8192L);
                if (l2 == -1L) continue;
                return l2;
            }
            return -1L;
        }
        catch (IOException iOException) {
            throw new VirtuosoException("I/O error occurred : " + iOException.getMessage(), -3);
        }
        catch (SQLException sQLException) {
            throw new VirtuosoException("SQL error occurred : " + sQLException.getMessage(), -8);
        }
    }

    public int hashCode() {
        return (int)this.bh_page;
    }

    public String toString() {
        return "Blob " + this.length + "b";
    }

    public int setString(long l, String string, int n, int n2) throws SQLException {
        throw new VirtuosoException("Not implemented function", -7);
    }

    public int setString(long l, String string) throws SQLException {
        return this.setString(l, string, 0, string.length());
    }

    public OutputStream setAsciiStream(long l) throws SQLException {
        throw new VirtuosoException("Not implemented function", -7);
    }

    public Writer setCharacterStream(long l) throws SQLException {
        throw new VirtuosoException("Not implemented function", -7);
    }

    public void truncate(long l) throws SQLException {
        throw new VirtuosoException("Not implemented function", -7);
    }

    public int setBytes(long l, byte[] byArray) throws SQLException {
        return this.setBytes(l, byArray, 0, byArray.length);
    }

    public int setBytes(long l, byte[] byArray, int n, int n2) throws SQLException {
        throw new VirtuosoException("Not implemented function", -7);
    }

    public OutputStream setBinaryStream(long l) throws SQLException {
        throw new VirtuosoException("Not implemented function", -7);
    }

    public InputStream getBinaryStream(long l, long l2) throws SQLException {
        throw new VirtuosoException("Not implemented function", -7);
    }

    public void free() throws SQLException {
        throw new VirtuosoException("Not implemented function", -7);
    }

    public Reader getCharacterStream(long l, long l2) throws SQLException {
        throw new VirtuosoException("Not implemented function", -7);
    }
}

