//Auto-generated by kalyptus. DO NOT EDIT.
namespace Kimono {
    using System;
    using Qyoto;
    using System.Runtime.InteropServices;
    using System.Text;
    using System.Collections.Generic;
    /// <remarks>
    ///  \class KMacroExpanderBase kmacroexpander.h <KMacroExpanderBase>
    ///  Abstract base class for the worker classes behind the KMacroExpander namespace
    ///  and the KCharMacroExpander and KWordMacroExpander classes.
    /// </remarks>        <author> Oswald Buddenhagen <ossi@kde.org>
    ///  </author>
    ///         <short>    \class KMacroExpanderBase kmacroexpander.</short>
    [SmokeClass("KMacroExpanderBase")]
    public class KMacroExpanderBase : Object, IDisposable {
        protected SmokeInvocation interceptor = null;
        private IntPtr smokeObject;
        protected KMacroExpanderBase(Type dummy) {}
        protected void CreateProxy() {
            interceptor = new SmokeInvocation(typeof(KMacroExpanderBase), this);
        }
        /// <remarks>
        ///  Constructor.
        /// <param> name="c" escape char indicating start of macros, or QChar.Null for none
        ///      </param></remarks>        <short>    Constructor.</short>
        public KMacroExpanderBase(QChar c) : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KMacroExpanderBase#", "KMacroExpanderBase(QChar)", typeof(void), typeof(QChar), c);
        }
        public KMacroExpanderBase() : this((Type) null) {
            CreateProxy();
            interceptor.Invoke("KMacroExpanderBase", "KMacroExpanderBase()", typeof(void));
        }
        /// <remarks>
        ///  Perform safe macro expansion (substitution) on a string.
        /// <param> name="str" the string in which macros are expanded in-place
        ///      </param></remarks>        <short>    Perform safe macro expansion (substitution) on a string.</short>
        public void ExpandMacros(StringBuilder str) {
            interceptor.Invoke("expandMacros$", "expandMacros(QString&)", typeof(void), typeof(StringBuilder), str);
        }
        /// <remarks>
        ///  Perform safe macro expansion (substitution) on a string for use
        ///  in shell commands.
        ///  <h3>NIX notes</h3>
        ///  Explicitly supported shell constructs:
        ///    \ '' "" $'' $"" {} () $(()) ${} $() ``
        ///  Implicitly supported shell constructs:
        ///    (())
        ///  Unsupported shell constructs that will cause problems:
        ///   Shortened &quot;<tt>case $v in pat)</tt>&quot; syntax. Use
        ///    &quot;<tt>case $v in (pat)</tt>&quot; instead.
        ///  The rest of the shell (incl. bash) syntax is simply ignored,
        ///  as it is not expected to cause problems.
        ///  Note that bash contains a bug which makes macro expansion within 
        ///  double quoted substitutions (<tt>"${VAR:-%macro}"</tt>) inherently
        ///  insecure.
        ///  For security reasons, <b>never</b> put expandos in command line arguments
        ///  that are shell commands by themselves -
        ///  &quot;<tt>sh -c 'foo \%f'</tt>&quot; is taboo.
        ///  &quot;<tt>file=\%f sh -c 'foo "$file"'</tt>&quot; is OK.
        ///  <h3>Windows notes</h3>
        ///  All quoting syntax supported by KShell is supported here as well.
        ///  Additionally, command grouping via parentheses is recognized - note
        ///  however, that the parser is much stricter about unquoted parentheses
        ///  than cmd itself.
        ///  The rest of the cmd syntax is simply ignored, as it is not expected
        ///  to cause problems - do not use commands that embed other commands,
        ///  though - &quot;<tt>for /f ...</tt>&quot; is taboo.
        /// <param> name="str" the string in which macros are expanded in-place
        /// </param><param> name="pos" the position inside the string at which parsing/substitution
        ///   should start, and upon exit where processing stopped
        /// </param></remarks>        <return> false if the string could not be parsed and therefore no safe
        ///   substitution was possible. Note that macros will have been processed
        ///   up to the point where the error occurred. An unmatched closing paren
        ///   or brace outside any shell construct is @em not an error (unlike in
        ///   the function below), but still prematurely terminates processing.
        ///      </return>
        ///         <short>    Perform safe macro expansion (substitution) on a string for use  in shell commands.</short>
        public bool ExpandMacrosShellQuote(StringBuilder str, ref int pos) {
            StackItem[] stack = new StackItem[3];
#if DEBUG
            stack[1].s_class = (IntPtr) DebugGCHandle.Alloc(str);
#else
            stack[1].s_class = (IntPtr) GCHandle.Alloc(str);
#endif
            stack[2].s_int = pos;
            interceptor.Invoke("expandMacrosShellQuote$$", "expandMacrosShellQuote(QString&, int&)", stack);
#if DEBUG
            DebugGCHandle.Free((GCHandle) stack[1].s_class);
#else
            ((GCHandle) stack[1].s_class).SynchronizedFree();
#endif
            pos = stack[2].s_int;
            return stack[0].s_bool;
        }
        /// <remarks>
        ///  Same as above, but always starts at position 0, and unmatched closing
        ///  parens and braces are treated as errors.
        ///      </remarks>        <short>    Same as above, but always starts at position 0, and unmatched closing  parens and braces are treated as errors.</short>
        public bool ExpandMacrosShellQuote(StringBuilder str) {
            return (bool) interceptor.Invoke("expandMacrosShellQuote$", "expandMacrosShellQuote(QString&)", typeof(bool), typeof(StringBuilder), str);
        }
        /// <remarks>
        ///  Set the macro escape character.
        /// <param> name="c" escape char indicating start of macros, or QChar.Null if none
        ///      </param></remarks>        <short>    Set the macro escape character.</short>
        public void SetEscapeChar(QChar c) {
            interceptor.Invoke("setEscapeChar#", "setEscapeChar(QChar)", typeof(void), typeof(QChar), c);
        }
        /// <remarks>
        ///  Obtain the macro escape character.
        /// </remarks>        <return> escape char indicating start of macros, or QChar.Null if none
        ///      </return>
        ///         <short>    Obtain the macro escape character.</short>
        public QChar EscapeChar() {
            return (QChar) interceptor.Invoke("escapeChar", "escapeChar() const", typeof(QChar));
        }
        /// <remarks>
        ///  This function is called for every single char within the string if
        ///  the escape char is QChar.Null. It should determine whether the
        ///  string starting at <code>pos</code> within <code>str</code> is a valid macro and return
        ///  the substitution value for it if so.
        /// <param> name="str" the input string
        /// </param><param> name="pos" the offset within <code>str</code>
        /// </param><param> name="ret" return value: the string to substitute for the macro
        /// </param></remarks>        <return> If greater than zero, the number of chars at <code>pos</code> in <code>str</code>
        ///   to substitute with <code>ret</code> (i.e., a valid macro was found). If less
        ///   than zero, subtract this value from <code>pos</code> (to skip a macro, i.e.,
        ///   substitute it with itself). If zero, no macro starts at <code>pos.</code>
        ///      </return>
        ///         <short>    This function is called for every single char within the string if  the escape char is QChar.Null.</short>
        [SmokeMethod("expandPlainMacro(const QString&, int, QStringList&)")]
        protected virtual int ExpandPlainMacro(string str, int pos, List<string> ret) {
            return (int) interceptor.Invoke("expandPlainMacro$$?", "expandPlainMacro(const QString&, int, QStringList&)", typeof(int), typeof(string), str, typeof(int), pos, typeof(List<string>), ret);
        }
        /// <remarks>
        ///  This function is called every time the escape char is found if it is
        ///  not QChar.Null. It should determine whether the
        ///  string starting at <code>pos</code> witin <code>str</code> is a valid macro and return
        ///  the substitution value for it if so.
        /// <param> name="str" the input string
        /// </param><param> name="pos" the offset within <code>str.</code> Note that this is the position of
        ///   the occurrence of the escape char
        /// </param><param> name="ret" return value: the string to substitute for the macro
        /// </param></remarks>        <return> If greater than zero, the number of chars at <code>pos</code> in <code>str</code>
        ///   to substitute with <code>ret</code> (i.e., a valid macro was found). If less
        ///   than zero, subtract this value from <code>pos</code> (to skip a macro, i.e.,
        ///   substitute it with itself). If zero, scanning continues as if no
        ///   escape char was encountered at all.
        ///      </return>
        ///         <short>    This function is called every time the escape char is found if it is  not QChar.Null.</short>
        [SmokeMethod("expandEscapedMacro(const QString&, int, QStringList&)")]
        protected virtual int ExpandEscapedMacro(string str, int pos, List<string> ret) {
            return (int) interceptor.Invoke("expandEscapedMacro$$?", "expandEscapedMacro(const QString&, int, QStringList&)", typeof(int), typeof(string), str, typeof(int), pos, typeof(List<string>), ret);
        }
        ~KMacroExpanderBase() {
            interceptor.Invoke("~KMacroExpanderBase", "~KMacroExpanderBase()", typeof(void));
        }
        public void Dispose() {
            interceptor.Invoke("~KMacroExpanderBase", "~KMacroExpanderBase()", typeof(void));
        }
    }
}
