'\" t
.\" Copyright (c) 1999 - Sun Microsystems, Inc.
.\" All rights reserved.
.\" 
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, and/or sell copies of the Software, and to permit persons
.\" to whom the Software is furnished to do so, provided that the above
.\" copyright notice(s) and this permission notice appear in all copies of
.\" the Software and that both the above copyright notice(s) and this
.\" permission notice appear in supporting documentation.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
.\" OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
.\" HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
.\" INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
.\" FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
.\" NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
.\" WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\" 
.\" Except as contained in this notice, the name of a copyright holder
.\" shall not be used in advertising or otherwise to promote the sale, use
.\" or other dealings in this Software without prior written authorization
.\" of the copyright holder.
.\"
.TH XkbKeyActionsPtr __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbKeyActionsPtr \-  Returns a pointer to the two-dimensional array of key 
actions associated with 
the key corresponding to keycode
.SH SYNOPSIS
.B XkbKeyActionPtr XkbKeyActionsPtr macro
(
.I xkb,
.I keycode
)
.br
      XkbDescPtr \fIxkb\fP\^;
.br
      KeyCode \fIkeycode\fP\^;
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I \- xkb
Xkb description of interest 
.TP
.I \- keycode
keycode of interest
.SH DESCRIPTION
.LP
A key action defines the effect key presses and releases have on the internal 
state of the server. 
For example, the expected key action associated with pressing the Shift key is 
to set the Shift 
modifier. There is zero or one key action associated with each keysym bound to 
each key.

Just as the entire list of key symbols for the keyboard mapping is held in the
.I syms 
field of the client map, the entire list of key actions for the keyboard mapping 
is held in the 
.I acts 
array of the server map. The total size of 
.I acts 
is specified by 
.I size_acts, 
and the number of entries is specified by 
.I num_acts. 

The 
.I key_acts 
array, indexed by keycode, describes the actions associated with a key. The
.I key_acts 
array has 
.I min_key_code 
unused entries at the start to allow direct indexing using a keycode. If a
.I key_acts 
entry is zero, it means the key does not have any actions associated with it. If 
an entry is not 
zero, the entry represents an index into the 
.I acts 
field of the server map, much as the 
.I offset 
field of a KeySymMapRec structure is an index into the 
.I syms 
field of the client map. 

The reason the 
.I acts 
field is a linear list of XkbActions is to reduce the memory consumption 
associated with a keymap. 
Because Xkb allows individual keys to have multiple shift levels and a different 
number of groups per 
key, a single two-dimensional array of KeySyms would potentially be very large 
and sparse. Instead, 
Xkb provides a small two-dimensional array of XkbActions for each key. To store 
all of these 
individual arrays, Xkb concatenates each array together in the 
.I acts 
field of the server map.

The key action structures consist only of fields of type char or unsigned char. 
This is done to 
optimize data transfer when the server sends bytes over the wire. If the fields 
are anything but 
bytes, the server has to sift through all of the actions and swap any nonbyte 
fields. Because they 
consist of nothing but bytes, it can just copy them out.

.I XkbKeyActionsPtr 
returns a pointer to the two-dimensional array of key actions associated with 
the key corresponding 
to 
.I keycode. 
Use 
.I XkbKeyActionsPtr 
only if the key actually has some actions associated with it, that is,
.I XkbKeyNumActions
(xkb, keycode) returns something greater than zero.
.SH STRUCTURES
.LP
The KeySymMapRec structure is defined as follows:
.nf

    #define XkbNumKbdGroups             4
    #define XkbMaxKbdGroup              (XkbNumKbdGroups-1)
    
    typedef struct {                    /\(** map to keysyms for a single keycode 
*/
        unsigned char       kt_index[XkbNumKbdGroups];  /\(** key type index for 
each group */
        unsigned char       group_info; /\(** # of groups and out of range group 
handling */
        unsigned char       width;      /\(** max # of shift levels for key */
        unsigned short      offset;     /\(** index to keysym table in syms array 
*/
} XkbSymMapRec, *XkbSymMapPtr;

.fi
.SH "SEE ALSO"
.BR XkbKeyNumActions (__libmansuffix__)
