/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.rdbms.algebra.base;

import java.util.ArrayList;
import java.util.List;
import org.openrdf.query.algebra.QueryModelNode;
import org.openrdf.query.algebra.QueryModelVisitor;
import org.openrdf.sail.rdbms.algebra.ColumnVar;
import org.openrdf.sail.rdbms.algebra.base.RdbmsQueryModelNodeBase;
import org.openrdf.sail.rdbms.algebra.base.SqlExpr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FromItem
extends RdbmsQueryModelNodeBase {
    private String alias;
    private boolean left;
    private List<FromItem> joins = new ArrayList<FromItem>();
    private List<SqlExpr> filters = new ArrayList<SqlExpr>();

    public FromItem(String alias) {
        this.alias = alias;
    }

    public String getAlias() {
        return this.alias;
    }

    public boolean isLeft() {
        return this.left;
    }

    public void setLeft(boolean left) {
        this.left = left;
    }

    public List<SqlExpr> getFilters() {
        return this.filters;
    }

    public void addFilter(SqlExpr filter) {
        this.filters.add(filter);
        filter.setParentNode(this);
    }

    public List<FromItem> getJoins() {
        return this.joins;
    }

    public ColumnVar getVarForChildren(String name) {
        for (FromItem join : this.joins) {
            ColumnVar var = join.getVar(name);
            if (var == null) continue;
            return var;
        }
        return null;
    }

    public ColumnVar getVar(String name) {
        return this.getVarForChildren(name);
    }

    public void addJoin(FromItem join) {
        this.joins.add(join);
        this.joinAdded(join);
    }

    public void addJoinBefore(FromItem valueJoin, FromItem join) {
        int n = this.joins.size();
        for (int i = 0; i < n; ++i) {
            if (this.joins.get(i) != join) continue;
            this.joins.add(i, valueJoin);
            this.joinAdded(valueJoin);
            return;
        }
        this.addJoin(valueJoin);
    }

    protected void joinAdded(FromItem valueJoin) {
        valueJoin.setParentNode(this);
    }

    public FromItem getFromItem(String alias) {
        if (this.alias.equals(alias)) {
            return this;
        }
        for (FromItem join : this.joins) {
            FromItem result = join.getFromItem(alias);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public void removeFilter(SqlExpr sqlExpr) {
        for (int i = this.filters.size() - 1; i >= 0; --i) {
            if (this.filters.get(i) != sqlExpr) continue;
            this.filters.remove(i);
            break;
        }
    }

    public List<ColumnVar> appendVars(List<ColumnVar> vars) {
        for (FromItem join : this.joins) {
            join.appendVars(vars);
        }
        return vars;
    }

    @Override
    public String getSignature() {
        StringBuilder sb = new StringBuilder();
        if (this.left) {
            sb.append("LEFT ");
        }
        sb.append(super.getSignature());
        sb.append(" ").append(this.alias);
        return sb.toString();
    }

    @Override
    public FromItem clone() {
        FromItem clone = (FromItem)super.clone();
        clone.joins = new ArrayList<FromItem>();
        for (FromItem join : this.joins) {
            clone.addJoin(join.clone());
        }
        clone.filters = new ArrayList<SqlExpr>();
        for (SqlExpr expr : this.filters) {
            clone.addFilter(expr.clone());
        }
        return clone;
    }

    @Override
    public <X extends Exception> void visitChildren(QueryModelVisitor<X> visitor) throws X {
        super.visitChildren(visitor);
        for (FromItem join : new ArrayList<FromItem>(this.joins)) {
            join.visit(visitor);
        }
        for (SqlExpr expr : new ArrayList<SqlExpr>(this.filters)) {
            expr.visit(visitor);
        }
    }

    @Override
    public void replaceChildNode(QueryModelNode current, QueryModelNode replacement) {
        int i;
        int n = this.joins.size();
        for (i = 0; i < n; ++i) {
            if (current != this.joins.get(i)) continue;
            this.joins.set(i, (FromItem)replacement);
            this.joinAdded((FromItem)replacement);
            return;
        }
        n = this.filters.size();
        for (i = 0; i < n; ++i) {
            if (current != this.filters.get(i)) continue;
            this.filters.set(i, (SqlExpr)replacement);
            replacement.setParentNode(this);
            return;
        }
        super.replaceChildNode(current, replacement);
    }
}

