.\" $XFree86: xc/programs/Xserver/hw/xfree86/input/fpit/fpit.man,v 1.1 2002/11/22 03:35:12 dawes Exp $ 
.\" shorthand for double quote that works everywhere.
.ds q \N'34'
.TH FPIT __drivermansuffix__ __vendorversion__
.SH NAME
fpit \- Fujitsu Stylistic input driver
.SH SYNOPSIS
.nf
.B "Section \*qInputDevice\*q"
.BI "  Identifier \*q" idevname \*q
.B  "  Driver \*qfpit\*q"
.BI "  Option \*qDevice\*q   \*q" devpath \*q
\ \ ...
.B EndSection
.fi
.SH DESCRIPTION
.B fpit 
is an __xservername__ input driver for Fujitsu Stylistic Tablet PCs.
.PP
The
.B fpit
driver functions as a pointer input device, and may be used as the
X server's core pointer.
.SH SUPPORTED HARDWARE
This driver supports the touchscreen of the Stylistic LT and (with
special options) of the Stylistic 500, 1000, 1200, 2300, and 3400.
Modern FinePoint MP800 devices will also work with this driver.

Under Linux the Fujitsu's serial port is not, by default, detected.
Therefore the port must be configured manually as described in the
accompanying readme.txt file.

For example, add the following to your startup scripts for Stylistic xx00
devices:

.TP 4
.B setserial /dev/ttyS3 autoconfig
.TP 4
.B setserial /dev/ttyS3 IRQ 15 baud_base 115200 port 0xfce8
.PP
This driver now supports Stylistic 3400 (and possibly other passive-pen
systems) with a special \fI"Passive"\fP paramter. Try this serial
configuration for the 3400:

.TP 4
.B setserial /dev/ttyS3 autoconfig
.TP 4
.B setserial /dev/ttyS3 uart 16450 irq 5 port 0xfd68

.SH CONFIGURATION DETAILS
Please refer to __xconfigfile__(5x) for general configuration
details and for options that can be used with all input drivers.  This
section only covers configuration details specific to this driver.
.PP
The device supports the following options:
.RS 8
.TP 4
.B Option \fI"MaximumXPosition"\fP \fI"number"\fP
Sets the maximum X position, use this to calibrate your touchscreen's
right hand edge.
.TP 4
.B Option \fI"MinimumXPosition"\fP \fI"number"\fP
Sets the minimum X position, use this to calibrate your touchscreen's
left hand edge.
.TP 4
.B Option \fI"MaximumYPosition"\fP \fI"number"\fP
.TP 4
.B Option \fI"MinimumYPosition"\fP \fI"number"\fP
Same as for X axis, but for Y axis.
.TP 4
.B Option \fI"InvertX"\fP
.TP 4
.B Option \fI"InvertY"\fP
Invert the specified axis.
.TP 4
.B Option \fI"SwapXY"\fP
Swap the X and Y axis (after inversions).
.TP 4
.B Option \fI"Rotate"\fP \fI"CW"\fP
.B Option \fI"Rotate"\fP \fI"CWW"\fP
Manipulate the invert and swap options to match screen
rotations. (Will behave strangely if combined with invert or swap options.)
New users should consider the \fI"TrackRandR"\fP option instead.
.TP 4
.B Option \fI"DeviceName"\fP \fI"name"\fP
.B Option \fI"DeviceName"\fP \fI"name"\fP
sets the name of the X device.
.TP 4
.B Option \fI"AlwaysCore"\fP \fI"on"\fP
enables the sharing of the core pointer. When this feature is enabled, the
device will take control of the core pointer (and thus will emit core events)
and at the same time will be able, when asked so, to report extended events.
You can use the last available integer feedback to control this feature. When
the value of the feedback is zero, the feature is disabled. The feature is
enabled for any other value.
.TP 4
.B Option \fI"DebugLevel"\fP \fInumber \fP
sets the level of debugging info reported.
.TP 4
.B Option \fI"BaudRate"\fP \fI"38400"\fP, \fI"19200"\fP (default) or \fI"9600"\fP
changes the serial link speed.
.TP 4
.B Option \fI"Passive"\fP
decodes the passive pen.
.B Option \fI"TrackRandR"\fP
automatically keeps the cursor synchronized with the pen's position, even when
the screen is resized or rotated. (Recommended for tablet PC's.)
.RE

Example, for Stylistic LT setup is:
.nf
.B "Section \*qInputDevice\*q"
.BI "  Identifier \*q" mouse0 \*q
.B  "  Driver \*qfpit\*q"
.BI "  Option \*qDevice\*q   \*q"/dev/ttyS3 \*q
.BI "  # Option \*qTrackRandR\*q"
.B EndSection
.fi

And for other Stylistic devices try:
.nf
.B "Section \*qInputDevice\*q"
.BI "  Identifier \*q" mouse0 \*q
.B  "  Driver \*qfpit\*q"
.BI "  Option \*qDevice\*q   \*q"/dev/ttyS3 \*q
.BI "  Option \*qBaudRate\*q \*q"19200 \*q
.BI "  Option \*qMaximumXPosition\*q \*q"6250 \*q
.BI "  Option \*qMaximumYPosition\*q \*q"4950 \*q
.BI "  Option \*qMinimumXPosition\*q \*q"130 \*q
.BI "  Option \*qMinimumYPosition\*q \*q"0 \*q
.BI "  Option \*qInvertY\*q"
.BI "  # Option \*qTrackRandR\*q"
.B EndSection
.fi

For Stylistic 3400:
.nf
.B "Section \*qInputDevice\*q"
.BI "  Identifier \*q" mouse0 \*q
.B  "  Driver \*qfpit\*q"
.BI "  Option \*qDevice\*q   \*q"/dev/ttyS3 \*q
.BI "  Option \*qBaudRate\*q \*q"9600 \*q
.BI "  Option \*qMaximumXPosition\*q \*q"4070 \*q
.BI "  Option \*qMaximumYPosition\*q \*q"4020 \*q
.BI "  Option \*qMinimumXPosition\*q \*q"0 \*q
.BI "  Option \*qMinimumYPosition\*q \*q"0 \*q
.BI "  Option \*qPassive\*q"
.BI "  Option \*qSendCoreEvents\*q"
.BI "  # Option \*qTrackRandR\*q"
.B EndSection
.fi

.SH "SEE ALSO"
__xservername__(__appmansuffix__), __xconfigfile__(__filemansuffix__), xorgconfig(__appmansuffix__), Xserver(__appmansuffix__), X(__miscmansuffix__).
.SH AUTHORS
Original FPIT port:
Rob Tsuk <rob@tsuk.com> and John Apfelbaum <johnapf@linuxslate.com>

X4 Port: Richard Miller-Smith <richard.miller-smith@philips.com>,
based on Elographics code from: Patrick Lecoanet

X4.2 Cleanup: Alan Cox
