/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.core.ui.components;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JSplitPane;
import javax.swing.plaf.basic.BasicSplitPaneUI;

class JExtendedSplitPane
extends JSplitPane {
    private transient ComponentListener splitPaneComponentListener = new SplitPaneComponentListener();
    private double dividerLocation;
    private int customDividerSize;
    private double requestedDividerLocation = -1.0;

    public Dimension getSize() {
        Dimension size = super.getSize();
        if (size.width > 0 && size.height > 0 && this.requestedDividerLocation != -1.0) {
            this.setDividerLocation(this.requestedDividerLocation);
            this.requestedDividerLocation = -1.0;
            this.updateVisibility();
        }
        return size;
    }

    public JExtendedSplitPane(int newOrientation, Component newLeftComponent, Component newRightComponent) {
        this(newOrientation, false, newLeftComponent, newRightComponent);
    }

    public JExtendedSplitPane(int newOrientation, boolean newContinuousLayout, Component newLeftComponent, Component newRightComponent) {
        super(newOrientation, newContinuousLayout, newLeftComponent, newRightComponent);
        this.registerListeners(newLeftComponent);
        this.registerListeners(newRightComponent);
        this.updateVisibility();
        if (!newLeftComponent.isVisible()) {
            this.computeDividerLocationWhenInitiallyHidden(newLeftComponent);
        }
        if (!newRightComponent.isVisible()) {
            this.computeDividerLocationWhenInitiallyHidden(newRightComponent);
        }
    }

    public void setBottomComponent(Component comp) {
        this.setRightComponent(comp);
    }

    public void setDividerSize(int newSize) {
        super.setDividerSize(newSize);
        this.customDividerSize = newSize;
    }

    public void setDividerLocation(double requestedDividerLocation) {
        Component divider = this.getDivider();
        if (this.isVisible() && divider.isVisible()) {
            super.setDividerLocation(requestedDividerLocation);
        } else if (this.isVisible()) {
            this.dividerLocation = requestedDividerLocation;
        } else if (!this.isVisible()) {
            this.requestedDividerLocation = requestedDividerLocation;
        }
    }

    public void setLeftComponent(Component comp) {
        if (this.getLeftComponent() != null) {
            this.unregisterListeners(this.getLeftComponent());
        }
        super.setLeftComponent(comp);
        if (this.getLeftComponent() != null) {
            this.registerListeners(this.getLeftComponent());
        }
        this.updateVisibility();
    }

    public void setRightComponent(Component comp) {
        if (this.getRightComponent() != null) {
            this.unregisterListeners(this.getRightComponent());
        }
        super.setRightComponent(comp);
        if (this.getRightComponent() != null) {
            this.registerListeners(this.getRightComponent());
        }
        this.updateVisibility();
    }

    public void setTopComponent(Component comp) {
        this.setLeftComponent(comp);
    }

    private Component getDivider() {
        if (this.getUI() == null) {
            return null;
        }
        return ((BasicSplitPaneUI)this.getUI()).getDivider();
    }

    private Component getFirstComponent() {
        if (this.getOrientation() == 1) {
            return this.getLeftComponent();
        }
        return this.getTopComponent();
    }

    private Component getSecondComponent() {
        if (this.getOrientation() == 1) {
            return this.getRightComponent();
        }
        return this.getBottomComponent();
    }

    private void computeDividerLocationWhenHidden(Component hiddenComponent) {
        if (this.getTopComponent().isVisible() || this.getBottomComponent().isVisible()) {
            this.dividerLocation = this.getOrientation() == 1 ? (hiddenComponent == this.getFirstComponent() ? (double)hiddenComponent.getSize().width / (this.getSize().getWidth() - (double)this.customDividerSize) : (this.getSize().getWidth() - (double)this.customDividerSize - (double)hiddenComponent.getSize().width) / (this.getSize().getWidth() - (double)this.customDividerSize)) : (hiddenComponent == this.getFirstComponent() ? (double)hiddenComponent.getSize().height / (this.getSize().getHeight() - (double)this.customDividerSize) : (this.getSize().getHeight() - (double)this.customDividerSize - (double)hiddenComponent.getSize().height) / (this.getSize().getHeight() - (double)this.customDividerSize));
        }
    }

    private void computeDividerLocationWhenInitiallyHidden(Component hiddenComponent) {
        if (this.getTopComponent().isVisible() || this.getBottomComponent().isVisible()) {
            this.dividerLocation = this.getOrientation() == 1 ? (hiddenComponent == this.getFirstComponent() ? (double)hiddenComponent.getPreferredSize().width / (this.getPreferredSize().getWidth() - (double)this.customDividerSize) : (this.getPreferredSize().getWidth() - (double)this.customDividerSize - (double)hiddenComponent.getPreferredSize().width) / (this.getPreferredSize().getWidth() - (double)this.customDividerSize)) : (hiddenComponent == this.getFirstComponent() ? (double)hiddenComponent.getPreferredSize().height / (this.getPreferredSize().getHeight() - (double)this.customDividerSize) : (this.getPreferredSize().getHeight() - (double)this.customDividerSize - (double)hiddenComponent.getPreferredSize().height) / (this.getPreferredSize().getHeight() - (double)this.customDividerSize));
        }
    }

    private void registerListeners(Component component) {
        if (this.splitPaneComponentListener != null) {
            component.addComponentListener(this.splitPaneComponentListener);
        }
    }

    private void unregisterListeners(Component component) {
        if (this.splitPaneComponentListener != null) {
            component.removeComponentListener(this.splitPaneComponentListener);
        }
    }

    private void updateVisibility() {
        Component firstComponent = this.getFirstComponent();
        Component secondComponent = this.getSecondComponent();
        Component divider = this.getDivider();
        if (firstComponent == null || secondComponent == null || divider == null) {
            return;
        }
        if (firstComponent.isVisible() && secondComponent.isVisible()) {
            if (!divider.isVisible()) {
                JExtendedSplitPane.super.setDividerSize(this.customDividerSize);
                divider.setVisible(true);
                this.setDividerLocation(this.dividerLocation);
            }
            if (!this.isVisible()) {
                this.setVisible(true);
            }
        } else if (!firstComponent.isVisible() && !secondComponent.isVisible()) {
            if (this.isVisible()) {
                this.setVisible(false);
            }
        } else {
            if (divider.isVisible()) {
                JExtendedSplitPane.super.setDividerSize(0);
                divider.setVisible(false);
                this.setDividerLocation(0);
            }
            if (!this.isVisible()) {
                this.setVisible(true);
            }
        }
        if (this.getParent() != null) {
            this.getParent().doLayout();
        }
    }

    private class SplitPaneComponentListener
    extends ComponentAdapter {
        private SplitPaneComponentListener() {
        }

        public void componentHidden(ComponentEvent e) {
            JExtendedSplitPane.this.computeDividerLocationWhenHidden(e.getComponent());
            if (JExtendedSplitPane.this.dividerLocation == 0.0 || JExtendedSplitPane.this.dividerLocation == 1.0) {
                JExtendedSplitPane.this.dividerLocation = 0.5;
            }
            JExtendedSplitPane.this.updateVisibility();
        }

        public void componentShown(ComponentEvent e) {
            JExtendedSplitPane.this.updateVisibility();
        }
    }
}

